/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import org.apache.fop.dom.svg.SVGArea;
import org.apache.fop.image.ImageArea;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.ForeignObjectArea;
import org.apache.fop.layout.InlineArea;
import org.apache.fop.layout.InlineSpace;
import org.apache.fop.layout.LeaderArea;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.Page;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.pdf.FontSetup;

public class XMLRenderer
implements Renderer {
    protected int indent = 0;
    protected String producer;
    protected PrintWriter writer;

    public void render(AreaTree areaTree, PrintWriter printWriter) throws IOException {
        MessageHandler.logln("rendering areas to XML");
        this.writer = printWriter;
        this.writer.write("<?xml version=\"1.0\"?>\n<!-- produced by " + this.producer + " -->\n");
        this.writeStartTag("<AreaTree>");
        Enumeration enumeration = areaTree.getPages().elements();
        while (enumeration.hasMoreElements()) {
            this.renderPage((Page)enumeration.nextElement());
        }
        this.writeEndTag("</AreaTree>");
        this.writer.flush();
        MessageHandler.errorln("written out XML");
    }

    public void renderAreaContainer(AreaContainer areaContainer) {
        this.writeStartTag("<AreaContainer>");
        Enumeration enumeration = areaContainer.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        this.writeEndTag("</AreaContainer>");
    }

    public void renderBlockArea(BlockArea blockArea) {
        this.writeStartTag("<BlockArea start-indent=\"" + blockArea.getStartIndent() + "\" end-indent=\"" + blockArea.getEndIndent() + "\">");
        Enumeration enumeration = blockArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        this.writeEndTag("</BlockArea>");
    }

    public void renderDisplaySpace(DisplaySpace displaySpace) {
        this.writeEmptyElementTag("<DisplaySpace size=\"" + displaySpace.getSize() + "\"/>");
    }

    public void renderForeignObjectArea(ForeignObjectArea foreignObjectArea) {
        foreignObjectArea.getObject().render(this);
    }

    public void renderImageArea(ImageArea imageArea) {
        this.writeEmptyElementTag("<ImageArea/>");
    }

    public void renderInlineArea(InlineArea inlineArea) {
        String string = inlineArea.getFontState().getFontWeight();
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = inlineArea.getText();
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            stringBuffer = c > '\u007f' ? stringBuffer.append("&#" + c + ";") : stringBuffer.append(c);
            ++n2;
        }
        this.writeElement("<InlineArea font-weight=\"" + string + "\" red=\"" + inlineArea.getRed() + "\" green=\"" + inlineArea.getGreen() + "\" blue = \"" + inlineArea.getBlue() + "\" width = \"" + inlineArea.getContentWidth() + "\">" + stringBuffer.toString() + "</InlineArea>");
    }

    public void renderInlineSpace(InlineSpace inlineSpace) {
        this.writeEmptyElementTag("<InlineSpace size=\"" + inlineSpace.getSize() + "\"/>");
    }

    public void renderLeaderArea(LeaderArea leaderArea) {
        String string = "";
        switch (leaderArea.getLeaderPattern()) {
            case 1: {
                string = "space";
                break;
            }
            case 2: {
                string = "rule";
                break;
            }
            case 3: {
                string = "dots";
                break;
            }
            case 4: {
                string = "use-content";
                break;
            }
        }
        this.writeEmptyElementTag("<Leader leader-pattern=\"" + string + " leader-length=\"" + leaderArea.getLeaderLength() + "\" rule-thickness=\"" + leaderArea.getRuleThickness() + "\" rule-style=\"" + leaderArea.getRuleStyle() + "\" red=\"" + leaderArea.getRed() + "\" green=\"" + leaderArea.getGreen() + "\" blue = \"" + leaderArea.getBlue() + "\"/>");
    }

    public void renderLineArea(LineArea lineArea) {
        String string = lineArea.getFontState().getFontWeight();
        this.writeStartTag("<LineArea font-weight=\"" + string + "\">");
        Enumeration enumeration = lineArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        this.writeEndTag("</LineArea>");
    }

    public void renderPage(Page page) {
        this.writeStartTag("<Page>");
        AreaContainer areaContainer = page.getBody();
        AreaContainer areaContainer2 = page.getBefore();
        AreaContainer areaContainer3 = page.getAfter();
        if (areaContainer2 != null) {
            this.renderAreaContainer(areaContainer2);
        }
        this.renderAreaContainer(areaContainer);
        if (areaContainer3 != null) {
            this.renderAreaContainer(areaContainer3);
        }
        this.writeEndTag("</Page>");
    }

    public void renderSVGArea(SVGArea sVGArea) {
        this.writeEmptyElementTag("<SVG/>");
    }

    public void setProducer(String string) {
        this.producer = string;
    }

    public void setupFontInfo(FontInfo fontInfo) {
        FontSetup.setup(fontInfo);
    }

    protected void writeElement(String string) {
        this.writeIndent();
        this.writer.write(String.valueOf(string) + "\n");
    }

    protected void writeEmptyElementTag(String string) {
        this.writeIndent();
        this.writer.write(String.valueOf(string) + "\n");
    }

    protected void writeEndTag(String string) {
        --this.indent;
        this.writeIndent();
        this.writer.write(String.valueOf(string) + "\n");
    }

    protected void writeIndent() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.indent) {
            stringBuffer = stringBuffer.append("  ");
            ++n;
        }
        this.writer.write(stringBuffer.toString());
    }

    protected void writeStartTag(String string) {
        this.writeIndent();
        this.writer.write(String.valueOf(string) + "\n");
        ++this.indent;
    }
}

