/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.dtd.app;

import com.thaiopensource.xml.dtd.app.NameMapper;
import com.thaiopensource.xml.dtd.app.XmlOutputCollection;
import com.thaiopensource.xml.dtd.app.XmlOutputMember;
import com.thaiopensource.xml.dtd.app.XmlOutputStreamWriter;
import com.thaiopensource.xml.out.XmlWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;

class DirectoryOutputCollection
implements XmlOutputCollection {
    private final XmlOutputMember mainMember;
    private final File dir;
    private final NameMapper nameMapper;
    private final Hashtable nameTable = new Hashtable();
    private final String newline = System.getProperty("line.separator");

    DirectoryOutputCollection(String string, File file, NameMapper nameMapper) throws IOException {
        this.dir = file;
        this.nameMapper = nameMapper;
        this.mainMember = this.mapUri(string);
    }

    DirectoryOutputCollection(String string, File file) throws IOException {
        this(string, file, null);
    }

    public XmlOutputMember getMain() {
        return this.mainMember;
    }

    public XmlOutputMember mapUri(String string) throws IOException {
        String string2 = new URL(string).getFile();
        int n = string2.lastIndexOf(47);
        if (n >= 0) {
            string2 = string2.substring(n + 1);
        }
        if ((string2 = new File(string2).getName()).length() == 0) {
            throw new IOException("empty file name");
        }
        if (this.nameMapper != null) {
            string2 = this.nameMapper.mapName(string2);
        }
        if (this.nameTable.get(string2) != null) {
            String string3;
            String string4;
            int n2 = string2.lastIndexOf(46);
            if (n2 < 0) {
                string4 = string2;
                string3 = "";
            } else {
                string4 = string2.substring(0, n2);
                string3 = string2.substring(n2);
            }
            int n3 = 1;
            while (this.nameTable.get(string2 = string4 + Integer.toString(n3) + string3) != null) {
                ++n3;
            }
        }
        this.nameTable.put(string2, string2);
        return new Member(new File(this.dir, string2));
    }

    private class Member
    implements XmlOutputMember {
        private final File file;

        Member(File file) {
            this.file = file;
        }

        public String getSystemId(XmlOutputMember xmlOutputMember) {
            return this.file.getName();
        }

        public XmlWriter open(String string) throws IOException {
            XmlOutputStreamWriter xmlOutputStreamWriter = new XmlOutputStreamWriter(new FileOutputStream(this.file), string);
            if (DirectoryOutputCollection.this.newline != null) {
                xmlOutputStreamWriter.setNewline(DirectoryOutputCollection.this.newline);
            }
            return xmlOutputStreamWriter;
        }
    }
}

