/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.dtd.app;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.OptionParser;
import com.thaiopensource.xml.dtd.app.DirectoryOutputCollection;
import com.thaiopensource.xml.dtd.app.ErrorMessage;
import com.thaiopensource.xml.dtd.app.ErrorMessageHandler;
import com.thaiopensource.xml.dtd.app.ExtensionMapper;
import com.thaiopensource.xml.dtd.app.RelaxNgWriter;
import com.thaiopensource.xml.dtd.app.SchemaWriter;
import com.thaiopensource.xml.dtd.app.UriEntityManager;
import com.thaiopensource.xml.dtd.app.XmlOutputStreamWriter;
import com.thaiopensource.xml.dtd.om.Dtd;
import com.thaiopensource.xml.dtd.parse.DtdParserImpl;
import com.thaiopensource.xml.em.EntityManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.Properties;

public class Driver {
    private static final int FAILURE_EXIT_CODE = 1;
    static /* synthetic */ Class class$com$thaiopensource$xml$dtd$app$Driver;

    public static void main(String[] stringArray) {
        try {
            if (Driver.doMain(stringArray)) {
                return;
            }
        }
        catch (IOException iOException) {
            Driver.error(iOException.getMessage());
        }
        System.exit(1);
    }

    public static boolean doMain(String[] stringArray) throws IOException {
        OptionParser optionParser = new OptionParser("r:", stringArray);
        File file = null;
        try {
            while (optionParser.moveToNextOption()) {
                switch (optionParser.getOptionChar()) {
                    case 'r': {
                        if (file != null) {
                            Driver.error(Driver.localizer().message("DUPLICATE_OPTION", "r"));
                            return false;
                        }
                        file = new File(optionParser.getOptionArg());
                        if (file.isDirectory()) break;
                        if (file.exists()) {
                            Driver.error(Driver.localizer().message("NOT_DIRECTORY", stringArray[1]));
                            return false;
                        }
                        if (file.mkdirs()) break;
                        Driver.error(Driver.localizer().message("CANNOT_MKDIR", stringArray[1]));
                        return false;
                    }
                }
            }
        }
        catch (OptionParser.InvalidOptionException invalidOptionException) {
            Driver.error(Driver.localizer().message("INVALID_OPTION", optionParser.getOptionCharString()));
            Driver.usage();
            return false;
        }
        catch (OptionParser.MissingArgumentException missingArgumentException) {
            Driver.error(Driver.localizer().message("OPTION_MISSING_ARGUMENT", optionParser.getOptionCharString()));
            Driver.usage();
            return false;
        }
        stringArray = optionParser.getRemainingArgs();
        if (stringArray.length == 0) {
            Driver.error(Driver.localizer().message("MISSING_ARGUMENT"));
            Driver.usage();
            return false;
        }
        if (stringArray.length > 1) {
            Driver.error(Driver.localizer().message("TOO_MANY_ARGUMENTS"));
            Driver.usage();
            return false;
        }
        String string = UriEntityManager.commandLineArgToUri(stringArray[0]);
        Dtd dtd = new DtdParserImpl().parse(string, (EntityManager)new UriEntityManager());
        if (file == null) {
            XmlOutputStreamWriter xmlOutputStreamWriter = new XmlOutputStreamWriter(System.out, dtd.getEncoding());
            new SchemaWriter(xmlOutputStreamWriter).writeDtd(dtd);
            xmlOutputStreamWriter.close();
            return true;
        }
        ExtensionMapper extensionMapper = new ExtensionMapper(".dtd", ".rng");
        DirectoryOutputCollection directoryOutputCollection = new DirectoryOutputCollection(dtd.getUri(), file, extensionMapper);
        RelaxNgWriter relaxNgWriter = new RelaxNgWriter(directoryOutputCollection);
        ErrorMessageHandlerImpl errorMessageHandlerImpl = new ErrorMessageHandlerImpl();
        String string2 = Driver.localizer().message("COMMENT", Driver.getVersion());
        if (string2.length() != 0) {
            relaxNgWriter.setInitialComment(" " + string2 + " ");
        }
        relaxNgWriter.setErrorMessageHandler(errorMessageHandlerImpl);
        relaxNgWriter.writeDtd(dtd);
        return errorMessageHandlerImpl.errorCount == 0;
    }

    private static void usage() {
        Driver.print(Driver.localizer().message("USAGE", Driver.getVersion()));
    }

    private static Localizer localizer() {
        return RelaxNgWriter.localizer;
    }

    private static void error(String string) {
        Driver.print(Driver.localizer().message("ERROR", string));
    }

    private static void warning(String string) {
        Driver.print(Driver.localizer().message("WARNING", string));
    }

    private static void print(String string) {
        System.err.println(string);
    }

    private static String getVersion() {
        InputStream inputStream = (class$com$thaiopensource$xml$dtd$app$Driver == null ? (class$com$thaiopensource$xml$dtd$app$Driver = Driver.class$("com.thaiopensource.xml.dtd.app.Driver")) : class$com$thaiopensource$xml$dtd$app$Driver).getResourceAsStream("resources/Version.properties");
        if (inputStream != null) {
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
                String string = properties.getProperty("version");
                if (string != null) {
                    return string;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new MissingResourceException("no version property", (class$com$thaiopensource$xml$dtd$app$Driver == null ? (class$com$thaiopensource$xml$dtd$app$Driver = Driver.class$("com.thaiopensource.xml.dtd.app.Driver")) : class$com$thaiopensource$xml$dtd$app$Driver).getName(), "version");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ErrorMessageHandlerImpl
    implements ErrorMessageHandler {
        private int errorCount = 0;

        private ErrorMessageHandlerImpl() {
        }

        public void message(ErrorMessage errorMessage) {
            switch (errorMessage.getSeverity()) {
                case 1: {
                    Driver.error(errorMessage.getMessage());
                    break;
                }
                case 0: {
                    ++this.errorCount;
                    Driver.warning(errorMessage.getMessage());
                }
            }
        }
    }
}

