/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.dtd.app;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.xml.dtd.app.ErrorMessage;
import com.thaiopensource.xml.dtd.app.ErrorMessageHandler;
import com.thaiopensource.xml.dtd.app.XmlOutputCollection;
import com.thaiopensource.xml.dtd.app.XmlOutputMember;
import com.thaiopensource.xml.dtd.om.AttributeDefault;
import com.thaiopensource.xml.dtd.om.AttributeGroup;
import com.thaiopensource.xml.dtd.om.AttributeGroupMember;
import com.thaiopensource.xml.dtd.om.AttributeGroupVisitor;
import com.thaiopensource.xml.dtd.om.Datatype;
import com.thaiopensource.xml.dtd.om.DatatypeVisitor;
import com.thaiopensource.xml.dtd.om.Def;
import com.thaiopensource.xml.dtd.om.Dtd;
import com.thaiopensource.xml.dtd.om.EnumGroup;
import com.thaiopensource.xml.dtd.om.EnumGroupVisitor;
import com.thaiopensource.xml.dtd.om.Flag;
import com.thaiopensource.xml.dtd.om.ModelGroup;
import com.thaiopensource.xml.dtd.om.ModelGroupVisitor;
import com.thaiopensource.xml.dtd.om.NameSpec;
import com.thaiopensource.xml.dtd.om.TokenizedDatatype;
import com.thaiopensource.xml.dtd.om.TopLevel;
import com.thaiopensource.xml.dtd.om.TopLevelVisitor;
import com.thaiopensource.xml.em.ExternalId;
import com.thaiopensource.xml.out.XmlWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class RelaxNgWriter {
    static Localizer localizer = new Localizer(class$com$thaiopensource$xml$dtd$app$RelaxNgWriter == null ? (class$com$thaiopensource$xml$dtd$app$RelaxNgWriter = RelaxNgWriter.class$("com.thaiopensource.xml.dtd.app.RelaxNgWriter")) : class$com$thaiopensource$xml$dtd$app$RelaxNgWriter);
    private XmlOutputCollection outCollection;
    private XmlWriter w;
    private XmlOutputMember outMember;
    private boolean hadAny = false;
    private boolean hadDefaultValue = false;
    private Hashtable elementNameTable = new Hashtable();
    private Hashtable defTable = new Hashtable();
    private Hashtable prefixTable = new Hashtable();
    private ErrorMessageHandler errorMessageHandler = null;
    private String initialComment = null;
    private Hashtable duplicateAttributeTable = new Hashtable();
    private Hashtable currentDuplicateAttributeTable = null;
    private String defaultNamespace = null;
    private String annotationPrefix = null;
    private Output groupOutput = new GroupOutput();
    private Output choiceOutput = new ChoiceOutput();
    private Output explicitOutput = new Output();
    private String colonReplacement = null;
    private String elementDeclPattern;
    private String attlistDeclPattern;
    private String anyName;
    private static final int ELEMENT_DECL = 1;
    private static final int ATTLIST_DECL = 2;
    private static final int ELEMENT_REF = 4;
    private static final String SEPARATORS = ".-_";
    private static final String COMPATIBILITY_ANNOTATIONS_URI = "http://relaxng.org/ns/compatibility/annotations/1.0";
    private static final String DEFAULT_PATTERN = "#.%";
    private String[] ELEMENT_KEYWORDS = new String[]{"element", "elem", "e"};
    private String[] ATTLIST_KEYWORDS = new String[]{"attlist", "attributes", "attribs", "atts", "a"};
    private String[] ANY_KEYWORDS = new String[]{"any", "ANY", "anyElement"};
    static /* synthetic */ Class class$com$thaiopensource$xml$dtd$app$RelaxNgWriter;

    public RelaxNgWriter(XmlOutputCollection xmlOutputCollection) {
        this.outCollection = xmlOutputCollection;
    }

    public void setErrorMessageHandler(ErrorMessageHandler errorMessageHandler) {
        this.errorMessageHandler = errorMessageHandler;
    }

    public void setInitialComment(String string) {
        this.initialComment = string;
    }

    public void writeDtd(Dtd dtd) throws IOException {
        try {
            dtd.accept(new Analyzer());
        }
        catch (Exception exception) {
            throw (RuntimeException)exception;
        }
        this.chooseNames();
        this.outMember = this.outCollection.getMain();
        this.w = this.outMember.open(dtd.getEncoding());
        this.w.writeXmlDecl(dtd.getEncoding());
        if (this.initialComment != null) {
            this.w.comment(this.initialComment);
        }
        this.startGrammar();
        try {
            dtd.accept(this.explicitOutput);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (IOException)exception;
        }
        this.outputUndefinedElements();
        this.outputStart();
        this.endGrammar();
        this.w.close();
    }

    private void chooseNames() {
        this.chooseAny();
        this.chooseColonReplacement();
        this.chooseDeclPatterns();
        this.chooseAnnotationPrefix();
    }

    private void chooseAny() {
        if (!this.hadAny) {
            return;
        }
        int n = 0;
        while (true) {
            int n2 = 0;
            while (n2 < this.ANY_KEYWORDS.length) {
                this.anyName = RelaxNgWriter.repeatChar('_', n) + this.ANY_KEYWORDS[n2];
                if (this.defTable.get(this.anyName) == null) {
                    this.defTable.put(this.anyName, this.anyName);
                    return;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void chooseAnnotationPrefix() {
        if (!this.hadDefaultValue) {
            return;
        }
        int n = 0;
        while (true) {
            this.annotationPrefix = RelaxNgWriter.repeatChar('_', n) + "a";
            if (this.prefixTable.get(this.annotationPrefix) == null) {
                return;
            }
            ++n;
        }
    }

    private void chooseColonReplacement() {
        if (this.colonReplacementOk()) {
            return;
        }
        int n = 1;
        while (true) {
            int n2 = 0;
            while (n2 < SEPARATORS.length()) {
                this.colonReplacement = RelaxNgWriter.repeatChar(SEPARATORS.charAt(n2), n);
                if (this.colonReplacementOk()) {
                    return;
                }
                ++n2;
            }
            ++n;
        }
    }

    private boolean colonReplacementOk() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = this.elementNameTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = this.mungeQName((String)enumeration.nextElement());
            if (hashtable.get(string) != null) {
                return false;
            }
            hashtable.put(string, string);
        }
        return true;
    }

    private void chooseDeclPatterns() {
        String string = this.namingPattern();
        this.elementDeclPattern = this.patternOk("%") ? "%" : this.choosePattern(string, this.ELEMENT_KEYWORDS);
        this.attlistDeclPattern = this.choosePattern(string, this.ATTLIST_KEYWORDS);
    }

    private String choosePattern(String string, String[] stringArray) {
        while (true) {
            int n = 0;
            while (n < stringArray.length) {
                String string2 = RelaxNgWriter.substitute(string, '#', stringArray[n]);
                if (this.patternOk(string2)) {
                    return string2;
                }
                ++n;
            }
            string = string.substring(0, 1) + string.substring(1, 2) + string.substring(1, 2) + string.substring(2);
        }
    }

    private String namingPattern() {
        int n;
        String string;
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.defTable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            n = 0;
            while (n < SEPARATORS.length()) {
                char c = SEPARATORS.charAt(n);
                int n2 = string.indexOf(c);
                if (n2 > 0) {
                    RelaxNgWriter.inc(hashtable, string.substring(0, n2 + 1) + "%");
                }
                if ((n2 = string.lastIndexOf(c)) >= 0 && n2 < string.length() - 1) {
                    RelaxNgWriter.inc(hashtable, "%" + string.substring(n2));
                }
                ++n;
            }
        }
        string = null;
        n = 0;
        Enumeration enumeration2 = hashtable.keys();
        while (enumeration2.hasMoreElements()) {
            String string2 = (String)enumeration2.nextElement();
            int n3 = (Integer)hashtable.get(string2);
            if (string != null && n3 <= n) continue;
            n = n3;
            string = string2;
        }
        if (string == null) {
            return DEFAULT_PATTERN;
        }
        if (string.charAt(0) == '%') {
            return string.substring(0, 2) + "#";
        }
        return "#" + string.substring(string.length() - 2);
    }

    private static void inc(Hashtable hashtable, String string) {
        Integer n = (Integer)hashtable.get(string);
        if (n == null) {
            hashtable.put(string, new Integer(1));
        } else {
            hashtable.put(string, new Integer(n + 1));
        }
    }

    private boolean patternOk(String string) {
        Enumeration enumeration = this.elementNameTable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = this.mungeQName((String)enumeration.nextElement());
            if (this.defTable.get(RelaxNgWriter.substitute(string, '%', string2)) == null) continue;
            return false;
        }
        return true;
    }

    private void noteDef(String string) {
        this.defTable.put(string, string);
    }

    private void noteElementName(String string, int n) {
        Integer n2 = (Integer)this.elementNameTable.get(string);
        if (n2 != null) {
            if (n2 == (n |= n2.intValue())) {
                return;
            }
        } else {
            this.noteNamePrefix(string);
        }
        this.elementNameTable.put(string, new Integer(n));
    }

    private void noteAttribute(String string, String string2) {
        if (string.equals("xmlns")) {
            if (string2 != null) {
                if (this.defaultNamespace != null && !this.defaultNamespace.equals(string2)) {
                    this.error("INCONSISTENT_DEFAULT_NAMESPACE");
                } else {
                    this.defaultNamespace = string2;
                }
            }
        } else if (string.startsWith("xmlns:")) {
            if (string2 != null) {
                String string3 = string.substring(6);
                String string4 = (String)this.prefixTable.get(string3);
                if (string4 != null && !string4.equals("") && !string4.equals(string2)) {
                    this.error("INCONSISTENT_PREFIX", string3);
                } else if (!string3.equals("xml")) {
                    this.prefixTable.put(string3, string2);
                }
            }
        } else {
            if (string2 != null) {
                this.hadDefaultValue = true;
            }
            this.noteNamePrefix(string);
        }
    }

    private void noteNamePrefix(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return;
        }
        String string2 = string.substring(0, n);
        if (this.prefixTable.get(string2) == null && !string2.equals("xml")) {
            this.prefixTable.put(string2, "");
        }
    }

    private int nameFlags(String string) {
        Integer n = (Integer)this.elementNameTable.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    private String elementDeclName(String string) {
        return RelaxNgWriter.substitute(this.elementDeclPattern, '%', this.mungeQName(string));
    }

    private String attlistDeclName(String string) {
        return RelaxNgWriter.substitute(this.attlistDeclPattern, '%', this.mungeQName(string));
    }

    private String mungeQName(String string) {
        if (this.colonReplacement == null) {
            int n = string.indexOf(58);
            if (n < 0) {
                return string;
            }
            return string.substring(n + 1);
        }
        return RelaxNgWriter.substitute(string, ':', this.colonReplacement);
    }

    private static String repeatChar(char c, int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = c;
            ++n2;
        }
        return new String(cArray);
    }

    private static String substitute(String string, char c, String string2) {
        int n = string.indexOf(c);
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append(string2);
        stringBuffer.append(string.substring(n + 1));
        return stringBuffer.toString();
    }

    private void outputNamespaces() throws IOException {
        Enumeration enumeration = this.prefixTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.prefixTable.get(string);
            if (string2.length() != 0) {
                this.w.attribute("xmlns:" + string, string2);
                continue;
            }
            this.error("UNDECLARED_PREFIX", string);
        }
        if (this.defaultNamespace != null) {
            this.w.attribute("ns", this.defaultNamespace);
        }
    }

    private void outputStart() throws IOException {
        this.w.startElement("start");
        this.w.startElement("choice");
        int n = 5;
        while (true) {
            boolean bl = false;
            Enumeration enumeration = this.elementNameTable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (((Integer)this.elementNameTable.get(string) & n) != 1) continue;
                bl = true;
                this.ref(this.elementDeclName(string));
            }
            if (bl || n == 1) break;
            n = 1;
        }
        this.w.endElement();
        this.w.endElement();
        if (this.anyName != null) {
            this.w.startElement("define");
            this.w.attribute("name", this.anyName);
            this.w.attribute("combine", "choice");
            this.w.startElement("text");
            this.w.endElement();
            this.w.endElement();
        }
    }

    private void outputUndefinedElements() throws IOException {
        Enumeration enumeration = this.elementNameTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (((Integer)this.elementNameTable.get(string) & 1) != 0) continue;
            this.w.startElement("define");
            this.w.attribute("name", this.elementDeclName(string));
            this.w.attribute("combine", "choice");
            this.w.startElement("notAllowed");
            this.w.endElement();
            this.w.endElement();
        }
    }

    private void ref(String string) throws IOException {
        this.w.startElement("ref");
        this.w.attribute("name", string);
        this.w.endElement();
    }

    private void startGrammar() throws IOException {
        this.w.startElement("grammar");
        this.w.attribute("datatypeLibrary", "http://www.w3.org/2001/XMLSchema-datatypes");
        this.w.attribute("xmlns", "http://relaxng.org/ns/structure/1.0");
        if (this.annotationPrefix != null) {
            this.w.attribute("xmlns:" + this.annotationPrefix, COMPATIBILITY_ANNOTATIONS_URI);
        }
        this.outputNamespaces();
    }

    private void endGrammar() throws IOException {
        this.w.endElement();
    }

    private void error(String string) {
        this.reportError(localizer.message(string));
    }

    private void error(String string, String string2) {
        this.reportError(localizer.message(string, string2));
    }

    private void warning(String string) {
        this.reportWarning(localizer.message(string));
    }

    private void warning(String string, String string2) {
        this.reportWarning(localizer.message(string, string2));
    }

    private void reportError(String string) {
        this.report(new ErrorMessage(0, string));
    }

    private void reportWarning(String string) {
        this.report(new ErrorMessage(1, string));
    }

    private void report(ErrorMessage errorMessage) {
        if (this.errorMessageHandler != null) {
            this.errorMessageHandler.message(errorMessage);
        }
    }

    private static String valueType(Datatype datatype) {
        datatype = datatype.deref();
        switch (datatype.getType()) {
            case 0: {
                return "string";
            }
            case 1: {
                return ((TokenizedDatatype)datatype).getTypeName();
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SignificanceDetector
    extends VisitorBase {
        boolean significant = false;

        private SignificanceDetector() {
        }

        public void elementDecl(NameSpec nameSpec, ModelGroup modelGroup) throws Exception {
            this.significant = true;
        }

        public void attlistDecl(NameSpec nameSpec, AttributeGroup attributeGroup) throws Exception {
            this.significant = true;
        }

        public void modelGroupDef(String string, ModelGroup modelGroup) throws Exception {
            this.significant = true;
        }

        public void attributeGroupDef(String string, AttributeGroup attributeGroup) throws Exception {
            this.significant = true;
        }

        public void enumGroupDef(String string, EnumGroup enumGroup) {
            this.significant = true;
        }

        public void datatypeDef(String string, Datatype datatype) {
            this.significant = true;
        }
    }

    private class DuplicateAttributeDetector
    implements AttributeGroupVisitor {
        private boolean containsDuplicate = false;

        private DuplicateAttributeDetector() {
        }

        public void attribute(NameSpec nameSpec, Datatype datatype, AttributeDefault attributeDefault) {
            if (RelaxNgWriter.this.currentDuplicateAttributeTable.get(nameSpec.getValue()) != null) {
                this.containsDuplicate = true;
            }
        }

        public void attributeGroupRef(String string, AttributeGroup attributeGroup) throws Exception {
            attributeGroup.accept(this);
        }
    }

    private class ChoiceOutput
    extends Output {
        private ChoiceOutput() {
        }

        public void choice(ModelGroup[] modelGroupArray) throws Exception {
            if (modelGroupArray.length == 0) {
                super.choice(modelGroupArray);
            } else {
                int n = 0;
                while (n < modelGroupArray.length) {
                    modelGroupArray[n].accept(this);
                    ++n;
                }
            }
        }
    }

    private class GroupOutput
    extends Output {
        private GroupOutput() {
        }

        public void sequence(ModelGroup[] modelGroupArray) throws Exception {
            if (modelGroupArray.length == 0) {
                super.sequence(modelGroupArray);
            } else {
                int n = 0;
                while (n < modelGroupArray.length) {
                    modelGroupArray[n].accept(this);
                    ++n;
                }
            }
        }
    }

    private class Output
    extends VisitorBase
    implements ModelGroupVisitor,
    AttributeGroupVisitor,
    DatatypeVisitor,
    EnumGroupVisitor {
        private Output() {
        }

        public void elementDecl(NameSpec nameSpec, ModelGroup modelGroup) throws Exception {
            RelaxNgWriter.this.w.startElement("define");
            RelaxNgWriter.this.w.attribute("name", RelaxNgWriter.this.elementDeclName(nameSpec.getValue()));
            RelaxNgWriter.this.w.startElement("element");
            RelaxNgWriter.this.w.attribute("name", nameSpec.getValue());
            RelaxNgWriter.this.ref(RelaxNgWriter.this.attlistDeclName(nameSpec.getValue()));
            modelGroup.accept(RelaxNgWriter.this.groupOutput);
            RelaxNgWriter.this.w.endElement();
            RelaxNgWriter.this.w.endElement();
            if ((RelaxNgWriter.this.nameFlags(nameSpec.getValue()) & 2) == 0) {
                RelaxNgWriter.this.w.startElement("define");
                RelaxNgWriter.this.w.attribute("name", RelaxNgWriter.this.attlistDeclName(nameSpec.getValue()));
                RelaxNgWriter.this.w.attribute("combine", "interleave");
                RelaxNgWriter.this.w.startElement("empty");
                RelaxNgWriter.this.w.endElement();
                RelaxNgWriter.this.w.endElement();
            }
            if (RelaxNgWriter.this.anyName != null) {
                RelaxNgWriter.this.w.startElement("define");
                RelaxNgWriter.this.w.attribute("name", RelaxNgWriter.this.anyName);
                RelaxNgWriter.this.w.attribute("combine", "choice");
                RelaxNgWriter.this.ref(RelaxNgWriter.this.elementDeclName(nameSpec.getValue()));
                RelaxNgWriter.this.w.endElement();
            }
        }

        public void attlistDecl(NameSpec nameSpec, AttributeGroup attributeGroup) throws Exception {
            String string = nameSpec.getValue();
            RelaxNgWriter.this.currentDuplicateAttributeTable = (Hashtable)RelaxNgWriter.this.duplicateAttributeTable.get(string);
            if (RelaxNgWriter.this.currentDuplicateAttributeTable == null) {
                RelaxNgWriter.this.currentDuplicateAttributeTable = new Hashtable();
                RelaxNgWriter.this.duplicateAttributeTable.put(string, RelaxNgWriter.this.currentDuplicateAttributeTable);
            }
            RelaxNgWriter.this.w.startElement("define");
            RelaxNgWriter.this.w.attribute("name", RelaxNgWriter.this.attlistDeclName(string));
            RelaxNgWriter.this.w.attribute("combine", "interleave");
            attributeGroup.accept(this);
            RelaxNgWriter.this.w.endElement();
        }

        public void modelGroupDef(String string, ModelGroup modelGroup) throws Exception {
            RelaxNgWriter.this.w.startElement("define");
            RelaxNgWriter.this.w.attribute("name", string);
            modelGroup.accept(RelaxNgWriter.this.groupOutput);
            RelaxNgWriter.this.w.endElement();
        }

        public void attributeGroupDef(String string, AttributeGroup attributeGroup) throws Exception {
            RelaxNgWriter.this.currentDuplicateAttributeTable = new Hashtable();
            RelaxNgWriter.this.w.startElement("define");
            RelaxNgWriter.this.w.attribute("name", string);
            AttributeGroupMember[] attributeGroupMemberArray = attributeGroup.getMembers();
            if (attributeGroupMemberArray.length == 0) {
                RelaxNgWriter.this.w.startElement("empty");
                RelaxNgWriter.this.w.endElement();
            } else {
                int n = 0;
                while (n < attributeGroupMemberArray.length) {
                    attributeGroupMemberArray[n].accept(this);
                    ++n;
                }
            }
            RelaxNgWriter.this.w.endElement();
        }

        public void enumGroupDef(String string, EnumGroup enumGroup) throws Exception {
            RelaxNgWriter.this.w.startElement("define");
            RelaxNgWriter.this.w.attribute("name", string);
            this.enumDatatype(enumGroup);
            RelaxNgWriter.this.w.endElement();
        }

        public void datatypeDef(String string, Datatype datatype) throws Exception {
            RelaxNgWriter.this.w.startElement("define");
            RelaxNgWriter.this.w.attribute("name", string);
            datatype.accept(this);
            RelaxNgWriter.this.w.endElement();
        }

        public void choice(ModelGroup[] modelGroupArray) throws Exception {
            if (modelGroupArray.length == 0) {
                RelaxNgWriter.this.w.startElement("notAllowed");
                RelaxNgWriter.this.w.endElement();
            } else if (modelGroupArray.length == 1) {
                modelGroupArray[0].accept(this);
            } else {
                RelaxNgWriter.this.w.startElement("choice");
                int n = 0;
                while (n < modelGroupArray.length) {
                    modelGroupArray[n].accept(RelaxNgWriter.this.choiceOutput);
                    ++n;
                }
                RelaxNgWriter.this.w.endElement();
            }
        }

        public void sequence(ModelGroup[] modelGroupArray) throws Exception {
            if (modelGroupArray.length == 0) {
                RelaxNgWriter.this.w.startElement("empty");
                RelaxNgWriter.this.w.endElement();
            } else if (modelGroupArray.length == 1) {
                modelGroupArray[0].accept(this);
            } else {
                RelaxNgWriter.this.w.startElement("group");
                int n = 0;
                while (n < modelGroupArray.length) {
                    modelGroupArray[n].accept(RelaxNgWriter.this.groupOutput);
                    ++n;
                }
                RelaxNgWriter.this.w.endElement();
            }
        }

        public void oneOrMore(ModelGroup modelGroup) throws Exception {
            RelaxNgWriter.this.w.startElement("oneOrMore");
            modelGroup.accept(RelaxNgWriter.this.groupOutput);
            RelaxNgWriter.this.w.endElement();
        }

        public void zeroOrMore(ModelGroup modelGroup) throws Exception {
            RelaxNgWriter.this.w.startElement("zeroOrMore");
            modelGroup.accept(RelaxNgWriter.this.groupOutput);
            RelaxNgWriter.this.w.endElement();
        }

        public void optional(ModelGroup modelGroup) throws Exception {
            RelaxNgWriter.this.w.startElement("optional");
            modelGroup.accept(RelaxNgWriter.this.groupOutput);
            RelaxNgWriter.this.w.endElement();
        }

        public void modelGroupRef(String string, ModelGroup modelGroup) throws IOException {
            RelaxNgWriter.this.ref(string);
        }

        public void elementRef(NameSpec nameSpec) throws IOException {
            RelaxNgWriter.this.ref(RelaxNgWriter.this.elementDeclName(nameSpec.getValue()));
        }

        public void pcdata() throws IOException {
            RelaxNgWriter.this.w.startElement("text");
            RelaxNgWriter.this.w.endElement();
        }

        public void any() throws IOException {
            RelaxNgWriter.this.ref(RelaxNgWriter.this.anyName);
        }

        public void attribute(NameSpec nameSpec, Datatype datatype, AttributeDefault attributeDefault) throws Exception {
            String string;
            String string2 = nameSpec.getValue();
            if (RelaxNgWriter.this.currentDuplicateAttributeTable.get(string2) != null) {
                return;
            }
            RelaxNgWriter.this.currentDuplicateAttributeTable.put(string2, string2);
            if (string2.equals("xmlns") || string2.startsWith("xmlns:")) {
                RelaxNgWriter.this.w.startElement("empty");
                RelaxNgWriter.this.w.endElement();
                return;
            }
            if (!attributeDefault.isRequired()) {
                RelaxNgWriter.this.w.startElement("optional");
            }
            RelaxNgWriter.this.w.startElement("attribute");
            RelaxNgWriter.this.w.attribute("name", string2);
            String string3 = attributeDefault.getDefaultValue();
            if (string3 != null) {
                RelaxNgWriter.this.w.attribute(RelaxNgWriter.this.annotationPrefix + ":defaultValue", string3);
            }
            if ((string = attributeDefault.getFixedValue()) != null) {
                RelaxNgWriter.this.w.startElement("value");
                String string4 = RelaxNgWriter.valueType(datatype);
                if (string4 != null) {
                    RelaxNgWriter.this.w.attribute("type", string4);
                }
                RelaxNgWriter.this.w.characters(string);
                RelaxNgWriter.this.w.endElement();
            } else if (datatype.getType() != 0) {
                datatype.accept(RelaxNgWriter.this.explicitOutput);
            }
            RelaxNgWriter.this.w.endElement();
            if (!attributeDefault.isRequired()) {
                RelaxNgWriter.this.w.endElement();
            }
        }

        public void attributeGroupRef(String string, AttributeGroup attributeGroup) throws Exception {
            DuplicateAttributeDetector duplicateAttributeDetector = new DuplicateAttributeDetector();
            attributeGroup.accept(duplicateAttributeDetector);
            if (duplicateAttributeDetector.containsDuplicate) {
                attributeGroup.accept(this);
            } else {
                RelaxNgWriter.this.ref(string);
            }
        }

        public void cdataDatatype() throws IOException {
            RelaxNgWriter.this.w.startElement("data");
            RelaxNgWriter.this.w.attribute("type", "string");
            RelaxNgWriter.this.w.endElement();
        }

        public void tokenizedDatatype(String string) throws IOException {
            RelaxNgWriter.this.w.startElement("data");
            RelaxNgWriter.this.w.attribute("type", string);
            RelaxNgWriter.this.w.endElement();
        }

        public void enumDatatype(EnumGroup enumGroup) throws Exception {
            if (enumGroup.getMembers().length == 0) {
                RelaxNgWriter.this.w.startElement("notAllowed");
                RelaxNgWriter.this.w.endElement();
            } else {
                RelaxNgWriter.this.w.startElement("choice");
                enumGroup.accept(this);
                RelaxNgWriter.this.w.endElement();
            }
        }

        public void notationDatatype(EnumGroup enumGroup) throws Exception {
            this.enumDatatype(enumGroup);
        }

        public void datatypeRef(String string, Datatype datatype) throws IOException {
            RelaxNgWriter.this.ref(string);
        }

        public void enumValue(String string) throws IOException {
            RelaxNgWriter.this.w.startElement("value");
            RelaxNgWriter.this.w.characters(string);
            RelaxNgWriter.this.w.endElement();
        }

        public void enumGroupRef(String string, EnumGroup enumGroup) throws IOException {
            RelaxNgWriter.this.ref(string);
        }

        public void comment(String string) throws IOException {
            RelaxNgWriter.this.w.comment(string);
        }

        public void processingInstruction(String string, String string2) throws IOException {
            RelaxNgWriter.this.w.processingInstruction(string, string2);
        }

        public void externalIdRef(String string, ExternalId externalId, String string2, String string3, TopLevel[] topLevelArray) throws Exception {
            if (string2 == null) {
                super.externalIdRef(string, externalId, string2, string3, topLevelArray);
                return;
            }
            SignificanceDetector significanceDetector = new SignificanceDetector();
            try {
                significanceDetector.externalIdRef(string, externalId, string2, string3, topLevelArray);
                if (!significanceDetector.significant) {
                    return;
                }
            }
            catch (Exception exception) {
                throw (RuntimeException)exception;
            }
            XmlOutputMember xmlOutputMember = RelaxNgWriter.this.outMember;
            XmlWriter xmlWriter = RelaxNgWriter.this.w;
            RelaxNgWriter.this.outMember = RelaxNgWriter.this.outCollection.mapUri(string2);
            RelaxNgWriter.this.w = RelaxNgWriter.this.outMember.open(string3);
            String string4 = RelaxNgWriter.this.outMember.getSystemId(xmlOutputMember);
            RelaxNgWriter.this.w.writeXmlDecl(string3);
            RelaxNgWriter.this.startGrammar();
            super.externalIdRef(string, externalId, string2, string3, topLevelArray);
            RelaxNgWriter.this.endGrammar();
            RelaxNgWriter.this.w.close();
            RelaxNgWriter.this.w = xmlWriter;
            RelaxNgWriter.this.outMember = xmlOutputMember;
            RelaxNgWriter.this.w.startElement("include");
            RelaxNgWriter.this.w.attribute("href", string4);
            RelaxNgWriter.this.w.endElement();
        }
    }

    private class Analyzer
    extends VisitorBase
    implements ModelGroupVisitor,
    AttributeGroupVisitor {
        private Analyzer() {
        }

        public void elementDecl(NameSpec nameSpec, ModelGroup modelGroup) throws Exception {
            RelaxNgWriter.this.noteElementName(nameSpec.getValue(), 1);
            modelGroup.accept(this);
        }

        public void attlistDecl(NameSpec nameSpec, AttributeGroup attributeGroup) throws Exception {
            RelaxNgWriter.this.noteElementName(nameSpec.getValue(), 2);
            attributeGroup.accept(this);
        }

        public void modelGroupDef(String string, ModelGroup modelGroup) throws Exception {
            RelaxNgWriter.this.noteDef(string);
            modelGroup.accept(this);
        }

        public void attributeGroupDef(String string, AttributeGroup attributeGroup) throws Exception {
            RelaxNgWriter.this.noteDef(string);
            attributeGroup.accept(this);
        }

        public void enumGroupDef(String string, EnumGroup enumGroup) {
            RelaxNgWriter.this.noteDef(string);
        }

        public void datatypeDef(String string, Datatype datatype) {
            RelaxNgWriter.this.noteDef(string);
        }

        public void choice(ModelGroup[] modelGroupArray) throws Exception {
            int n = 0;
            while (n < modelGroupArray.length) {
                modelGroupArray[n].accept(this);
                ++n;
            }
        }

        public void sequence(ModelGroup[] modelGroupArray) throws Exception {
            int n = 0;
            while (n < modelGroupArray.length) {
                modelGroupArray[n].accept(this);
                ++n;
            }
        }

        public void oneOrMore(ModelGroup modelGroup) throws Exception {
            modelGroup.accept(this);
        }

        public void zeroOrMore(ModelGroup modelGroup) throws Exception {
            modelGroup.accept(this);
        }

        public void optional(ModelGroup modelGroup) throws Exception {
            modelGroup.accept(this);
        }

        public void modelGroupRef(String string, ModelGroup modelGroup) {
        }

        public void elementRef(NameSpec nameSpec) {
            RelaxNgWriter.this.noteElementName(nameSpec.getValue(), 4);
        }

        public void pcdata() {
        }

        public void any() {
            RelaxNgWriter.this.hadAny = true;
        }

        public void attribute(NameSpec nameSpec, Datatype datatype, AttributeDefault attributeDefault) {
            RelaxNgWriter.this.noteAttribute(nameSpec.getValue(), attributeDefault.getDefaultValue());
        }

        public void attributeGroupRef(String string, AttributeGroup attributeGroup) {
        }
    }

    private static abstract class VisitorBase
    implements TopLevelVisitor {
        private VisitorBase() {
        }

        public void processingInstruction(String string, String string2) throws Exception {
        }

        public void comment(String string) throws Exception {
        }

        public void flagDef(String string, Flag flag) throws Exception {
        }

        public void includedSection(Flag flag, TopLevel[] topLevelArray) throws Exception {
            int n = 0;
            while (n < topLevelArray.length) {
                topLevelArray[n].accept(this);
                ++n;
            }
        }

        public void ignoredSection(Flag flag, String string) throws Exception {
        }

        public void internalEntityDecl(String string, String string2) throws Exception {
        }

        public void externalEntityDecl(String string, ExternalId externalId) throws Exception {
        }

        public void notationDecl(String string, ExternalId externalId) throws Exception {
        }

        public void nameSpecDef(String string, NameSpec nameSpec) throws Exception {
        }

        public void overriddenDef(Def def, boolean bl) throws Exception {
        }

        public void externalIdDef(String string, ExternalId externalId) throws Exception {
        }

        public void externalIdRef(String string, ExternalId externalId, String string2, String string3, TopLevel[] topLevelArray) throws Exception {
            int n = 0;
            while (n < topLevelArray.length) {
                topLevelArray[n].accept(this);
                ++n;
            }
        }

        public void paramDef(String string, String string2) throws Exception {
        }

        public void attributeDefaultDef(String string, AttributeDefault attributeDefault) throws Exception {
        }

        public abstract void datatypeDef(String var1, Datatype var2) throws Exception;

        public abstract void enumGroupDef(String var1, EnumGroup var2) throws Exception;

        public abstract void attributeGroupDef(String var1, AttributeGroup var2) throws Exception;

        public abstract void modelGroupDef(String var1, ModelGroup var2) throws Exception;

        public abstract void attlistDecl(NameSpec var1, AttributeGroup var2) throws Exception;

        public abstract void elementDecl(NameSpec var1, ModelGroup var2) throws Exception;
    }
}

