/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.dtd.app;

import com.thaiopensource.xml.dtd.om.AttributeDefault;
import com.thaiopensource.xml.dtd.om.AttributeDefaultVisitor;
import com.thaiopensource.xml.dtd.om.AttributeGroup;
import com.thaiopensource.xml.dtd.om.AttributeGroupVisitor;
import com.thaiopensource.xml.dtd.om.Datatype;
import com.thaiopensource.xml.dtd.om.DatatypeVisitor;
import com.thaiopensource.xml.dtd.om.Def;
import com.thaiopensource.xml.dtd.om.Dtd;
import com.thaiopensource.xml.dtd.om.EnumGroup;
import com.thaiopensource.xml.dtd.om.EnumGroupVisitor;
import com.thaiopensource.xml.dtd.om.Flag;
import com.thaiopensource.xml.dtd.om.FlagRef;
import com.thaiopensource.xml.dtd.om.FlagVisitor;
import com.thaiopensource.xml.dtd.om.ModelGroup;
import com.thaiopensource.xml.dtd.om.ModelGroupVisitor;
import com.thaiopensource.xml.dtd.om.NameSpec;
import com.thaiopensource.xml.dtd.om.NameSpecVisitor;
import com.thaiopensource.xml.dtd.om.TopLevel;
import com.thaiopensource.xml.dtd.om.TopLevelVisitor;
import com.thaiopensource.xml.em.ExternalId;
import com.thaiopensource.xml.out.XmlWriter;
import java.io.IOException;

public class SchemaWriter
implements TopLevelVisitor,
ModelGroupVisitor,
AttributeGroupVisitor,
DatatypeVisitor,
EnumGroupVisitor,
FlagVisitor,
NameSpecVisitor,
AttributeDefaultVisitor {
    private XmlWriter w;

    public SchemaWriter(XmlWriter xmlWriter) {
        this.w = xmlWriter;
    }

    public void writeDtd(Dtd dtd) throws IOException {
        String string = dtd.getEncoding();
        if (string != null) {
            this.w.writeXmlDecl(string);
        }
        this.w.startElement("doctype");
        try {
            dtd.accept(this);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (IOException)exception;
        }
        this.w.endElement();
    }

    public void elementDecl(NameSpec nameSpec, ModelGroup modelGroup) throws Exception {
        this.w.startElement("element");
        nameSpec.accept(this);
        modelGroup.accept(this);
        this.w.endElement();
    }

    public void attlistDecl(NameSpec nameSpec, AttributeGroup attributeGroup) throws Exception {
        this.w.startElement("attlist");
        nameSpec.accept(this);
        attributeGroup.accept(this);
        this.w.endElement();
    }

    public void processingInstruction(String string, String string2) throws Exception {
        this.w.startElement("processingInstruction");
        this.w.attribute("target", string);
        this.w.characters(string2);
        this.w.endElement();
    }

    public void comment(String string) throws Exception {
        this.w.startElement("comment");
        this.w.characters(string);
        this.w.endElement();
    }

    public void modelGroupDef(String string, ModelGroup modelGroup) throws Exception {
        this.w.startElement("modelGroup");
        this.w.attribute("name", string);
        modelGroup.accept(this);
        this.w.endElement();
    }

    public void attributeGroupDef(String string, AttributeGroup attributeGroup) throws Exception {
        this.w.startElement("attributeGroup");
        this.w.attribute("name", string);
        attributeGroup.accept(this);
        this.w.endElement();
    }

    public void enumGroupDef(String string, EnumGroup enumGroup) throws Exception {
        this.w.startElement("enumGroup");
        this.w.attribute("name", string);
        enumGroup.accept(this);
        this.w.endElement();
    }

    public void datatypeDef(String string, Datatype datatype) throws Exception {
        this.w.startElement("datatype");
        this.w.attribute("name", string);
        datatype.accept(this);
        this.w.endElement();
    }

    public void flagDef(String string, Flag flag) throws Exception {
        this.w.startElement("flag");
        this.w.attribute("name", string);
        flag.accept(this);
        this.w.endElement();
    }

    public void attributeDefaultDef(String string, AttributeDefault attributeDefault) throws Exception {
        this.w.startElement("attributeDefault");
        this.w.attribute("name", string);
        attributeDefault.accept(this);
        this.w.endElement();
    }

    public void choice(ModelGroup[] modelGroupArray) throws Exception {
        this.w.startElement("choice");
        int n = 0;
        while (n < modelGroupArray.length) {
            modelGroupArray[n].accept(this);
            ++n;
        }
        this.w.endElement();
    }

    public void sequence(ModelGroup[] modelGroupArray) throws Exception {
        this.w.startElement("sequence");
        int n = 0;
        while (n < modelGroupArray.length) {
            modelGroupArray[n].accept(this);
            ++n;
        }
        this.w.endElement();
    }

    public void oneOrMore(ModelGroup modelGroup) throws Exception {
        this.w.startElement("oneOrMore");
        modelGroup.accept(this);
        this.w.endElement();
    }

    public void zeroOrMore(ModelGroup modelGroup) throws Exception {
        this.w.startElement("zeroOrMore");
        modelGroup.accept(this);
        this.w.endElement();
    }

    public void optional(ModelGroup modelGroup) throws Exception {
        this.w.startElement("optional");
        modelGroup.accept(this);
        this.w.endElement();
    }

    public void modelGroupRef(String string, ModelGroup modelGroup) throws Exception {
        this.w.startElement("modelGroupRef");
        this.w.attribute("name", string);
        this.w.endElement();
    }

    public void elementRef(NameSpec nameSpec) throws Exception {
        this.w.startElement("elementRef");
        nameSpec.accept(this);
        this.w.endElement();
    }

    public void pcdata() throws Exception {
        this.w.startElement("pcdata");
        this.w.endElement();
    }

    public void any() throws Exception {
        this.w.startElement("any");
        this.w.endElement();
    }

    public void attribute(NameSpec nameSpec, Datatype datatype, AttributeDefault attributeDefault) throws Exception {
        this.w.startElement("attribute");
        nameSpec.accept(this);
        datatype.accept(this);
        attributeDefault.accept(this);
        this.w.endElement();
    }

    public void attributeGroupRef(String string, AttributeGroup attributeGroup) throws Exception {
        this.w.startElement("attributeGroupRef");
        this.w.attribute("name", string);
        this.w.endElement();
    }

    public void enumValue(String string) throws Exception {
        this.w.startElement("enum");
        this.w.characters(string);
        this.w.endElement();
    }

    public void enumGroupRef(String string, EnumGroup enumGroup) throws Exception {
        this.w.startElement("enumGroupRef");
        this.w.attribute("name", string);
        this.w.endElement();
    }

    public void cdataDatatype() throws IOException {
        this.w.startElement("cdata");
        this.w.endElement();
    }

    public void tokenizedDatatype(String string) throws IOException {
        this.w.startElement("tokenized");
        this.w.attribute("name", string);
        this.w.endElement();
    }

    public void enumDatatype(EnumGroup enumGroup) throws Exception {
        this.w.startElement("tokenized");
        enumGroup.accept(this);
        this.w.endElement();
    }

    public void notationDatatype(EnumGroup enumGroup) throws Exception {
        this.w.startElement("tokenized");
        this.w.attribute("name", "NOTATION");
        enumGroup.accept(this);
        this.w.endElement();
    }

    public void datatypeRef(String string, Datatype datatype) throws IOException {
        this.w.startElement("datatypeRef");
        this.w.attribute("name", string);
        this.w.endElement();
    }

    public void flagRef(String string, Flag flag) throws IOException {
        this.w.startElement("flagRef");
        this.w.attribute("name", string);
        this.w.endElement();
    }

    public void include() throws IOException {
        this.w.startElement("include");
        this.w.endElement();
    }

    public void ignore() throws IOException {
        this.w.startElement("ignore");
        this.w.endElement();
    }

    public void includedSection(Flag flag, TopLevel[] topLevelArray) throws Exception {
        this.w.startElement("includedSection");
        if (flag instanceof FlagRef) {
            this.w.attribute("flag", ((FlagRef)flag).getName());
        }
        int n = 0;
        while (n < topLevelArray.length) {
            topLevelArray[n].accept(this);
            ++n;
        }
        this.w.endElement();
    }

    public void ignoredSection(Flag flag, String string) throws Exception {
        this.w.startElement("ignoredSection");
        if (flag instanceof FlagRef) {
            this.w.attribute("flag", ((FlagRef)flag).getName());
        }
        this.w.characters(string);
        this.w.endElement();
    }

    public void externalIdDef(String string, ExternalId externalId) throws IOException {
        this.w.startElement("externalId");
        this.w.attribute("name", string);
        this.externalId(externalId);
        this.w.endElement();
    }

    public void externalIdRef(String string, ExternalId externalId, String string2, String string3, TopLevel[] topLevelArray) throws Exception {
        this.w.startElement("externalIdRef");
        this.w.attribute("name", string);
        int n = 0;
        while (n < topLevelArray.length) {
            topLevelArray[n].accept(this);
            ++n;
        }
        this.w.endElement();
    }

    public void internalEntityDecl(String string, String string2) throws Exception {
        this.w.startElement("internalEntity");
        this.w.attribute("name", string);
        boolean bl = string2.length() == 1 && string2.charAt(0) >= '\u0080';
        this.w.characters(string2, bl);
        this.w.endElement();
    }

    public void externalEntityDecl(String string, ExternalId externalId) throws IOException {
        this.w.startElement("externalEntity");
        this.w.attribute("name", string);
        this.externalId(externalId);
        this.w.endElement();
    }

    public void notationDecl(String string, ExternalId externalId) throws IOException {
        this.w.startElement("notation");
        this.w.attribute("name", string);
        this.externalId(externalId);
        this.w.endElement();
    }

    private void externalId(ExternalId externalId) throws IOException {
        this.attributeIfNotNull("system", externalId.getSystemId());
        this.attributeIfNotNull("public", externalId.getPublicId());
    }

    private void attributeIfNotNull(String string, String string2) throws IOException {
        if (string2 != null) {
            this.w.attribute(string, string2);
        }
    }

    public void nameSpecDef(String string, NameSpec nameSpec) throws Exception {
        this.w.startElement("nameSpec");
        this.w.attribute("name", string);
        nameSpec.accept(this);
        this.w.endElement();
    }

    public void name(String string) throws IOException {
        this.w.startElement("name");
        this.w.characters(string);
        this.w.endElement();
    }

    public void nameSpecRef(String string, NameSpec nameSpec) throws Exception {
        this.w.startElement("nameSpecRef");
        this.w.attribute("name", string);
        this.w.endElement();
    }

    public void overriddenDef(Def def, boolean bl) throws Exception {
        this.w.startElement("overridden");
        if (bl) {
            this.w.startElement("duplicate");
            this.w.attribute("name", def.getName());
            this.w.endElement();
        } else {
            def.accept(this);
        }
        this.w.endElement();
    }

    public void paramDef(String string, String string2) throws IOException {
        this.w.startElement("param");
        this.w.attribute("name", string);
        this.w.characters(string2);
        this.w.endElement();
    }

    public void defaultValue(String string) throws Exception {
        this.w.startElement("default");
        this.w.characters(string);
        this.w.endElement();
    }

    public void fixedValue(String string) throws Exception {
        this.w.startElement("fixed");
        this.w.characters(string);
        this.w.endElement();
    }

    public void impliedValue() throws Exception {
        this.w.startElement("implied");
        this.w.endElement();
    }

    public void requiredValue() throws Exception {
        this.w.startElement("required");
        this.w.endElement();
    }

    public void attributeDefaultRef(String string, AttributeDefault attributeDefault) throws Exception {
        this.w.startElement("attributeDefaultRef");
        this.w.attribute("name", string);
        this.w.endElement();
    }
}

