/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.dtd.app;

import com.thaiopensource.xml.dtd.app.EncodingDetectInputStream;
import com.thaiopensource.xml.em.EntityManager;
import com.thaiopensource.xml.em.ExternalId;
import com.thaiopensource.xml.em.OpenEntity;
import com.thaiopensource.xml.util.EncodingMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;

public class UriEntityManager
implements EntityManager {
    public OpenEntity open(ExternalId externalId) throws IOException {
        String string = externalId.getSystemId();
        String string2 = externalId.getBaseUri();
        URL uRL = string2 != null ? new URL(new URL(string2), string) : new URL(string);
        EncodingDetectInputStream encodingDetectInputStream = new EncodingDetectInputStream(uRL.openStream());
        String string3 = encodingDetectInputStream.detectEncoding();
        String string4 = EncodingMap.getJavaName(string3);
        return new OpenEntity(new BufferedReader(new InputStreamReader((InputStream)encodingDetectInputStream, string4)), uRL.toString(), uRL.toString(), string3);
    }

    public static String commandLineArgToUri(String string) {
        if (!UriEntityManager.hasScheme(string)) {
            try {
                return UriEntityManager.fileToUri(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return string;
    }

    private static boolean hasScheme(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        if (!UriEntityManager.isAlpha(string.charAt(0))) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case ':': {
                    return n2 != 1;
                }
                case '+': 
                case '-': {
                    break;
                }
                default: {
                    if (UriEntityManager.isAlnum(c)) break;
                    return false;
                }
            }
            ++n2;
        }
        return false;
    }

    private static boolean isAlpha(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private static boolean isAlnum(char c) {
        return UriEntityManager.isAlpha(c) || '0' <= c && c <= '9';
    }

    private static String fileToUri(String string) throws MalformedURLException {
        String string2 = new File(string).getAbsolutePath().replace(File.separatorChar, '/');
        if (string2.length() > 0 && string2.charAt(0) != '/') {
            string2 = '/' + string2;
        }
        return new URL("file", "", string2).toString();
    }
}

