/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.dtd.parse;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.xml.dtd.parse.Atom;
import com.thaiopensource.xml.dtd.parse.DtdBuilder;
import com.thaiopensource.xml.dtd.parse.Entity;
import com.thaiopensource.xml.dtd.parse.Notation;
import com.thaiopensource.xml.dtd.parse.ParseException;
import com.thaiopensource.xml.dtd.parse.PrologParser;
import com.thaiopensource.xml.dtd.parse.PrologSyntaxException;
import com.thaiopensource.xml.dtd.parse.ReplacementTextBuffer;
import com.thaiopensource.xml.em.EntityManager;
import com.thaiopensource.xml.em.ExternalId;
import com.thaiopensource.xml.em.OpenEntity;
import com.thaiopensource.xml.tok.EmptyTokenException;
import com.thaiopensource.xml.tok.EndOfPrologException;
import com.thaiopensource.xml.tok.ExtensibleTokenException;
import com.thaiopensource.xml.tok.InvalidTokenException;
import com.thaiopensource.xml.tok.PartialTokenException;
import com.thaiopensource.xml.tok.Position;
import com.thaiopensource.xml.tok.TextDecl;
import com.thaiopensource.xml.tok.Token;
import com.thaiopensource.xml.tok.Tokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Vector;

class Parser
extends Token {
    static Localizer localizer = new Localizer(class$com$thaiopensource$xml$dtd$parse$Parser == null ? (class$com$thaiopensource$xml$dtd$parse$Parser = Parser.class$("com.thaiopensource.xml.dtd.parse.Parser")) : class$com$thaiopensource$xml$dtd$parse$Parser);
    private Parser parent;
    private Reader in;
    private char[] buf;
    private int bufStart = 0;
    private int bufEnd;
    private int currentTokenStart = 0;
    private int posOff = 0;
    private long bufEndStreamOffset = 0L;
    private Position pos = new Position();
    private static final int READSIZE = 8192;
    private ReplacementTextBuffer valueBuf;
    private DtdBuilder db;
    private Vector atoms = new Vector();
    private final boolean isInternal;
    private String baseUri;
    private EntityManager entityManager;
    private String location;
    private Hashtable atomTable;
    private Hashtable elementTable;
    static /* synthetic */ Class class$com$thaiopensource$xml$dtd$parse$Parser;

    Parser(OpenEntity openEntity, EntityManager entityManager) {
        this.in = openEntity.getReader();
        this.baseUri = openEntity.getBaseUri();
        this.location = openEntity.getLocation();
        this.entityManager = entityManager;
        this.parent = this.parent;
        this.buf = new char[16384];
        this.valueBuf = new ReplacementTextBuffer();
        this.bufEnd = 0;
        this.db = new DtdBuilder(this.atoms);
        this.isInternal = false;
        this.elementTable = new Hashtable();
        this.atomTable = new Hashtable();
    }

    private Parser(OpenEntity openEntity, Parser parser) {
        this.in = openEntity.getReader();
        this.baseUri = openEntity.getBaseUri();
        this.location = openEntity.getLocation();
        this.entityManager = parser.entityManager;
        this.parent = parser;
        this.buf = new char[16384];
        this.valueBuf = new ReplacementTextBuffer();
        this.bufEnd = 0;
        this.db = parser.db;
        this.isInternal = false;
        this.elementTable = parser.elementTable;
        this.atomTable = parser.atomTable;
    }

    private Parser(char[] cArray, String string, Parser parser) {
        this.buf = cArray;
        this.parent = parser;
        this.baseUri = parser.baseUri;
        this.entityManager = parser.entityManager;
        this.bufEnd = cArray.length;
        this.bufEndStreamOffset = cArray.length;
        this.valueBuf = parser.valueBuf;
        this.db = parser.db;
        this.isInternal = true;
        this.elementTable = parser.elementTable;
        this.atomTable = parser.atomTable;
    }

    DtdBuilder parse() throws IOException {
        this.skipTextDecl();
        this.parseDecls(false);
        return this.db;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseDecls(boolean bl) throws IOException {
        PrologParser prologParser = new PrologParser(bl ? (byte)2 : 1);
        DeclState declState = new DeclState();
        try {
            try {}
            catch (PrologSyntaxException prologSyntaxException) {
                this.fatal("SYNTAX_ERROR");
                Object var8_9 = null;
                if (bl) return;
                if (this.in == null) return;
                this.in.close();
                this.in = null;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (bl) throw throwable;
            if (this.in == null) throw throwable;
            this.in.close();
            this.in = null;
            throw throwable;
        }
        while (true) {
            int n;
            try {
                n = this.tokenizeProlog();
            }
            catch (EndOfPrologException endOfPrologException) {
                this.fatal("SYNTAX_ERROR");
                break;
            }
            catch (EmptyTokenException emptyTokenException) {
                prologParser.end();
                break;
            }
            this.prologAction(n, prologParser, declState);
        }
        Object var8_8 = null;
        if (bl) return;
        if (this.in == null) return;
        this.in.close();
        this.in = null;
    }

    private void prologAction(int n, PrologParser prologParser, DeclState declState) throws IOException, PrologSyntaxException {
        Atom atom = this.makeAtom(n, this.currentTokenStart, this.bufStart);
        this.addAtom(atom);
        String string = atom.getToken();
        int n2 = prologParser.action(n, string);
        switch (n2) {
            case 54: {
                this.skipIgnoreSect();
                break;
            }
            case 10: {
                declState.entity = this.db.createGeneralEntity(string);
                break;
            }
            case 11: {
                declState.entity = this.db.createParamEntity(string);
                break;
            }
            case 15: {
                try {
                    declState.entity.publicId = Tokenizer.getPublicId(this.buf, this.currentTokenStart, this.bufStart);
                }
                catch (InvalidTokenException invalidTokenException) {
                    this.currentTokenStart = invalidTokenException.getOffset();
                    this.fatal("INVALID_PUBLIC_ID");
                }
                break;
            }
            case 14: {
                declState.entity.systemId = string.substring(1, string.length() - 1);
                declState.entity.baseUri = this.baseUri;
                break;
            }
            case 16: {
                declState.entity.notationName = string;
                break;
            }
            case 12: {
                this.makeReplacementText();
                declState.entity.text = this.valueBuf.getChars();
                declState.entity.entityValue = string.substring(1, string.length() - 1);
                declState.entity.mustReparse = this.valueBuf.getMustReparse();
                declState.entity.references = this.valueBuf.getReferences();
                if (declState.entity.mustReparse) {
                    declState.entity.problem = 6;
                    break;
                }
                if (!declState.entity.overridden || !declState.entity.isParameter) break;
                declState.entity.atoms = this.tokenizeOverriddenEntity(declState.entity.text);
                break;
            }
            case 52: 
            case 53: {
                int n3 = this.currentTokenStart + 1;
                String string2 = new String(this.buf, n3, this.getNameEnd() - n3);
                Entity entity = this.db.lookupParamEntity(string2);
                if (entity == null) {
                    this.fatal("UNDEF_PEREF", string2);
                    break;
                }
                Parser parser = this.makeParserForEntity(entity, string2);
                if (parser == null) break;
                entity.open = true;
                if (n2 == 52) {
                    parser.parseDecls(entity.text != null);
                } else {
                    parser.parseInnerParamEntity(prologParser, declState);
                }
                entity.atoms = parser.atoms;
                this.setLastAtomEntity(entity);
                entity.open = false;
                break;
            }
            case 37: {
                if (this.elementTable.get(string) != null) {
                    this.fatal("DUPLICATE_ELEMENT", string);
                }
                this.elementTable.put(string, string);
                break;
            }
            case 17: {
                declState.notation = this.db.createNotation(string);
                if (declState.notation != null) break;
                this.fatal("DUPLICATE_NOTATION", string);
                break;
            }
            case 19: {
                try {
                    declState.notation.publicId = Tokenizer.getPublicId(this.buf, this.currentTokenStart, this.bufStart);
                }
                catch (InvalidTokenException invalidTokenException) {
                    this.currentTokenStart = invalidTokenException.getOffset();
                    this.fatal("INVALID_PUBLIC_ID");
                }
                break;
            }
            case 18: {
                declState.notation.systemId = string.substring(1, string.length() - 1);
                declState.notation.baseUri = this.baseUri;
                break;
            }
            case 35: {
                String string3 = string.substring(1, string.length() - 1);
                if (this.db.getNormalized(string3) != null) break;
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    this.normalizeAttributeValue(this.buf, this.currentTokenStart + 1, this.bufStart - 1, stringBuffer);
                }
                catch (AttributeValueException attributeValueException) {
                    this.currentTokenStart = attributeValueException.offset;
                    if (attributeValueException.arg != null) {
                        this.fatal(attributeValueException.key, attributeValueException.arg);
                    }
                    this.fatal(attributeValueException.key);
                }
                this.db.setNormalized(string3, stringBuffer.toString());
            }
        }
    }

    void parseInnerParamEntity(PrologParser prologParser, DeclState declState) throws IOException {
        int n = prologParser.getGroupLevel();
        try {
            while (true) {
                int n2 = this.tokenizeProlog();
                this.prologAction(n2, prologParser, declState);
                switch (n2) {
                    case 20: 
                    case 29: {
                        this.fatal("PE_DECL_NESTING");
                    }
                }
            }
        }
        catch (EndOfPrologException endOfPrologException) {
            this.fatal("SYNTAX_ERROR");
        }
        catch (PrologSyntaxException prologSyntaxException) {
            this.fatal("SYNTAX_ERROR");
        }
        catch (EmptyTokenException emptyTokenException) {
            // empty catch block
        }
        if (prologParser.getGroupLevel() != n) {
            this.fatal("PE_GROUP_NESTING");
        }
    }

    private Parser makeParserForEntity(Entity entity, String string) throws IOException {
        entity.noteReferenced();
        if (entity.open) {
            this.fatal("RECURSION");
        }
        if (entity.notationName != null) {
            this.fatal("UNPARSED_REF");
        }
        if (entity.text != null) {
            return new Parser(entity.text, string, this);
        }
        OpenEntity openEntity = this.entityManager.open(new ExternalId(entity.systemId, entity.publicId, entity.baseUri));
        if (openEntity == null) {
            return null;
        }
        entity.encoding = openEntity.getEncoding();
        entity.uri = openEntity.getBaseUri();
        Parser parser = new Parser(openEntity, this);
        parser.skipTextDecl();
        return parser;
    }

    private void makeReplacementText() throws IOException {
        this.valueBuf.clear();
        Token token = new Token();
        int n = this.currentTokenStart + 1;
        int n2 = this.bufStart - 1;
        try {
            while (true) {
                int n3;
                int n4;
                try {
                    n4 = Tokenizer.tokenizeEntityValue(this.buf, n, n2, token);
                    n3 = token.getTokenEnd();
                }
                catch (ExtensibleTokenException extensibleTokenException) {
                    n4 = extensibleTokenException.getTokenType();
                    n3 = n2;
                }
                this.handleEntityValueToken(this.valueBuf, n4, n, n3, token);
                n = n3;
            }
        }
        catch (PartialTokenException partialTokenException) {
            this.currentTokenStart = n2;
            this.fatal("NOT_WELL_FORMED");
        }
        catch (InvalidTokenException invalidTokenException) {
            this.currentTokenStart = invalidTokenException.getOffset();
            this.reportInvalidToken(invalidTokenException);
        }
        catch (EmptyTokenException emptyTokenException) {
            // empty catch block
        }
    }

    private void parseEntityValue(ReplacementTextBuffer replacementTextBuffer) throws IOException {
        Token token = new Token();
        while (true) {
            int n;
            try {
                n = Tokenizer.tokenizeEntityValue(this.buf, this.bufStart, this.bufEnd, token);
                this.currentTokenStart = this.bufStart;
                this.bufStart = token.getTokenEnd();
            }
            catch (EmptyTokenException emptyTokenException) {
                if (this.fill()) continue;
                return;
            }
            catch (PartialTokenException partialTokenException) {
                if (this.fill()) continue;
                this.currentTokenStart = this.bufStart;
                this.bufStart = this.bufEnd;
                this.fatal("UNCLOSED_TOKEN");
                continue;
            }
            catch (ExtensibleTokenException extensibleTokenException) {
                if (this.fill()) continue;
                this.currentTokenStart = this.bufStart;
                this.bufStart = this.bufEnd;
                n = extensibleTokenException.getTokenType();
            }
            catch (InvalidTokenException invalidTokenException) {
                this.currentTokenStart = invalidTokenException.getOffset();
                this.reportInvalidToken(invalidTokenException);
                continue;
            }
            this.handleEntityValueToken(replacementTextBuffer, n, this.currentTokenStart, this.bufStart, token);
        }
    }

    private void handleEntityValueToken(ReplacementTextBuffer replacementTextBuffer, int n, int n2, int n3, Token token) throws IOException {
        switch (n) {
            case 1: {
                if (!this.isInternal) {
                    replacementTextBuffer.append('\n');
                    break;
                }
            }
            case 0: 
            case 9: 
            case 10: {
                replacementTextBuffer.append(this.buf, n2, n3);
                break;
            }
            case 11: {
                char c = token.getRefChar();
                if (c == '&' || c == '%') {
                    replacementTextBuffer.setMustReparse();
                }
                replacementTextBuffer.append(token.getRefChar());
                break;
            }
            case 12: {
                replacementTextBuffer.appendRefCharPair(token);
                break;
            }
            case 17: {
                String string = new String(this.buf, n2 + 1, n3 - n2 - 2);
                Entity entity = this.db.lookupParamEntity(string);
                if (entity == null) {
                    this.fatal("UNDEF_PEREF", string);
                    break;
                }
                if (entity.text != null && !entity.mustReparse) {
                    entity.noteReferenced();
                    replacementTextBuffer.appendReplacementText(entity);
                    break;
                }
                Parser parser = this.makeParserForEntity(entity, string);
                if (parser == null) break;
                entity.open = true;
                parser.parseEntityValue(replacementTextBuffer);
                entity.open = false;
                break;
            }
            default: {
                throw new Error("replacement text botch");
            }
        }
    }

    private void skipTextDecl() throws IOException {
        try {
            if (this.tokenizeProlog() != 14) {
                this.bufStart = 0;
                this.currentTokenStart = 0;
                return;
            }
            try {
                new TextDecl(this.buf, this.currentTokenStart, this.bufStart);
            }
            catch (InvalidTokenException invalidTokenException) {
                this.currentTokenStart = invalidTokenException.getOffset();
                this.fatal("INVALID_TEXT_DECL");
            }
        }
        catch (EmptyTokenException emptyTokenException) {
        }
        catch (EndOfPrologException endOfPrologException) {
            // empty catch block
        }
    }

    private final int tokenizeProlog() throws IOException, EmptyTokenException, EndOfPrologException {
        while (true) {
            try {
                int n = Tokenizer.tokenizeProlog(this.buf, this.bufStart, this.bufEnd, this);
                this.currentTokenStart = this.bufStart;
                this.bufStart = this.getTokenEnd();
                return n;
            }
            catch (EmptyTokenException emptyTokenException) {
                if (this.fill()) continue;
                throw emptyTokenException;
            }
            catch (PartialTokenException partialTokenException) {
                if (this.fill()) continue;
                this.currentTokenStart = this.bufStart;
                this.bufStart = this.bufEnd;
                this.fatal("UNCLOSED_TOKEN");
                continue;
            }
            catch (ExtensibleTokenException extensibleTokenException) {
                if (this.fill()) continue;
                this.currentTokenStart = this.bufStart;
                this.bufStart = this.bufEnd;
                return extensibleTokenException.getTokenType();
            }
            catch (InvalidTokenException invalidTokenException) {
                this.bufStart = this.currentTokenStart = invalidTokenException.getOffset();
                this.reportInvalidToken(invalidTokenException);
                continue;
            }
            break;
        }
    }

    private final void skipIgnoreSect() throws IOException {
        while (true) {
            try {
                int n = this.bufStart;
                this.bufStart = Tokenizer.skipIgnoreSect(this.buf, this.bufStart, this.bufEnd);
                this.addAtom(new Atom(36, this.bufferString(n, this.bufStart)));
                return;
            }
            catch (PartialTokenException partialTokenException) {
                if (this.fill()) continue;
                this.currentTokenStart = this.bufStart;
                this.fatal("UNCLOSED_CONDITIONAL_SECTION");
                continue;
            }
            catch (InvalidTokenException invalidTokenException) {
                this.currentTokenStart = invalidTokenException.getOffset();
                this.fatal("IGNORE_SECT_CHAR");
                continue;
            }
            break;
        }
    }

    private Vector tokenizeOverriddenEntity(char[] cArray) {
        Vector<Atom> vector = new Vector<Atom>();
        int n = 0;
        try {
            Token token = new Token();
            int n2 = 0;
            while (true) {
                int n3;
                int n4;
                try {
                    n4 = Tokenizer.tokenizeProlog(cArray, n2, cArray.length, token);
                    n3 = token.getTokenEnd();
                }
                catch (ExtensibleTokenException extensibleTokenException) {
                    n4 = extensibleTokenException.getTokenType();
                    n3 = cArray.length;
                }
                switch (n4) {
                    case 19: 
                    case 27: 
                    case 29: 
                    case 35: {
                        ++n;
                        break;
                    }
                    case 20: 
                    case 28: 
                    case 30: 
                    case 37: 
                    case 38: 
                    case 39: {
                        if (--n >= 0) break;
                        return null;
                    }
                    case 36: {
                        if ((n -= 2) >= 0) break;
                        return null;
                    }
                }
                vector.addElement(new Atom(n4, new String(cArray, n2, n3 - n2)));
                n2 = n3;
            }
        }
        catch (EmptyTokenException emptyTokenException) {
            if (n != 0) {
                return null;
            }
            return vector;
        }
        catch (EndOfPrologException endOfPrologException) {
        }
        catch (PartialTokenException partialTokenException) {
        }
        catch (InvalidTokenException invalidTokenException) {
            // empty catch block
        }
        return null;
    }

    private boolean fill() throws IOException {
        int n;
        if (this.in == null) {
            return false;
        }
        if (this.bufEnd == this.buf.length) {
            Tokenizer.movePosition(this.buf, this.posOff, this.bufStart, this.pos);
            n = this.bufEnd - this.bufStart;
            if (n == 0) {
                this.bufEnd = 0;
            } else if (n + 8192 <= this.buf.length) {
                this.bufEnd = this.buf.length - (this.buf.length - n) / 8192 * 8192;
                int n2 = 0;
                while (n2 < n) {
                    this.buf[this.bufEnd - n + n2] = this.buf[this.bufStart + n2];
                    ++n2;
                }
            } else {
                char[] cArray = new char[this.buf.length << 1];
                this.bufEnd = this.buf.length;
                System.arraycopy(this.buf, this.bufStart, cArray, this.bufEnd - n, n);
                this.buf = cArray;
            }
            this.posOff = this.bufStart = this.bufEnd - n;
        }
        if ((n = this.in.read(this.buf, this.bufEnd, this.buf.length - this.bufEnd)) < 0) {
            this.in.close();
            this.in = null;
            return false;
        }
        this.bufEnd += n;
        this.bufEndStreamOffset += (long)n;
        return true;
    }

    private void fatal(String string, String string2) throws ParseException {
        this.doFatal(localizer.message(string, string2));
    }

    private void fatal(String string) throws ParseException {
        this.doFatal(localizer.message(string));
    }

    private void doFatal(String string) throws ParseException {
        if (this.isInternal) {
            this.parent.doFatal(string);
        }
        if (this.posOff > this.currentTokenStart) {
            throw new Error("positioning botch");
        }
        Tokenizer.movePosition(this.buf, this.posOff, this.currentTokenStart, this.pos);
        this.posOff = this.currentTokenStart;
        throw new ParseException(localizer, string, this.location, this.pos.getLineNumber(), this.pos.getColumnNumber());
    }

    private void reportInvalidToken(InvalidTokenException invalidTokenException) throws ParseException {
        if (invalidTokenException.getType() == 1) {
            this.fatal("XML_TARGET");
        } else {
            this.fatal("ILLEGAL_CHAR");
        }
    }

    private void addAtom(Atom atom) {
        this.atoms.addElement(atom);
    }

    private void setLastAtomEntity(Entity entity) {
        Atom atom = (Atom)this.atoms.elementAt(this.atoms.size() - 1);
        this.atoms.setElementAt(new Atom(atom.getTokenType(), atom.getToken(), entity), this.atoms.size() - 1);
    }

    private final String bufferString(int n, int n2) {
        return this.normalizeNewlines(new String(this.buf, n, n2 - n));
    }

    private final String normalizeNewlines(String string) {
        if (this.isInternal) {
            return string;
        }
        int n = string.indexOf(13);
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\r') {
                stringBuffer.append('\n');
                if (n + 1 < string.length() && string.charAt(n + 1) == '\n') {
                    ++n;
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private void normalizeAttributeValue(char[] cArray, int n, int n2, StringBuffer stringBuffer) throws AttributeValueException {
        Token token = new Token();
        while (true) {
            int n3;
            int n4;
            try {
                n4 = Tokenizer.tokenizeAttributeValue(cArray, n, n2, token);
                n3 = token.getTokenEnd();
            }
            catch (PartialTokenException partialTokenException) {
                throw new AttributeValueException("NOT_WELL_FORMED", n2);
            }
            catch (InvalidTokenException invalidTokenException) {
                throw new AttributeValueException("ILLEGAL_CHAR", invalidTokenException.getOffset());
            }
            catch (EmptyTokenException emptyTokenException) {
                return;
            }
            catch (ExtensibleTokenException extensibleTokenException) {
                n4 = extensibleTokenException.getTokenType();
                n3 = n2;
            }
            switch (n4) {
                case 1: {
                    if (cArray == this.buf && !this.isInternal) {
                        stringBuffer.append(' ');
                        break;
                    }
                    int n5 = n;
                    while (n5 < n3) {
                        stringBuffer.append(' ');
                        ++n5;
                    }
                    break;
                }
                case 0: {
                    stringBuffer.append(cArray, n, n3 - n);
                    break;
                }
                case 10: 
                case 11: {
                    stringBuffer.append(token.getRefChar());
                    break;
                }
                case 12: {
                    char[] cArray2 = new char[2];
                    token.getRefCharPair(cArray2, 0);
                    stringBuffer.append(cArray2);
                    break;
                }
                case 16: {
                    stringBuffer.append(' ');
                    break;
                }
                case 9: {
                    String string = new String(cArray, n + 1, n3 - n - 2);
                    Entity entity = this.db.lookupGeneralEntity(string);
                    if (entity == null) {
                        throw new AttributeValueException("UNDEF_REF", string, n);
                    }
                    if (entity.systemId != null) {
                        throw new AttributeValueException("EXTERN_REF_ATTVAL", string, n);
                    }
                    try {
                        if (entity.open) {
                            throw new AttributeValueException("RECURSION", n);
                        }
                        entity.open = true;
                        this.normalizeAttributeValue(entity.text, 0, entity.text.length, stringBuffer);
                        entity.open = false;
                        break;
                    }
                    catch (AttributeValueException attributeValueException) {
                        throw new AttributeValueException(attributeValueException.key, attributeValueException.arg, n);
                    }
                }
                default: {
                    throw new Error("attribute value botch");
                }
            }
            n = n3;
        }
    }

    private Atom makeAtom(int n, int n2, int n3) {
        Atom atom;
        String string = null;
        if (n3 - n2 == 1) {
            switch (this.buf[n2]) {
                case ' ': {
                    string = " ";
                    break;
                }
                case '\t': {
                    string = "\t";
                    break;
                }
                case '\n': {
                    string = "\n";
                    break;
                }
                case ',': {
                    string = ",";
                    break;
                }
                case '|': {
                    string = "|";
                    break;
                }
                case '(': {
                    string = "(";
                    break;
                }
                case ')': {
                    string = ")";
                }
            }
        } else if (n3 - n2 == 2 && this.buf[n2] == '\r' && this.buf[n2 + 1] == '\n') {
            string = "\n";
        }
        if (string == null) {
            string = this.bufferString(n2, n3);
        }
        if ((atom = (Atom)this.atomTable.get(string)) == null) {
            atom = new Atom(n, string);
            this.atomTable.put(string, atom);
        }
        return atom;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class AttributeValueException
    extends Exception {
        int offset;
        String key;
        String arg;

        AttributeValueException(String string, int n) {
            this.key = string;
            this.arg = null;
            this.offset = n;
        }

        AttributeValueException(String string, String string2, int n) {
            this.key = string;
            this.arg = string2;
            this.offset = n;
        }
    }

    static class DeclState {
        Entity entity;
        Notation notation;

        DeclState() {
        }
    }
}

