/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.fo.DirectPropertyListBuilder;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.LinkSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;

public abstract class XMLObj
extends FObj {
    protected String tagName = "";
    protected Element element;
    protected Document doc;
    protected static Hashtable ns = new Hashtable();

    public XMLObj(FObj fObj, PropertyList propertyList, String string) {
        super(fObj, propertyList);
        this.tagName = string;
    }

    protected void addCharacters(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2 - n);
        Text text = this.doc.createTextNode(string);
        this.element.appendChild(text);
    }

    protected void addChild(FONode fONode) {
        if (fONode instanceof XMLObj) {
            ((XMLObj)fONode).addGraphic(this.doc, this.element);
        }
    }

    public void addGraphic(Document document, Element element) {
        this.doc = document;
        this.element = document.createElementNS(this.getNameSpace(), this.tagName);
        if (this.properties instanceof DirectPropertyListBuilder.AttrPropertyList) {
            Attributes attributes = ((DirectPropertyListBuilder.AttrPropertyList)this.properties).getAttributes();
            int n = 0;
            while (n < attributes.getLength()) {
                String string = attributes.getValue(n);
                String string2 = attributes.getQName(n);
                if (string2.indexOf(":") == -1) {
                    this.element.setAttribute(string2, string);
                } else {
                    String string3 = string2.substring(0, string2.indexOf(":"));
                    if (string3.equals("xmlns")) {
                        ns.put(string2.substring(string2.indexOf(":") + 1), string);
                    }
                    ns.put("xlink", "http://www.w3.org/1999/xlink");
                    this.element.setAttributeNS((String)ns.get(string3), string2, string);
                }
                ++n;
            }
        }
        element.appendChild(this.element);
    }

    public void buildTopLevel(Document document, Element element) {
        if (this.properties instanceof DirectPropertyListBuilder.AttrPropertyList) {
            Attributes attributes = ((DirectPropertyListBuilder.AttrPropertyList)this.properties).getAttributes();
            int n = 0;
            while (n < attributes.getLength()) {
                String string = attributes.getValue(n);
                String string2 = attributes.getQName(n);
                if (string2.indexOf(":") == -1) {
                    this.element.setAttribute(string2, string);
                } else {
                    String string3 = string2.substring(0, string2.indexOf(":"));
                    if (string3.equals("xmlns")) {
                        ns.put(string2.substring(string2.indexOf(":") + 1), string);
                    }
                    ns.put("xlink", "http://www.w3.org/1999/xlink");
                    this.element.setAttributeNS((String)ns.get(string3), string2, string);
                }
                ++n;
            }
        }
    }

    public Document createBasicDocument() {
        this.doc = null;
        this.element = null;
        try {
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = this.doc.createElement("graph");
            this.doc.appendChild(element);
            this.element = this.doc.getDocumentElement();
            this.buildTopLevel(this.doc, this.element);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.doc;
    }

    public void forceStartOffset(int n) {
    }

    public void forceWidth(int n) {
    }

    public Vector getMarkerSnapshot(Vector vector) {
        return vector;
    }

    public abstract String getNameSpace();

    public Status layout(Area area) throws FOPException {
        this.log.error(this.name + " outside foreign xml");
        return new Status(1);
    }

    public void removeID(IDReferences iDReferences) {
    }

    public void resetMarker() {
    }

    public void rollback(Vector vector) {
    }

    public void setIsInTableCell() {
    }

    public void setLinkSet(LinkSet linkSet) {
    }

    protected void setWritingMode() {
    }
}

