/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.apache.fop.image.analyser.AbstractImageReader;

public class PNGReader
extends AbstractImageReader {
    protected static final int PNG_SIG_LENGTH = 24;
    protected byte[] header;

    public String getMimeType() {
        return "image/png";
    }

    protected void setDefaultHeader() throws IOException {
        this.header = new byte[24];
        try {
            this.imageStream.mark(25);
            this.imageStream.read(this.header);
            this.imageStream.reset();
        }
        catch (IOException iOException) {
            try {
                this.imageStream.reset();
            }
            catch (IOException iOException2) {}
            throw iOException;
        }
    }

    protected void setDimension() {
        int n = this.header[16] & 0xFF;
        int n2 = this.header[17] & 0xFF;
        int n3 = this.header[18] & 0xFF;
        int n4 = this.header[19] & 0xFF;
        long l = n << 24 | n2 << 16 | n3 << 8 | n4;
        this.width = (int)l;
        n = this.header[20] & 0xFF;
        n2 = this.header[21] & 0xFF;
        n3 = this.header[22] & 0xFF;
        n4 = this.header[23] & 0xFF;
        l = n << 24 | n2 << 16 | n3 << 8 | n4;
        this.height = (int)l;
    }

    public boolean verifySignature(String string, BufferedInputStream bufferedInputStream) throws IOException {
        boolean bl;
        this.imageStream = bufferedInputStream;
        this.setDefaultHeader();
        boolean bl2 = bl = this.header[0] == -119 && this.header[1] == 80 && this.header[2] == 78 && this.header[3] == 71 && this.header[4] == 13 && this.header[5] == 10 && this.header[6] == 26 && this.header[7] == 10;
        if (bl) {
            this.setDimension();
            return true;
        }
        return false;
    }
}

