/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.layout.FontDescriptor;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontMetric;
import org.apache.fop.render.awt.FontMetricsMapper;
import org.apache.fop.render.pdf.CodePointMapping;
import org.apache.fop.render.pdf.Font;

public class FontState {
    private FontInfo _fontInfo;
    private String _fontName;
    private int _fontSize;
    private String _fontFamily;
    private String _fontStyle;
    private String _fontWeight;
    private int _fontVariant;
    private FontMetric _metric;
    private int _letterSpacing;
    private static Hashtable EMPTY_HASHTABLE = new Hashtable();

    public FontState(FontInfo fontInfo, String string, String string2, String string3, int n, int n2) throws FOPException {
        this._fontInfo = fontInfo;
        this._fontFamily = string;
        this._fontStyle = string2;
        this._fontWeight = string3;
        this._fontSize = n;
        String string4 = FontInfo.createFontKey(this._fontFamily, this._fontStyle, this._fontWeight);
        if (!fontInfo.hasFont(string4)) {
            StringTokenizer stringTokenizer = new StringTokenizer(this._fontFamily, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken().trim();
                if (string5.charAt(0) == '\"' || string5.charAt(0) == '\'') {
                    string5 = string5.substring(1, string5.length() - 1);
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    boolean bl = false;
                    int n3 = 0;
                    while (n3 < string5.length()) {
                        char c = string5.charAt(n3);
                        if (!FontState.isWhitespace(c)) {
                            stringBuffer.append(c);
                            bl = false;
                        } else if (!bl) {
                            stringBuffer.append(c);
                            bl = true;
                        }
                        ++n3;
                    }
                    string5 = stringBuffer.toString();
                }
                string4 = FontInfo.createFontKey(string5, this._fontStyle, this._fontWeight);
                if (!fontInfo.hasFont(string4)) continue;
                this._fontFamily = string5;
                break;
            }
        }
        this._fontName = fontInfo.fontLookup(string4);
        this._metric = fontInfo.getMetricsFor(this._fontName);
        this._fontVariant = n2;
        this._letterSpacing = 0;
    }

    public FontState(FontInfo fontInfo, String string, String string2, String string3, int n, int n2, int n3) throws FOPException {
        this(fontInfo, string, string2, string3, n, n2);
        this._letterSpacing = n3;
    }

    public int getAscender() {
        return this._metric.getAscender(this._fontSize) / 1000;
    }

    public int getCapHeight() {
        return this._metric.getCapHeight(this._fontSize) / 1000;
    }

    public int getDescender() {
        return this._metric.getDescender(this._fontSize) / 1000;
    }

    public String getFontFamily() {
        return this._fontFamily;
    }

    public FontInfo getFontInfo() {
        return this._fontInfo;
    }

    public String getFontName() {
        return this._fontName;
    }

    public int getFontSize() {
        return this._fontSize;
    }

    public String getFontStyle() {
        return this._fontStyle;
    }

    public int getFontVariant() {
        return this._fontVariant;
    }

    public String getFontWeight() {
        return this._fontWeight;
    }

    public Hashtable getKerning() {
        Hashtable hashtable;
        if (this._metric instanceof FontDescriptor && (hashtable = ((FontDescriptor)((Object)this._metric)).getKerningInfo()) != null) {
            return hashtable;
        }
        return EMPTY_HASHTABLE;
    }

    public int getLetterSpacing() {
        return this._letterSpacing;
    }

    public int getXHeight() {
        return this._metric.getXHeight(this._fontSize) / 1000;
    }

    private static boolean isWhitespace(char c) {
        return c <= ' ' && (4294981120L >> c & 1L) != 0L;
    }

    public char mapChar(char c) {
        if (this._metric instanceof Font) {
            return ((Font)this._metric).mapChar(c);
        }
        if (this._metric instanceof FontMetricsMapper) {
            return c;
        }
        char c2 = CodePointMapping.getMapping("WinAnsiEncoding").mapChar(c);
        c = c2 != '\u0000' ? c2 : (char)35;
        return c;
    }

    public int width(int n) {
        return this._letterSpacing + this._metric.width(n, this._fontSize) / 1000;
    }
}

