/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.ImageArea;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFPathPaint;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.render.pcl.PCLStream;
import org.apache.fop.svg.SVGArea;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class PCLRenderer
extends PrintRenderer {
    public PCLStream currentStream;
    private int pageHeight = 7920;
    public int curdiv = 0;
    private int divisions = -1;
    public int paperheight = -1;
    public int orientation = -1;
    public int topmargin = -1;
    public int leftmargin = -1;
    private int fullmargin = 0;
    private final boolean debug = false;
    private int xoffset = -180;
    private Hashtable options;

    protected void addLine(int n, int n2, int n3, int n4, int n5, int n6, PDFPathPaint pDFPathPaint) {
        int n7 = 0;
        int n8 = 0;
        switch (n6) {
            case 16: {
                n7 = 3;
                n8 = 3;
                break;
            }
            case 20: {
                n7 = 1;
                n8 = 3;
                break;
            }
        }
        if (n == n3) {
            if (n7 > 0 && n8 > 0) {
                int n9 = n2;
                int n10 = n5 * n7;
                while (n9 < n4) {
                    if (n9 + n10 > n4) {
                        n10 = n4 - n9;
                    }
                    this.addRect(n - n5 / 2, n9, n5, n10, pDFPathPaint, pDFPathPaint);
                    n9 += n10 + n8 * n5;
                }
            } else {
                this.addRect(n - n5 / 2, n2, n5, n4 - n2 + 1, pDFPathPaint, pDFPathPaint);
            }
        } else if (n2 == n4) {
            if (n7 > 0 && n8 > 0) {
                int n11 = n;
                int n12 = n5 * n7;
                while (n11 < n3) {
                    if (n11 + n12 > n3) {
                        n12 = n3 - n11;
                    }
                    this.addRect(n11, n2 + n5 / 2, n12, n5, pDFPathPaint, pDFPathPaint);
                    n11 += n12 + n8 * n5;
                }
            } else {
                this.addRect(n, n2 + n5 / 2, n3 - n + 1, n5, pDFPathPaint, pDFPathPaint);
            }
        }
    }

    protected void addLine(int n, int n2, int n3, int n4, int n5, PDFPathPaint pDFPathPaint) {
        if (n == n3) {
            this.addRect(n - n5 / 2, n2, n5, n4 - n2 + 1, pDFPathPaint, pDFPathPaint);
        } else if (n2 == n4) {
            this.addRect(n, n2 + n5 / 2, n3 - n + 1, n5, pDFPathPaint, pDFPathPaint);
        }
    }

    protected void addRect(int n, int n2, int n3, int n4, PDFPathPaint pDFPathPaint) {
        if (n4 >= 0 && n4 < 720 || n4 < 0 && n4 > -720 || n3 < 720) {
            if (n3 < 720) {
                n3 = 720;
            }
            if (n4 > 0 && n4 < 720) {
                n4 = 720;
            } else if (n4 < 0 && n4 > -720) {
                n4 = -720;
            }
            this.addRect(n, n2, n3, n4, pDFPathPaint, pDFPathPaint);
        } else {
            this.addRect(n, n2, n3, 720, pDFPathPaint, pDFPathPaint);
            this.addRect(n, n2, 720, n4, pDFPathPaint, pDFPathPaint);
            this.addRect(n + n3 - 720, n2, 720, n4, pDFPathPaint, pDFPathPaint);
            this.addRect(n, n2 - n4 + 720, n3, 720, pDFPathPaint, pDFPathPaint);
        }
    }

    protected void addRect(int n, int n2, int n3, int n4, PDFPathPaint pDFPathPaint, PDFPathPaint pDFPathPaint2) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        if (n4 < 0) {
            n4 *= -1;
        } else {
            n2 += n4;
        }
        PDFColor pDFColor = (PDFColor)pDFPathPaint;
        PDFColor pDFColor2 = (PDFColor)pDFPathPaint2;
        pDFColor.setColorSpace(ColorSpace.DEVICE_RGB);
        pDFColor2.setColorSpace(ColorSpace.DEVICE_RGB);
        int n5 = (int)(100.0 - ((double)0.3f * pDFColor.red() + (double)0.59f * pDFColor.green() + (double)0.11f * pDFColor.blue()) * 100.0);
        int n6 = (int)(100.0 - ((double)0.3f * pDFColor2.red() + (double)0.59f * pDFColor2.green() + (double)0.11f * pDFColor2.blue()) * 100.0);
        int n7 = this.xoffset + n / 100;
        if (n7 < 0) {
            n7 = 0;
            this.log.warn("Horizontal position out of bounds.");
        }
        this.currentStream.add("\u001b*v1O\u001b&a" + n7 + "h" + (this.pageHeight - n2 / 100) + "V" + "\u001b*c" + n3 / 100 + "h" + n4 / 100 + "V" + "\u001b*c" + n5 + "G" + "\u001b*c2P");
        if (n6 != n5 && (n3 >= 720 || n4 >= 720)) {
            n7 = this.xoffset + (n + 240) / 100;
            if (n7 < 0) {
                n7 = 0;
                this.log.warn("Horizontal position out of bounds.");
            }
            this.currentStream.add("\u001b&a" + n7 + "h" + (this.pageHeight - (n2 + 240) / 100) + "V" + "\u001b*c" + (n3 - 480) / 100 + "h" + (n4 - 480) / 100 + "V" + "\u001b*c" + n6 + "G" + "\u001b*c2P");
        }
        this.currentStream.add("\u001b*v0O");
    }

    protected void drawImageClipped(int n, int n2, int n3, int n4, int n5, int n6, FopImage fopImage, FontState fontState) {
    }

    protected void drawImageScaled(int n, int n2, int n3, int n4, FopImage fopImage, FontState fontState) {
    }

    boolean printBMP(FopImage fopImage, int n, int n2, int n3, int n4) throws FopImageException {
        byte[] byArray = fopImage.getBitmaps();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = fopImage.getWidth();
        int n9 = fopImage.getHeight();
        int n10 = n8 / 8;
        if (n8 % 8 != 0) {
            ++n10;
        }
        char[] cArray = new char[n10 * 2];
        char[] cArray2 = new char[n10];
        int n11 = -1;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        boolean bl = fopImage.getColorSpace().getColorSpace() != ColorSpace.DEVICE_GRAY;
        boolean bl2 = false;
        int n18 = n8 * 72000 / n3;
        int n19 = n9 * 72000 / n4;
        int n20 = n18;
        if (n19 > n18) {
            n20 = n19;
        }
        n20 = n20 > 300 ? 600 : (n20 > 150 ? 300 : (n20 > 100 ? 150 : (n20 > 75 ? 100 : 75)));
        this.currentStream.add("\u001b*t" + n20 + "R\u001b*r0F\u001b*r1A");
        n6 = 0;
        while (n6 < n9) {
            int n21 = 0;
            n7 = n6 * n8;
            if (bl) {
                n7 *= 3;
            }
            n5 = 0;
            while (n5 < n8) {
                if (bl) {
                    n14 = byArray[n7++] & 0xFF;
                    n15 = byArray[n7++] & 0xFF;
                    n16 = byArray[n7++] & 0xFF;
                    n17 = (n14 * 30 + n15 * 59 + n16 * 11) / 100;
                } else {
                    n17 = byArray[n7++] & 0xFF;
                }
                if (n17 < 128) {
                    n21 = (byte)(n21 | 1 << 7 - n5 % 8);
                }
                if (n5 % 8 == 7 || n5 + 1 == n8) {
                    if (n13 < n10) {
                        if (n11 >= 0) {
                            if (n21 == n12) {
                                ++n11;
                            } else {
                                cArray[n13++] = (char)(n11 & 0xFF);
                                cArray[n13++] = (char)n12;
                                n12 = n21;
                                n11 = 0;
                            }
                        } else {
                            n12 = n21;
                            n11 = 0;
                        }
                        if (n11 == 255 || n5 + 1 == n8) {
                            cArray[n13++] = (char)(n11 & 0xFF);
                            cArray[n13++] = (char)n12;
                            n12 = 0;
                            n11 = -1;
                        }
                    }
                    cArray2[n5 / 8] = (char)n21;
                    n21 = 0;
                }
                ++n5;
            }
            if (n13 < n10) {
                this.currentStream.add("\u001b*b1m" + n13 + "W");
                this.currentStream.add(new String(cArray, 0, n13));
            } else {
                this.currentStream.add("\u001b*b0m" + n10 + "W");
                this.currentStream.add(new String(cArray2));
            }
            n11 = -1;
            n13 = 0;
            ++n6;
        }
        this.currentStream.add("\u001b*rB");
        return true;
    }

    public void render(Page page, OutputStream outputStream) throws IOException {
        this.idReferences = page.getIDReferences();
        this.renderPage(page);
    }

    public void renderForeignObjectArea(ForeignObjectArea foreignObjectArea) {
        this.currentXPosition += foreignObjectArea.getXOffset();
        this.currentYPosition = this.currentYPosition;
        switch (foreignObjectArea.getAlign()) {
            default: 
        }
        switch (foreignObjectArea.getVerticalAlign()) {
            default: 
        }
        switch (foreignObjectArea.scalingMethod()) {
            default: 
        }
        switch (foreignObjectArea.getOverflow()) {
            default: 
        }
        foreignObjectArea.getObject().render(this);
        this.currentXPosition += foreignObjectArea.getEffectiveWidth();
    }

    public void renderImageArea(ImageArea imageArea) {
        int n = this.currentAreaContainerXPosition + imageArea.getXOffset();
        int n2 = this.currentYPosition;
        int n3 = imageArea.getContentWidth();
        int n4 = imageArea.getHeight();
        this.currentYPosition -= n4;
        FopImage fopImage = imageArea.getImage();
        int n5 = this.xoffset + n / 100;
        if (n5 < 0) {
            n5 = 0;
            this.log.warn("Horizontal position out of bounds.");
        }
        this.currentStream.add("\u001b&a" + n5 + "h" + (this.pageHeight - n2 / 100) + "V");
        try {
            this.printBMP(fopImage, n, n2, n3, n4);
        }
        catch (FopImageException fopImageException) {
            this.log.error("PCLRenderer.renderImageArea() Error printing BMP (" + fopImageException.toString() + ")");
        }
    }

    public void renderPage(Page page) {
        if (this.paperheight > 0 && this.divisions == -1) {
            this.divisions = this.paperheight / (page.getHeight() / 100);
        }
        if (this.divisions > 0) {
            this.fullmargin = this.paperheight * this.curdiv / this.divisions;
        }
        if (this.topmargin > 0) {
            this.fullmargin += this.topmargin;
        }
        this.pageHeight = this.paperheight > 0 ? this.paperheight / this.divisions + this.fullmargin : page.getHeight() / 100;
        if (this.leftmargin > 0 && this.curdiv == 0) {
            this.currentStream.add("\u001b&k" + (float)this.leftmargin / 6.0f + "H\u001b&a1L\u001b&k12H");
        }
        BodyAreaContainer bodyAreaContainer = page.getBody();
        AreaContainer areaContainer = page.getBefore();
        AreaContainer areaContainer2 = page.getAfter();
        AreaContainer areaContainer3 = page.getStart();
        AreaContainer areaContainer4 = page.getEnd();
        this.currentFontName = "";
        this.currentFontSize = 0;
        this.renderBodyAreaContainer(bodyAreaContainer);
        if (areaContainer != null) {
            this.renderAreaContainer(areaContainer);
        }
        if (areaContainer2 != null) {
            this.renderAreaContainer(areaContainer2);
        }
        if (areaContainer3 != null) {
            this.renderAreaContainer(areaContainer3);
        }
        if (areaContainer4 != null) {
            this.renderAreaContainer(areaContainer4);
        }
        if (++this.curdiv == this.divisions || this.divisions == -1) {
            this.curdiv = 0;
            this.currentStream.add("\f");
        }
    }

    public void renderSVGArea(SVGArea sVGArea) {
        int n = this.currentXPosition;
        int n2 = this.currentYPosition;
        SVGSVGElement sVGSVGElement = ((SVGDocument)sVGArea.getSVGDocument()).getRootElement();
        int n3 = (int)(sVGSVGElement.getWidth().getBaseVal().getValue() * 1000.0f);
        int n4 = (int)(sVGSVGElement.getHeight().getBaseVal().getValue() * 1000.0f);
    }

    public void renderWordArea(WordArea wordArea) {
        String string;
        String string2 = wordArea.getFontState().getFontName();
        int n = wordArea.getFontState().getFontSize();
        float f = wordArea.getRed();
        float f2 = wordArea.getGreen();
        float f3 = wordArea.getBlue();
        PDFColor pDFColor = new PDFColor(wordArea.getRed(), wordArea.getGreen(), wordArea.getBlue());
        this.currentStream.add("\u001b*v1O\u001b*c" + (int)(100.0f - (0.3f * f + 0.59f * f2 + 0.11f * f3) * 100.0f) + "G\u001b*v2T");
        if (!string2.equals(this.currentFontName) || n != this.currentFontSize) {
            this.currentFontName = string2;
            this.currentFontSize = n;
            this.setFont(string2, n);
        }
        this.currentFill = pDFColor;
        int n2 = this.currentXPosition;
        int n3 = this.currentYPosition;
        if (wordArea.getPageNumberID() != null) {
            string = this.idReferences.getPageNumber(wordArea.getPageNumberID());
            if (string == null) {
                string = "";
            }
        } else {
            string = wordArea.getText();
        }
        this.addWordLines(wordArea, n2, n3, n, pDFColor);
        int n4 = this.xoffset + n2 / 100;
        if (n4 < 0) {
            n4 = 0;
            this.log.warn("Horizontal position out of bounds.");
        }
        this.currentStream.add("\u001b&a" + n4 + "h" + (this.pageHeight - n3 / 100) + "V" + string);
        this.currentXPosition += wordArea.getContentWidth();
    }

    public void setFont(String string, float f) {
        int n = 0;
        if (string.length() > 1 && string.charAt(0) == 'F') {
            try {
                n = Integer.parseInt(string.substring(1));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        switch (n) {
            case 1: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + f / 1000.0f + "v0s0b16602T");
                break;
            }
            case 2: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + f / 1000.0f + "v1s0b16602T");
                break;
            }
            case 3: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + f / 1000.0f + "v0s3b16602T");
                break;
            }
            case 4: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + f / 1000.0f + "v1s3b16602T");
                break;
            }
            case 5: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + f / 1000.0f + "v0s0b16901T");
                break;
            }
            case 6: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + f / 1000.0f + "v1s0b16901T");
                break;
            }
            case 7: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + f / 1000.0f + "v0s3b16901T");
                break;
            }
            case 8: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + f / 1000.0f + "v1s3b16901T");
                break;
            }
            case 9: {
                this.currentStream.add("\u001b(0N\u001b(s0p" + 120.01f / (f / 1000.0f) + "h0s0b4099T");
                break;
            }
            case 10: {
                this.currentStream.add("\u001b(0N\u001b(s0p" + 120.01f / (f / 1000.0f) + "h1s0b4099T");
                break;
            }
            case 11: {
                this.currentStream.add("\u001b(0N\u001b(s0p" + 120.01f / (f / 1000.0f) + "h0s3b4099T");
                break;
            }
            case 12: {
                this.currentStream.add("\u001b(0N\u001b(s0p" + 120.01f / (f / 1000.0f) + "h1s3b4099T");
                break;
            }
            case 13: {
                this.currentStream.add("\u001b(19M\u001b(s1p" + f / 1000.0f + "v0s0b16686T");
                break;
            }
            case 14: {
                this.currentStream.add("\u001b(14L\u001b(s1p" + f / 1000.0f + "v0s0b45101T");
                break;
            }
            default: {
                this.currentStream.add("\u001b(0N\u001b(s" + f / 1000.0f + "V");
            }
        }
    }

    public void setOptions(Hashtable hashtable) {
        this.options = hashtable;
    }

    public void setProducer(String string) {
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.log.info("rendering areas to PCL");
        this.currentStream = new PCLStream(outputStream);
        if (this.orientation > -1) {
            this.currentStream.add("\u001b&l" + this.orientation + "O");
        } else {
            this.currentStream.add("\u001b&l0O");
        }
        this.xoffset = this.orientation == 1 || this.orientation == 3 ? -144 : -180;
        this.currentStream.add("\u001b9\u001b&l0E");
    }

    public void stopRenderer(OutputStream outputStream) throws IOException {
        this.log.info("writing out PCL");
        outputStream.flush();
    }
}

