/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.configuration.ConfigurationReader;
import org.apache.fop.render.pdf.Font;
import org.apache.fop.render.pdf.fonts.BFEntry;
import org.apache.fop.render.pdf.fonts.MultiByteFont;
import org.apache.fop.render.pdf.fonts.SingleByteFont;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FontReader
extends DefaultHandler {
    private Locator locator = null;
    private boolean isCID = false;
    private MultiByteFont multiFont = null;
    private SingleByteFont singleFont = null;
    private Font returnFont = null;
    private String text = null;
    private Vector cidWidths = null;
    private int cidWidthIndex = 0;
    private Hashtable currentKerning = null;
    private Vector bfranges = null;

    public FontReader(String string) throws FOPException {
        this.createFont(string);
    }

    public void characters(char[] cArray, int n, int n2) {
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        this.text = new String(cArray2);
    }

    private void createFont(String string) throws FOPException {
        XMLReader xMLReader = ConfigurationReader.createParser();
        if (xMLReader == null) {
            throw new FOPException("Unable to create SAX parser");
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXException sAXException) {
            throw new FOPException("You need a SAX parser which supports SAX version 2", sAXException);
        }
        xMLReader.setContentHandler(this);
        try {
            xMLReader.parse(string);
        }
        catch (SAXException sAXException) {
            throw new FOPException(sAXException);
        }
        catch (IOException iOException) {
            throw new FOPException(iOException);
        }
    }

    public void endElement(String string, String string2, String string3) {
        if ("font-name".equals(string2)) {
            if (this.isCID) {
                this.multiFont.fontName = this.text;
            } else {
                this.singleFont.fontName = this.text;
            }
        }
        if ("ttc-name".equals(string2) && this.isCID) {
            this.multiFont.ttcName = this.text;
        } else if ("cap-height".equals(string2)) {
            if (this.isCID) {
                this.multiFont.capHeight = this.getInt(this.text);
            } else {
                this.singleFont.capHeight = this.getInt(this.text);
            }
        } else if ("x-height".equals(string2)) {
            if (this.isCID) {
                this.multiFont.xHeight = this.getInt(this.text);
            } else {
                this.singleFont.xHeight = this.getInt(this.text);
            }
        } else if ("ascender".equals(string2)) {
            if (this.isCID) {
                this.multiFont.ascender = this.getInt(this.text);
            } else {
                this.singleFont.ascender = this.getInt(this.text);
            }
        } else if ("descender".equals(string2)) {
            if (this.isCID) {
                this.multiFont.descender = this.getInt(this.text);
            } else {
                this.singleFont.descender = this.getInt(this.text);
            }
        } else if ("left".equals(string2)) {
            if (this.isCID) {
                this.multiFont.fontBBox[0] = this.getInt(this.text);
            } else {
                this.singleFont.fontBBox[0] = this.getInt(this.text);
            }
        } else if ("bottom".equals(string2)) {
            if (this.isCID) {
                this.multiFont.fontBBox[1] = this.getInt(this.text);
            } else {
                this.singleFont.fontBBox[1] = this.getInt(this.text);
            }
        } else if ("right".equals(string2)) {
            if (this.isCID) {
                this.multiFont.fontBBox[2] = this.getInt(this.text);
            } else {
                this.singleFont.fontBBox[2] = this.getInt(this.text);
            }
        } else if ("first-char".equals(string2)) {
            this.singleFont.firstChar = this.getInt(this.text);
        } else if ("last-char".equals(string2)) {
            this.singleFont.lastChar = this.getInt(this.text);
        } else if ("top".equals(string2)) {
            if (this.isCID) {
                this.multiFont.fontBBox[3] = this.getInt(this.text);
            } else {
                this.singleFont.fontBBox[3] = this.getInt(this.text);
            }
        } else if ("flags".equals(string2)) {
            if (this.isCID) {
                this.multiFont.flags = this.getInt(this.text);
            } else {
                this.singleFont.flags = this.getInt(this.text);
            }
        } else if ("stemv".equals(string2)) {
            if (this.isCID) {
                this.multiFont.stemV = this.getInt(this.text);
            } else {
                this.singleFont.stemV = this.getInt(this.text);
            }
        } else if ("italic-angle".equals(string2)) {
            if (this.isCID) {
                this.multiFont.italicAngle = this.getInt(this.text);
            } else {
                this.singleFont.italicAngle = this.getInt(this.text);
            }
        } else if ("missing-width".equals(string2)) {
            if (this.isCID) {
                this.multiFont.missingWidth = this.getInt(this.text);
            } else {
                this.singleFont.missingWidth = this.getInt(this.text);
            }
        } else if ("cid-type".equals(string2)) {
            if ("CIDFontType2".equals(this.text)) {
                this.multiFont.cidType = 1;
            }
        } else if ("default-width".equals(string2)) {
            this.multiFont.defaultWidth = this.getInt(this.text);
        } else if ("cid-widths".equals(string2)) {
            int[] nArray = new int[this.cidWidths.size()];
            int n = 0;
            Enumeration enumeration = this.cidWidths.elements();
            while (enumeration.hasMoreElements()) {
                Integer n2 = (Integer)enumeration.nextElement();
                nArray[n++] = n2;
            }
            this.multiFont.warray.addEntry(this.cidWidthIndex, nArray);
            this.multiFont.width = nArray;
        } else if ("bfranges".equals(string2)) {
            Object[] objectArray = new BFEntry[this.bfranges.size()];
            this.bfranges.copyInto(objectArray);
            this.multiFont.bfentries = objectArray;
        }
    }

    public Font getFont() {
        return this.returnFont;
    }

    private int getInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {}
        return n;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setFontEmbedPath(String string) {
        if (this.isCID) {
            this.multiFont.embedFileName = string;
        } else {
            this.singleFont.embedFileName = string;
        }
    }

    public void startDocument() {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string2.equals("font-metrics")) {
            if ("TYPE0".equals(attributes.getValue("type"))) {
                this.multiFont = new MultiByteFont();
                this.returnFont = this.multiFont;
                this.isCID = true;
            } else if ("TRUETYPE".equals(attributes.getValue("type"))) {
                this.singleFont = new SingleByteFont();
                this.singleFont.subType = (byte)4;
                this.returnFont = this.singleFont;
                this.isCID = false;
            } else {
                this.singleFont = new SingleByteFont();
                this.singleFont.subType = 1;
                this.returnFont = this.singleFont;
                this.isCID = false;
            }
        } else if ("embed".equals(string2)) {
            if (this.isCID) {
                this.multiFont.embedFileName = attributes.getValue("file");
                this.multiFont.embedResourceName = attributes.getValue("class");
            } else {
                this.singleFont.embedFileName = attributes.getValue("file");
                this.singleFont.embedResourceName = attributes.getValue("class");
            }
        } else if ("cid-widths".equals(string2)) {
            this.cidWidthIndex = this.getInt(attributes.getValue("start-index"));
            this.cidWidths = new Vector();
        } else if ("kerning".equals(string2)) {
            this.currentKerning = new Hashtable();
            if (this.isCID) {
                this.multiFont.kerning.put(new Integer(attributes.getValue("kpx1")), this.currentKerning);
            } else {
                this.singleFont.kerning.put(new Integer(attributes.getValue("kpx1")), this.currentKerning);
            }
        } else if ("bfranges".equals(string2)) {
            this.bfranges = new Vector();
        } else if ("bf".equals(string2)) {
            BFEntry bFEntry = new BFEntry();
            bFEntry.unicodeStart = this.getInt(attributes.getValue("us"));
            bFEntry.unicodeEnd = this.getInt(attributes.getValue("ue"));
            bFEntry.glyphStartIndex = this.getInt(attributes.getValue("gi"));
            this.bfranges.addElement(bFEntry);
        } else if ("wx".equals(string2)) {
            this.cidWidths.addElement(new Integer(attributes.getValue("w")));
        } else if ("widths".equals(string2)) {
            this.singleFont.width = new int[256];
        } else if ("char".equals(string2)) {
            try {
                this.singleFont.width[Integer.parseInt((String)attributes.getValue((String)"idx"))] = Integer.parseInt(attributes.getValue("wdt"));
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Malformed width in metric file: " + numberFormatException.getMessage());
            }
        } else if ("pair".equals(string2)) {
            this.currentKerning.put(new Integer(attributes.getValue("kpx2")), new Integer(attributes.getValue("kern")));
        }
    }

    public void useKerning(boolean bl) {
        if (this.isCID) {
            this.multiFont.useKerning = true;
        } else {
            this.singleFont.useKerning = true;
        }
    }
}

