/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.render.ps.Finalizable;

public class ASCII85OutputStream
extends FilterOutputStream
implements Finalizable {
    private static final int ZERO = 122;
    private static final byte[] ZERO_ARRAY = new byte[]{122};
    private static final int START = 33;
    private static final int EOL = 10;
    private static final byte[] EOD = new byte[]{126, 62};
    private static final long base85_4 = 85L;
    private static final long base85_3 = 7225L;
    private static final long base85_2 = 614125L;
    private static final long base85_1 = 52200625L;
    private static final boolean DEBUG = false;
    private int pos = 0;
    private long buffer = 0L;
    private int posinline = 0;
    private int bw = 0;

    public ASCII85OutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    private void checkedWrite(int n) throws IOException {
        if (this.posinline == 80) {
            this.out.write(10);
            ++this.bw;
            this.posinline = 0;
        }
        this.checkedWrite(n);
        ++this.posinline;
        ++this.bw;
    }

    private void checkedWrite(byte[] byArray) throws IOException {
        this.checkedWrite(byArray, byArray.length);
    }

    private void checkedWrite(byte[] byArray, int n) throws IOException {
        if (this.posinline + n > 80) {
            int n2 = n - (this.posinline + n - 80);
            if (n2 > 0) {
                this.out.write(byArray, 0, n2);
            }
            this.out.write(10);
            ++this.bw;
            int n3 = n - n2;
            if (n3 > 0) {
                this.out.write(byArray, n2, n3);
            }
            this.posinline = n3;
        } else {
            this.out.write(byArray, 0, n);
            this.posinline += n;
        }
        this.bw += n;
    }

    public void close() throws IOException {
        this.finalizeStream();
        super.close();
    }

    private byte[] convertWord(long l) {
        if ((l &= 0xFFFFFFFFFFFFFFFFL) == 0L) {
            return ZERO_ARRAY;
        }
        if (l < 0L) {
            l = -l;
        }
        byte by = (byte)(l / 52200625L & 0xFFL);
        byte by2 = (byte)((l - (long)by * 52200625L) / 614125L & 0xFFL);
        byte by3 = (byte)((l - (long)by * 52200625L - (long)by2 * 614125L) / 7225L & 0xFFL);
        byte by4 = (byte)((l - (long)by * 52200625L - (long)by2 * 614125L - (long)by3 * 7225L) / 85L & 0xFFL);
        byte by5 = (byte)(l - (long)by * 52200625L - (long)by2 * 614125L - (long)by3 * 7225L - (long)by4 * 85L & 0xFFL);
        byte[] byArray = new byte[]{(byte)(by + 33), (byte)(by2 + 33), (byte)(by3 + 33), (byte)(by4 + 33), (byte)(by5 + 33)};
        return byArray;
    }

    public void finalizeStream() throws IOException {
        if (this.pos > 0) {
            byte[] byArray;
            int n = this.pos;
            if (this.buffer != 0L) {
                byArray = this.convertWord(this.buffer);
            } else {
                byArray = new byte[5];
                int n2 = 0;
                while (n2 < 5) {
                    byArray[n2] = 33;
                    ++n2;
                }
            }
            this.checkedWrite(byArray, n + 1);
        }
        this.checkedWrite(EOD);
        this.flush();
        if (this.out instanceof Finalizable) {
            ((Finalizable)((Object)this.out)).finalizeStream();
        }
    }

    public void write(int n) throws IOException {
        this.buffer = this.pos == 0 ? (this.buffer += (long)(n << 24) & 0xFF000000L) : (this.pos == 1 ? (this.buffer += (long)(n << 16) & 0xFF0000L) : (this.pos == 2 ? (this.buffer += (long)(n << 8) & 0xFF00L) : (this.buffer += (long)n & 0xFFL)));
        ++this.pos;
        if (this.pos > 3) {
            this.checkedWrite(this.convertWord(this.buffer));
            this.buffer = 0L;
            this.pos = 0;
        }
    }
}

