/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout.hyphenation;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.fop.layout.hyphenation.ByteVector;
import org.apache.fop.layout.hyphenation.Hyphenation;
import org.apache.fop.layout.hyphenation.HyphenationException;
import org.apache.fop.layout.hyphenation.PatternConsumer;
import org.apache.fop.layout.hyphenation.PatternParser;
import org.apache.fop.layout.hyphenation.TernaryTree;

public class HyphenationTree
extends TernaryTree
implements PatternConsumer,
Serializable {
    protected ByteVector vspace;
    protected Hashtable stoplist = new Hashtable(23);
    protected TernaryTree classmap = new TernaryTree();
    private transient TernaryTree ivalues;

    public HyphenationTree() {
        this.vspace = new ByteVector();
        this.vspace.alloc(1);
    }

    protected int packValues(String string) {
        int n = string.length();
        int n2 = (n & 1) == 1 ? (n >> 1) + 2 : (n >> 1) + 1;
        int n3 = this.vspace.alloc(n2);
        byte[] byArray = this.vspace.getArray();
        int n4 = 0;
        while (n4 < n) {
            int n5 = n4 >> 1;
            byte by = (byte)(string.charAt(n4) - 48 + 1 & 0xF);
            byArray[n5 + n3] = (n4 & 1) == 1 ? (byte)(byArray[n5 + n3] | by) : (byte)(by << 4);
            ++n4;
        }
        byArray[n2 - 1 + n3] = 0;
        return n3;
    }

    protected String unpackValues(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = this.vspace.get(n++);
        while (by != 0) {
            char c = (char)((by >>> 4) - 1 + 48);
            stringBuffer.append(c);
            c = (char)(by & 0xF);
            if (c == '\u0000') break;
            c = (char)(c - '\u0001' + 48);
            stringBuffer.append(c);
            by = this.vspace.get(n++);
        }
        return stringBuffer.toString();
    }

    public void loadPatterns(String string) throws HyphenationException {
        PatternParser patternParser = new PatternParser(this);
        this.ivalues = new TernaryTree();
        patternParser.parse(string);
        this.trimToSize();
        this.vspace.trimToSize();
        this.classmap.trimToSize();
        this.ivalues = null;
    }

    public String findPattern(String string) {
        int n = super.find(string);
        if (n >= 0) {
            return this.unpackValues(n);
        }
        return "";
    }

    protected int hstrcmp(char[] cArray, int n, char[] cArray2, int n2) {
        while (cArray[n] == cArray2[n2]) {
            if (cArray[n] == '\u0000') {
                return 0;
            }
            ++n;
            ++n2;
        }
        if (cArray2[n2] == '\u0000') {
            return 0;
        }
        return cArray[n] - cArray2[n2];
    }

    protected byte[] getValues(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = this.vspace.get(n++);
        while (by != 0) {
            char c = (char)((by >>> 4) - 1);
            stringBuffer.append(c);
            c = (char)(by & 0xF);
            if (c == '\u0000') break;
            c = (char)(c - '\u0001');
            stringBuffer.append(c);
            by = this.vspace.get(n++);
        }
        byte[] byArray = new byte[stringBuffer.length()];
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = (byte)stringBuffer.charAt(n2);
            ++n2;
        }
        return byArray;
    }

    protected void searchPatterns(char[] cArray, int n, byte[] byArray) {
        int n2 = n;
        char c = cArray[n2];
        char c2 = this.root;
        block0: while (c2 > '\u0000' && c2 < this.sc.length) {
            int n3;
            int n4;
            byte[] byArray2;
            if (this.sc[c2] == '\uffff') {
                if (this.hstrcmp(cArray, n2, this.kv.getArray(), this.lo[c2]) == 0) {
                    byArray2 = this.getValues(this.eq[c2]);
                    n4 = n;
                    n3 = 0;
                    while (n3 < byArray2.length) {
                        if (n4 < byArray.length && byArray2[n3] > byArray[n4]) {
                            byArray[n4] = byArray2[n3];
                        }
                        ++n4;
                        ++n3;
                    }
                }
                return;
            }
            n4 = c - this.sc[c2];
            if (n4 == 0) {
                if (c == '\u0000') break;
                c = cArray[++n2];
                char c3 = c2 = this.eq[c2];
                while (c3 > '\u0000' && c3 < this.sc.length) {
                    if (this.sc[c3] == '\uffff') continue block0;
                    if (this.sc[c3] == '\u0000') {
                        byArray2 = this.getValues(this.eq[c3]);
                        n3 = n;
                        int n5 = 0;
                        while (n5 < byArray2.length) {
                            if (n3 < byArray.length && byArray2[n5] > byArray[n3]) {
                                byArray[n3] = byArray2[n5];
                            }
                            ++n3;
                            ++n5;
                        }
                        continue block0;
                    }
                    c3 = this.lo[c3];
                }
                continue;
            }
            char c4 = c2 = n4 < 0 ? this.lo[c2] : this.hi[c2];
        }
    }

    public Hyphenation hyphenate(String string, int n, int n2) {
        char[] cArray = string.toCharArray();
        return this.hyphenate(cArray, 0, cArray.length, n, n2);
    }

    public Hyphenation hyphenate(char[] cArray, int n, int n2, int n3, int n4) {
        Object object;
        char[] cArray2 = new char[n2 + 3];
        char[] cArray3 = new char[2];
        int n5 = 1;
        while (n5 <= n2) {
            cArray3[0] = cArray[n + n5 - 1];
            int n6 = this.classmap.find(cArray3, 0);
            if (n6 < 0) {
                return null;
            }
            cArray2[n5] = (char)n6;
            ++n5;
        }
        int[] nArray = new int[n2 + 1];
        int n7 = 0;
        String string = new String(cArray2, 1, n2);
        if (this.stoplist.containsKey(string)) {
            object = (Vector)this.stoplist.get(string);
            int n8 = 0;
            n5 = 0;
            while (n5 < ((Vector)object).size()) {
                Object e = ((Vector)object).elementAt(n5);
                if (e instanceof String && (n8 += ((String)e).length()) >= n3 && n8 < n2 - n4) {
                    nArray[n7++] = n8;
                }
                ++n5;
            }
        } else {
            cArray2[0] = 46;
            cArray2[n2 + 1] = 46;
            cArray2[n2 + 2] = '\u0000';
            object = new byte[n2 + 3];
            n5 = 0;
            while (n5 < n2 + 1) {
                this.searchPatterns(cArray2, n5, (byte[])object);
                ++n5;
            }
            n5 = 0;
            while (n5 < n2) {
                if ((object[n5 + 1] & 1) == 1 && n5 >= n3 && n5 < n2 - n4) {
                    nArray[n7++] = n5;
                }
                ++n5;
            }
        }
        if (n7 > 0) {
            object = new int[n7];
            System.arraycopy(nArray, 0, object, 0, n7);
            return new Hyphenation(new String(cArray, n, n2), (int[])object);
        }
        return null;
    }

    public void addClass(String string) {
        if (string.length() > 0) {
            char c = string.charAt(0);
            char[] cArray = new char[2];
            cArray[1] = '\u0000';
            int n = 0;
            while (n < string.length()) {
                cArray[0] = string.charAt(n);
                this.classmap.insert(cArray, 0, c);
                ++n;
            }
        }
    }

    public void addException(String string, Vector vector) {
        this.stoplist.put(string, vector);
    }

    public void addPattern(String string, String string2) {
        int n = this.ivalues.find(string2);
        if (n <= 0) {
            n = this.packValues(string2);
            this.ivalues.insert(string2, (char)n);
        }
        this.insert(string, (char)n);
    }

    public void printStats() {
        System.out.println("Value space size = " + Integer.toString(this.vspace.length()));
        super.printStats();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] stringArray) throws Exception {
        HyphenationTree hyphenationTree = null;
        int n = 2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            String string;
            Object object2;
            System.out.print("l:\tload patterns from XML\nL:\tload patterns from serialized object\ns:\tset minimun character count\nw:\twrite hyphenation tree to object file\nh:\thyphenate\nf:\tfind pattern\nb:\tbenchmark\nq:\tquit\n\nCommand:");
            String string2 = bufferedReader.readLine().trim();
            if (string2.equals("f")) {
                System.out.print("Pattern: ");
                string2 = bufferedReader.readLine().trim();
                System.out.println("Values: " + hyphenationTree.findPattern(string2));
                continue;
            }
            if (string2.equals("s")) {
                System.out.print("Minimun value: ");
                string2 = bufferedReader.readLine().trim();
                n = Integer.parseInt(string2);
                continue;
            }
            if (string2.equals("l")) {
                hyphenationTree = new HyphenationTree();
                System.out.print("XML file name: ");
                string2 = bufferedReader.readLine().trim();
                hyphenationTree.loadPatterns(string2);
                continue;
            }
            if (string2.equals("L")) {
                ObjectInputStream objectInputStream = null;
                System.out.print("Object file name: ");
                string2 = bufferedReader.readLine().trim();
                objectInputStream = new ObjectInputStream(new FileInputStream(string2));
                hyphenationTree = (HyphenationTree)objectInputStream.readObject();
                Object var8_13 = null;
                if (objectInputStream == null) continue;
                try {
                    objectInputStream.close();
                }
                catch (IOException object2) {}
                continue;
                {
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Object var8_14 = null;
                        if (objectInputStream == null) continue;
                        try {
                            objectInputStream.close();
                        }
                        catch (IOException object2) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_15 = null;
                    if (objectInputStream == null) throw throwable;
                    try {
                        objectInputStream.close();
                        throw throwable;
                    }
                    catch (IOException object2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (string2.equals("w")) {
                System.out.print("Object file name: ");
                string2 = bufferedReader.readLine().trim();
                ObjectOutputStream objectOutputStream = null;
                objectOutputStream = new ObjectOutputStream(new FileOutputStream(string2));
                objectOutputStream.writeObject(hyphenationTree);
                string = null;
                if (objectOutputStream == null) continue;
                try {
                    objectOutputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
                continue;
                {
                    catch (Exception exception) {
                        exception.printStackTrace();
                        string = null;
                        if (objectOutputStream == null) continue;
                        try {
                            objectOutputStream.flush();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            objectOutputStream.close();
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    string = null;
                    if (objectOutputStream == null) throw throwable;
                    try {
                        objectOutputStream.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        objectOutputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (string2.equals("h")) {
                System.out.print("Word: ");
                string2 = bufferedReader.readLine().trim();
                System.out.print("Hyphenation points: ");
                System.out.println(hyphenationTree.hyphenate(string2, n, n));
                continue;
            }
            if (string2.equals("b")) {
                if (hyphenationTree == null) {
                    System.out.println("No patterns has been loaded.");
                    return;
                }
                System.out.print("Word list filename: ");
                string2 = bufferedReader.readLine().trim();
                long l = 0L;
                int n2 = 0;
                try {
                    BufferedReader bufferedReader2 = new BufferedReader(new FileReader(string2));
                    l = System.currentTimeMillis();
                    while ((object2 = bufferedReader2.readLine()) != null) {
                        Hyphenation hyphenation = hyphenationTree.hyphenate((String)object2, n, n);
                        if (hyphenation != null) {
                            string = hyphenation.toString();
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    System.out.println("Exception " + exception);
                    exception.printStackTrace();
                }
                long l2 = System.currentTimeMillis();
                long l3 = l2 - l;
                System.out.println(n2 + " words in " + l3 + " Millisekunden hyphenated");
                continue;
            }
            if (string2.equals("q")) return;
        }
    }
}

