/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ICC_Profile;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.SVGBrokenLinkProvider;
import org.apache.batik.bridge.SVGColorProfileElementBridge;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.color.ICCColorSpaceExt;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ImageNode;
import org.apache.batik.gvt.RasterImageNode;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGImageElementBridge
extends AbstractGraphicsNodeBridge {
    public String getLocalName() {
        return "image";
    }

    public Bridge getInstance() {
        return new SVGImageElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        Object object;
        Object object2;
        ImageNode imageNode = (ImageNode)super.createGraphicsNode(bridgeContext, element);
        if (imageNode == null) {
            return null;
        }
        String string = XLinkSupport.getXLinkHref(element);
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"xlink:href"});
        }
        if (string.indexOf(35) != -1) {
            throw new BridgeException(element, "attribute.malformed", new Object[]{"xlink:href", string});
        }
        GraphicsNode graphicsNode = null;
        SVGDocument sVGDocument = (SVGDocument)element.getOwnerDocument();
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        URIResolver uRIResolver = new URIResolver(sVGDocument, documentLoader);
        try {
            object2 = uRIResolver.getNode(string, element);
            if (object2.getNodeType() == 9) {
                object = (SVGDocument)object2;
                graphicsNode = SVGImageElementBridge.createSVGImageNode(bridgeContext, element, (SVGDocument)object);
            }
        }
        catch (BridgeException bridgeException) {
            throw bridgeException;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (graphicsNode == null) {
            object2 = XMLBaseSupport.getCascadedXMLBase(element);
            object = object2 == null ? new ParsedURL(string) : new ParsedURL((String)object2, string);
            graphicsNode = SVGImageElementBridge.createRasterImageNode(bridgeContext, element, (ParsedURL)object);
        }
        if (graphicsNode == null) {
            throw new BridgeException(element, "uri.image.invalid", new Object[]{string});
        }
        object2 = CSSUtilities.convertImageRendering(element, null);
        if ((object2 = CSSUtilities.convertColorRendering(element, (RenderingHints)object2)) != null) {
            graphicsNode.setRenderingHints((RenderingHints)object2);
        }
        imageNode.setImage(graphicsNode);
        return imageNode;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new ImageNode();
    }

    public boolean isComposite() {
        return false;
    }

    protected void initializeDynamicSupport(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        this.e = element;
        this.node = graphicsNode;
        this.ctx = bridgeContext;
        ImageNode imageNode = (ImageNode)graphicsNode;
        if (imageNode.getImage() instanceof RasterImageNode) {
            bridgeContext.bind(element, imageNode.getImage());
        } else {
            bridgeContext.bind(element, graphicsNode);
        }
        ((SVGOMElement)element).setSVGContext(this);
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        super.handleDOMAttrModifiedEvent(mutationEvent);
    }

    protected static GraphicsNode createRasterImageNode(BridgeContext bridgeContext, Element element, ParsedURL parsedURL) {
        RasterImageNode rasterImageNode = new RasterImageNode();
        ImageTagRegistry imageTagRegistry = ImageTagRegistry.getRegistry();
        Filter filter = imageTagRegistry.readURL(parsedURL, SVGImageElementBridge.extractColorSpace(element, bridgeContext));
        Object object = filter.getProperty("org.apache.batik.bridge.BrokenLinkDocument");
        if (object != null && object instanceof SVGDocument) {
            SVGOMDocument sVGOMDocument = (SVGOMDocument)object;
            bridgeContext.initializeDocument(sVGOMDocument);
            return SVGImageElementBridge.createSVGImageNode(bridgeContext, element, sVGOMDocument);
        }
        rasterImageNode.setImage(filter);
        Rectangle2D rectangle2D = filter.getBounds2D();
        rasterImageNode.setImageBounds(rectangle2D);
        Rectangle2D rectangle2D2 = SVGImageElementBridge.getImageBounds(bridgeContext, element);
        float[] fArray = new float[]{0.0f, 0.0f, (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight()};
        SVGImageElementBridge.initializeViewport(bridgeContext, element, rasterImageNode, fArray, rectangle2D2);
        return rasterImageNode;
    }

    protected static GraphicsNode createSVGImageNode(BridgeContext bridgeContext, Element element, SVGDocument sVGDocument) {
        CompositeGraphicsNode compositeGraphicsNode = new CompositeGraphicsNode();
        Rectangle2D rectangle2D = CSSUtilities.convertEnableBackground(element);
        if (rectangle2D != null) {
            compositeGraphicsNode.setBackgroundEnable(rectangle2D);
        }
        SVGSVGElement sVGSVGElement = sVGDocument.getRootElement();
        GraphicsNode graphicsNode = bridgeContext.getGVTBuilder().build(bridgeContext, sVGSVGElement);
        graphicsNode.setClip(null);
        compositeGraphicsNode.getChildren().add(graphicsNode);
        String string = sVGSVGElement.getAttributeNS(null, "viewBox");
        float[] fArray = ViewBox.parseViewBoxAttribute(element, string);
        Rectangle2D rectangle2D2 = SVGImageElementBridge.getImageBounds(bridgeContext, element);
        SVGImageElementBridge.initializeViewport(bridgeContext, element, compositeGraphicsNode, fArray, rectangle2D2);
        if (bridgeContext.isDynamic()) {
            ForwardEventListener forwardEventListener = new ForwardEventListener(sVGSVGElement, element);
            SVGSVGElement sVGSVGElement2 = sVGSVGElement;
            sVGSVGElement2.addEventListener("click", forwardEventListener, false);
            sVGSVGElement2.addEventListener("mouseover", forwardEventListener, false);
            sVGSVGElement2.addEventListener("mouseout", forwardEventListener, false);
        }
        return compositeGraphicsNode;
    }

    protected static void initializeViewport(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode, float[] fArray, Rectangle2D rectangle2D) {
        Object object;
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        AffineTransform affineTransform = ViewBox.getPreserveAspectRatioTransform(element, fArray, f3, f4);
        affineTransform.preConcatenate(AffineTransform.getTranslateInstance(f, f2));
        graphicsNode.setTransform(affineTransform);
        Shape shape = null;
        if (CSSUtilities.convertOverflow(element)) {
            object = CSSUtilities.convertClip(element);
            shape = object == null ? new Rectangle2D.Float(f, f2, f3, f4) : new Rectangle2D.Float(f + object[3], f2 + object[0], f3 - object[1] - object[3], f4 - object[2] - object[0]);
        }
        if (shape != null) {
            try {
                affineTransform = affineTransform.createInverse();
                object = graphicsNode.getGraphicsNodeRable(true);
                shape = affineTransform.createTransformedShape(shape);
                graphicsNode.setClip(new ClipRable8Bit((Filter)object, shape));
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
    }

    protected static ICCColorSpaceExt extractColorSpace(Element element, BridgeContext bridgeContext) {
        SVGColorProfileElementBridge sVGColorProfileElementBridge;
        String string = CSSUtilities.getComputedStyle(element, 8).getStringValue();
        ICCColorSpaceExt iCCColorSpaceExt = null;
        if ("srgb".equalsIgnoreCase(string)) {
            iCCColorSpaceExt = new ICCColorSpaceExt(ICC_Profile.getInstance(1000), 4);
        } else if (!"auto".equalsIgnoreCase(string) && !"".equalsIgnoreCase(string) && (sVGColorProfileElementBridge = (SVGColorProfileElementBridge)bridgeContext.getBridge("http://www.w3.org/2000/svg", "color-profile")) != null) {
            iCCColorSpaceExt = sVGColorProfileElementBridge.createICCColorSpaceExt(bridgeContext, element, string);
        }
        return iCCColorSpaceExt;
    }

    protected static Rectangle2D getImageBounds(BridgeContext bridgeContext, Element element) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        String string = element.getAttributeNS(null, "x");
        float f = 0.0f;
        if (string.length() != 0) {
            f = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "x", context);
        }
        string = element.getAttributeNS(null, "y");
        float f2 = 0.0f;
        if (string.length() != 0) {
            f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(string, "y", context);
        }
        if ((string = element.getAttributeNS(null, "width")).length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"width"});
        }
        float f3 = UnitProcessor.svgHorizontalLengthToUserSpace(string, "width", context);
        string = element.getAttributeNS(null, "height");
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"height"});
        }
        float f4 = UnitProcessor.svgVerticalLengthToUserSpace(string, "height", context);
        return new Rectangle2D.Float(f, f2, f3, f4);
    }

    static {
        ImageTagRegistry.setBrokenLinkProvider(new SVGBrokenLinkProvider());
    }

    protected static class ForwardEventListener
    implements EventListener {
        protected Element svgElement;
        protected Element imgElement;

        public ForwardEventListener(Element element, Element element2) {
            this.svgElement = element;
            this.imgElement = element2;
        }

        public void handleEvent(Event event) {
            MouseEvent mouseEvent = (MouseEvent)event;
            MouseEvent mouseEvent2 = (MouseEvent)((DocumentEvent)((Object)this.imgElement.getOwnerDocument())).createEvent("MouseEvents");
            mouseEvent2.initMouseEvent(mouseEvent.getType(), mouseEvent.getBubbles(), mouseEvent.getCancelable(), mouseEvent.getView(), mouseEvent.getDetail(), mouseEvent.getScreenX(), mouseEvent.getScreenY(), mouseEvent.getClientX(), mouseEvent.getClientY(), mouseEvent.getCtrlKey(), mouseEvent.getAltKey(), mouseEvent.getShiftKey(), mouseEvent.getMetaKey(), mouseEvent.getButton(), (EventTarget)((Object)this.imgElement));
            ((EventTarget)((Object)this.imgElement)).dispatchEvent(mouseEvent2);
        }
    }
}

