/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.PaintServer;
import org.apache.batik.bridge.SVGAElementBridge;
import org.apache.batik.bridge.SVGAltGlyphHandler;
import org.apache.batik.bridge.SVGFontUtilities;
import org.apache.batik.bridge.SVGTextPathElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class SVGTextElementBridge
extends AbstractGraphicsNodeBridge {
    protected static final Integer ZERO = new Integer(0);
    protected AttributedString layoutedText;
    protected DOMChildNodeRemovedEventListener childNodeRemovedEventListener = new DOMChildNodeRemovedEventListener();
    protected DOMSubtreeModifiedEventListener subtreeModifiedEventListener = new DOMSubtreeModifiedEventListener();
    private boolean hasNewACI;

    public String getLocalName() {
        return "text";
    }

    public Bridge getInstance() {
        return new SVGTextElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        TextNode textNode = (TextNode)super.createGraphicsNode(bridgeContext, element);
        if (textNode == null) {
            return null;
        }
        if (bridgeContext.getTextPainter() != null) {
            textNode.setTextPainter(bridgeContext.getTextPainter());
        }
        RenderingHints renderingHints = CSSUtilities.convertTextRendering(element, null);
        if ((renderingHints = CSSUtilities.convertColorRendering(element, renderingHints)) != null) {
            textNode.setRenderingHints(renderingHints);
        }
        textNode.setLocation(this.getLocation(bridgeContext, element));
        return textNode;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new TextNode();
    }

    protected Point2D getLocation(BridgeContext bridgeContext, Element element) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        String string = element.getAttributeNS(null, "x");
        float f = 0.0f;
        if (string.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
            f = UnitProcessor.svgHorizontalCoordinateToUserSpace(stringTokenizer.nextToken(), "x", context);
        }
        string = element.getAttributeNS(null, "y");
        float f2 = 0.0f;
        if (string.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
            f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(stringTokenizer.nextToken(), "y", context);
        }
        return new Point2D.Float(f, f2);
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        element.normalize();
        AttributedString attributedString = this.buildAttributedString(bridgeContext, element);
        this.addGlyphPositionAttributes(attributedString, element, bridgeContext);
        if (bridgeContext.isDynamic()) {
            this.layoutedText = new AttributedString(attributedString.getIterator());
        }
        TextNode textNode = (TextNode)graphicsNode;
        textNode.setAttributedCharacterIterator(attributedString.getIterator());
        TextDecoration textDecoration = this.getTextDecoration(element, textNode, new TextDecoration(), bridgeContext);
        this.addPaintAttributes(attributedString, element, textNode, textDecoration, bridgeContext);
        textNode.setAttributedCharacterIterator(attributedString.getIterator());
        graphicsNode.setFilter(CSSUtilities.convertFilter(element, graphicsNode, bridgeContext));
        graphicsNode.setMask(CSSUtilities.convertMask(element, graphicsNode, bridgeContext));
        graphicsNode.setClip(CSSUtilities.convertClipPath(element, graphicsNode, bridgeContext));
        graphicsNode.setPointerEventType(CSSUtilities.convertPointerEvents(element));
        if (bridgeContext.isDynamic()) {
            this.initializeDynamicSupport(bridgeContext, element, graphicsNode);
        }
        SVGUtilities.bridgeChildren(bridgeContext, element);
    }

    public boolean isComposite() {
        return false;
    }

    protected void initializeDynamicSupport(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        super.initializeDynamicSupport(bridgeContext, element, graphicsNode);
        EventTarget eventTarget = (EventTarget)((Object)element);
        eventTarget.addEventListener("DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        eventTarget.addEventListener("DOMSubtreeModified", this.subtreeModifiedEventListener, false);
    }

    public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
        Node node = (Node)((Object)mutationEvent.getTarget());
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                this.layoutedText = null;
                break;
            }
            case 1: {
                String string = node.getNodeName();
                if (!string.equals("tspan") && !string.equals("altGlyph") && !string.equals("a") && !string.equals("textPath") && !string.equals("tref")) break;
                this.layoutedText = null;
                break;
            }
        }
        if (this.layoutedText == null) {
            this.computeLayoutedText();
        }
    }

    public void handleDOMNodeRemovedEvent(MutationEvent mutationEvent) {
        EventTarget eventTarget = mutationEvent.getTarget();
        eventTarget.removeEventListener("DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        eventTarget.removeEventListener("DOMSubtreeModified", this.subtreeModifiedEventListener, false);
        super.handleDOMNodeRemovedEvent(mutationEvent);
    }

    public void handleDOMChildNodeRemovedEvent(MutationEvent mutationEvent) {
        Node node = (Node)((Object)mutationEvent.getTarget());
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                if (!this.isParentDisplayed(node)) break;
                this.layoutedText = null;
                break;
            }
            case 1: {
                String string = node.getNodeName();
                if (!string.equals("tspan") && !string.equals("altGlyph") && !string.equals("a") && !string.equals("textPath") && !string.equals("tref")) break;
                this.layoutedText = null;
                break;
            }
        }
    }

    public void handleDOMSubtreeModifiedEvent(MutationEvent mutationEvent) {
        if (this.layoutedText == null) {
            this.computeLayoutedText();
        }
    }

    public void handleDOMCharacterDataModified(MutationEvent mutationEvent) {
        Node node = (Node)((Object)mutationEvent.getTarget());
        if (this.isParentDisplayed(node)) {
            this.layoutedText = null;
        }
    }

    protected boolean isParentDisplayed(Node node) {
        String string;
        Node node2 = node.getParentNode();
        return node2.getNodeType() == 1 && ((string = node2.getNodeName()).equals("text") || string.equals("tspan") || string.equals("altGlyph") || string.equals("a") || string.equals("textPath") || string.equals("tref"));
    }

    protected void computeLayoutedText() {
        AttributedString attributedString = this.buildAttributedString(this.ctx, this.e);
        this.addGlyphPositionAttributes(attributedString, this.e, this.ctx);
        this.layoutedText = new AttributedString(attributedString.getIterator());
        TextNode textNode = (TextNode)this.node;
        textNode.setAttributedCharacterIterator(attributedString.getIterator());
        TextDecoration textDecoration = this.getTextDecoration(this.e, textNode, new TextDecoration(), this.ctx);
        this.addPaintAttributes(attributedString, this.e, textNode, textDecoration, this.ctx);
        textNode.setAttributedCharacterIterator(attributedString.getIterator());
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        String string = mutationEvent.getAttrName();
        if (string.equals("x") || string.equals("y") || string.equals("dx") || string.equals("dy") || string.equals("rotate")) {
            if (string.equals("x") || string.equals("y")) {
                ((TextNode)this.node).setLocation(this.getLocation(this.ctx, this.e));
            }
            this.computeLayoutedText();
        } else {
            super.handleDOMAttrModifiedEvent(mutationEvent);
        }
    }

    public void handleCSSEngineEvent(CSSEngineEvent cSSEngineEvent) {
        this.hasNewACI = false;
        int[] nArray = cSSEngineEvent.getProperties();
        int n = 0;
        while (n < nArray.length) {
            switch (nArray[n]) {
                case 1: 
                case 11: 
                case 21: 
                case 22: 
                case 24: 
                case 25: 
                case 27: 
                case 29: 
                case 31: 
                case 32: 
                case 52: 
                case 55: 
                case 57: 
                case 58: {
                    if (this.hasNewACI) break;
                    this.hasNewACI = true;
                    AttributedString attributedString = this.buildAttributedString(this.ctx, this.e);
                    this.addGlyphPositionAttributes(attributedString, this.e, this.ctx);
                    this.layoutedText = new AttributedString(attributedString.getIterator());
                    TextNode textNode = (TextNode)this.node;
                    textNode.setAttributedCharacterIterator(attributedString.getIterator());
                    TextDecoration textDecoration = this.getTextDecoration(this.e, textNode, new TextDecoration(), this.ctx);
                    this.addPaintAttributes(attributedString, this.e, textNode, textDecoration, this.ctx);
                    textNode.setAttributedCharacterIterator(attributedString.getIterator());
                }
            }
            ++n;
        }
        super.handleCSSEngineEvent(cSSEngineEvent);
    }

    protected void handleCSSPropertyChanged(int n) {
        switch (n) {
            case 15: 
            case 16: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: {
                if (this.hasNewACI) break;
                this.hasNewACI = true;
                AttributedString attributedString = new AttributedString(this.layoutedText.getIterator());
                TextNode textNode = (TextNode)this.node;
                textNode.setAttributedCharacterIterator(attributedString.getIterator());
                TextDecoration textDecoration = this.getTextDecoration(this.e, textNode, new TextDecoration(), this.ctx);
                this.addPaintAttributes(attributedString, this.e, textNode, textDecoration, this.ctx);
                textNode.setAttributedCharacterIterator(attributedString.getIterator());
                break;
            }
            case 54: {
                RenderingHints renderingHints = this.node.getRenderingHints();
                renderingHints = CSSUtilities.convertTextRendering(this.e, renderingHints);
                if (renderingHints == null) break;
                this.node.setRenderingHints(renderingHints);
                break;
            }
            case 9: {
                RenderingHints renderingHints = this.node.getRenderingHints();
                renderingHints = CSSUtilities.convertColorRendering(this.e, renderingHints);
                if (renderingHints == null) break;
                this.node.setRenderingHints(renderingHints);
                break;
            }
            default: {
                super.handleCSSPropertyChanged(n);
            }
        }
    }

    protected AttributedString buildAttributedString(BridgeContext bridgeContext, Element element) {
        AttributedStringBuffer attributedStringBuffer = new AttributedStringBuffer();
        this.fillAttributedStringBuffer(bridgeContext, element, true, null, attributedStringBuffer);
        return attributedStringBuffer.toAttributedString();
    }

    protected void fillAttributedStringBuffer(BridgeContext bridgeContext, Element element, boolean bl, TextPath textPath, AttributedStringBuffer attributedStringBuffer) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return;
        }
        String string = XMLSupport.getXMLSpace(element);
        boolean bl2 = string.equals("preserve");
        boolean bl3 = true;
        boolean bl4 = !bl2;
        boolean bl5 = !bl2;
        Element element2 = element;
        Map map = null;
        Node node = element.getFirstChild();
        while (node != null) {
            boolean bl6 = node.getNextSibling() == null;
            int n = attributedStringBuffer.getLastChar();
            bl4 = !bl2 && bl3 && (bl || n == 32 || n == -1);
            switch (node.getNodeType()) {
                case 1: {
                    Object object;
                    Object object2;
                    if (node.getNamespaceURI() != "http://www.w3.org/2000/svg") break;
                    element2 = (Element)node;
                    String string2 = node.getLocalName();
                    if (string2.equals("tspan") || string2.equals("altGlyph")) {
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, textPath, attributedStringBuffer);
                        break;
                    }
                    if (string2.equals("textPath")) {
                        object2 = (SVGTextPathElementBridge)bridgeContext.getBridge(element2);
                        object = ((SVGTextPathElementBridge)object2).createTextPath(bridgeContext, element2);
                        if (object == null) break;
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, (TextPath)object, attributedStringBuffer);
                        break;
                    }
                    if (string2.equals("tref")) {
                        object2 = XLinkSupport.getXLinkHref((Element)node);
                        object = bridgeContext.getReferencedElement((Element)node, (String)object2);
                        string = TextUtilities.getElementContent((Element)object);
                        if ((string = this.normalizeString(string, bl2, bl4, bl6 && bl)) == null) break;
                        boolean bl7 = bl5 = !bl2 && string.charAt(0) == ' ';
                        if (bl5 && !attributedStringBuffer.isEmpty()) {
                            attributedStringBuffer.stripLast();
                        }
                        Map map2 = this.getAttributeMap(bridgeContext, element2, textPath);
                        attributedStringBuffer.append(string, map2);
                        break;
                    }
                    if (!string2.equals("a")) break;
                    object2 = (EventTarget)((Object)element2);
                    object = bridgeContext.getUserAgent();
                    object2.addEventListener("click", new SVGAElementBridge.AnchorListener((UserAgent)object), false);
                    object2.addEventListener("mouseover", new SVGAElementBridge.CursorMouseOverListener((UserAgent)object), false);
                    object2.addEventListener("mouseout", new SVGAElementBridge.CursorMouseOutListener((UserAgent)object), false);
                    this.fillAttributedStringBuffer(bridgeContext, element2, false, textPath, attributedStringBuffer);
                    break;
                }
                case 3: 
                case 4: {
                    string = node.getNodeValue();
                    string = this.normalizeString(string, bl2, bl4, bl6 && bl);
                    if (string == null) break;
                    boolean bl8 = bl5 = !bl2 && string.charAt(0) == ' ';
                    if (bl5 && !attributedStringBuffer.isEmpty()) {
                        attributedStringBuffer.stripLast();
                    }
                    if (map == null) {
                        map = this.getAttributeMap(bridgeContext, element, textPath);
                    }
                    attributedStringBuffer.append(string, map);
                }
            }
            bl3 = false;
            node = node.getNextSibling();
        }
    }

    protected String normalizeString(String string, boolean bl, boolean bl2, boolean bl3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        stringBuffer.append(' ');
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                ++n;
            }
        } else {
            char c;
            boolean bl4 = false;
            int n = 0;
            if (bl2) {
                block11: while (n < string.length()) {
                    switch (string.charAt(n)) {
                        default: {
                            break block11;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            ++n;
                        }
                    }
                }
            }
            int n2 = n;
            while (n2 < string.length()) {
                c = string.charAt(n2);
                switch (c) {
                    case '\n': 
                    case '\r': {
                        break;
                    }
                    case '\t': 
                    case ' ': {
                        if (bl4) break;
                        stringBuffer.append(' ');
                        bl4 = true;
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                        bl4 = false;
                    }
                }
                ++n2;
            }
            if (bl3) {
                while ((c = stringBuffer.length()) > '\u0000') {
                    if (stringBuffer.charAt(c - '\u0001') == ' ') {
                        stringBuffer.deleteCharAt(c - '\u0001');
                        continue;
                    }
                    break;
                }
            }
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        if (bl2 && bl3) {
            return " ";
        }
        return null;
    }

    protected boolean nodeAncestorOf(Node node, Node node2) {
        if (node2 == null || node == null) {
            return false;
        }
        Node node3 = node2.getParentNode();
        while (node3 != null && node3 != node) {
            node3 = node3.getParentNode();
        }
        return node3 == node;
    }

    protected void addGlyphPositionAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        int n;
        int n2;
        Object object;
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return;
        }
        String string = element.getAttributeNS(null, "x");
        String string2 = element.getAttributeNS(null, "y");
        String string3 = element.getAttributeNS(null, "dx");
        String string4 = element.getAttributeNS(null, "dy");
        String string5 = element.getAttributeNS(null, "rotate");
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        int n3 = 0;
        int n4 = 0;
        while (n4 < attributedCharacterIterator.getEndIndex()) {
            attributedCharacterIterator.setIndex(n4);
            Element element2 = (Element)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (element2 == element || this.nodeAncestorOf(element, element2)) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        int n5 = attributedCharacterIterator.getEndIndex() - 1;
        int n6 = attributedCharacterIterator.getEndIndex() - 1;
        while (n6 >= 0) {
            attributedCharacterIterator.setIndex(n6);
            object = (Element)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (object == element || this.nodeAncestorOf(element, (Node)object)) {
                n5 = n6;
                break;
            }
            --n6;
        }
        if (string.length() != 0) {
            object = TextUtilities.svgHorizontalCoordinateArrayToUserSpace(element, "x", string, bridgeContext);
            n2 = ((ArrayList)object).size();
            n = 0;
            while (n < n2) {
                if (n3 + n <= n5) {
                    attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.X, ((ArrayList)object).get(n), n3 + n, n3 + n + 1);
                }
                ++n;
            }
        }
        if (string2.length() != 0) {
            object = TextUtilities.svgVerticalCoordinateArrayToUserSpace(element, "y", string2, bridgeContext);
            n2 = ((ArrayList)object).size();
            n = 0;
            while (n < n2) {
                if (n3 + n <= n5) {
                    attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.Y, ((ArrayList)object).get(n), n3 + n, n3 + n + 1);
                }
                ++n;
            }
        }
        if (string3.length() != 0) {
            object = TextUtilities.svgHorizontalCoordinateArrayToUserSpace(element, "dx", string3, bridgeContext);
            n2 = ((ArrayList)object).size();
            n = 0;
            while (n < n2) {
                if (n3 + n <= n5) {
                    attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.DX, ((ArrayList)object).get(n), n3 + n, n3 + n + 1);
                }
                ++n;
            }
        }
        if (string4.length() != 0) {
            object = TextUtilities.svgVerticalCoordinateArrayToUserSpace(element, "dy", string4, bridgeContext);
            n2 = ((ArrayList)object).size();
            n = 0;
            while (n < n2) {
                if (n3 + n <= n5) {
                    attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.DY, ((ArrayList)object).get(n), n3 + n, n3 + n + 1);
                }
                ++n;
            }
        }
        if (string5.length() != 0) {
            object = TextUtilities.svgRotateArrayToFloats(element, "rotate", string5, bridgeContext);
            n2 = ((ArrayList)object).size();
            if (n2 == 1) {
                attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.ROTATION, ((ArrayList)object).get(0), n3, n5 + 1);
            } else {
                n = 0;
                while (n < n2) {
                    if (n3 + n <= n5) {
                        attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.ROTATION, ((ArrayList)object).get(n), n3 + n, n3 + n + 1);
                    }
                    ++n;
                }
            }
        }
        this.addChildGlyphPositionAttributes(attributedString, element, bridgeContext);
    }

    protected void addChildGlyphPositionAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        Node node = element.getFirstChild();
        while (node != null) {
            String string;
            if (node.getNodeType() == 1 && "http://www.w3.org/2000/svg".equals(node.getNamespaceURI()) && ((string = node.getLocalName()).equals("tspan") || string.equals("altGlyph") || string.equals("a") || string.equals("textPath") || string.equals("tref"))) {
                this.addGlyphPositionAttributes(attributedString, (Element)node, bridgeContext);
            }
            node = node.getNextSibling();
        }
    }

    protected void addPaintAttributes(AttributedString attributedString, Element element, TextNode textNode, TextDecoration textDecoration, BridgeContext bridgeContext) {
        Object object;
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return;
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        int n = -1;
        int n2 = 0;
        while (n2 < attributedCharacterIterator.getEndIndex()) {
            attributedCharacterIterator.setIndex(n2);
            Element element2 = (Element)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (element2 == element || this.nodeAncestorOf(element, element2)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        int n3 = attributedCharacterIterator.getEndIndex() - 1;
        int n4 = attributedCharacterIterator.getEndIndex() - 1;
        while (n4 >= 0) {
            attributedCharacterIterator.setIndex(n4);
            object = (Element)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (object == element || this.nodeAncestorOf(element, (Node)object)) {
                n3 = n4;
                break;
            }
            --n4;
        }
        object = CSSUtilities.convertOpacity(element);
        attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.OPACITY, object, n, n3 + 1);
        Paint paint = PaintServer.convertFillPaint(element, textNode, bridgeContext);
        attributedString.addAttribute(TextAttribute.FOREGROUND, paint, n, n3 + 1);
        Paint paint2 = PaintServer.convertStrokePaint(element, textNode, bridgeContext);
        attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE_PAINT, paint2, n, n3 + 1);
        Stroke stroke = PaintServer.convertStroke(element);
        attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE, stroke, n, n3 + 1);
        if (textDecoration != null) {
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT, textDecoration.underlinePaint, n, n3 + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT, textDecoration.underlineStrokePaint, n, n3 + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE, textDecoration.underlineStroke, n, n3 + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT, textDecoration.overlinePaint, n, n3 + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT, textDecoration.overlineStrokePaint, n, n3 + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE, textDecoration.overlineStroke, n, n3 + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT, textDecoration.strikethroughPaint, n, n3 + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT, textDecoration.strikethroughStrokePaint, n, n3 + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE, textDecoration.strikethroughStroke, n, n3 + 1);
        }
        this.addChildPaintAttributes(attributedString, element, textNode, textDecoration, bridgeContext);
    }

    protected void addChildPaintAttributes(AttributedString attributedString, Element element, TextNode textNode, TextDecoration textDecoration, BridgeContext bridgeContext) {
        Node node = element.getFirstChild();
        while (node != null) {
            String string;
            if (node.getNodeType() == 1 && "http://www.w3.org/2000/svg".equals(node.getNamespaceURI()) && ((string = node.getLocalName()).equals("tspan") || string.equals("altGlyph") || string.equals("a") || string.equals("textPath") || string.equals("tref"))) {
                Element element2 = (Element)node;
                TextDecoration textDecoration2 = this.getTextDecoration(element2, textNode, textDecoration, bridgeContext);
                this.addPaintAttributes(attributedString, element2, textNode, textDecoration2, bridgeContext);
            }
            node = node.getNextSibling();
        }
    }

    protected Map getAttributeMap(BridgeContext bridgeContext, Element element, TextPath textPath) {
        String string;
        Object object;
        Object object2;
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        HashMap<AttributedCharacterIterator.Attribute, Object> hashMap = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        boolean bl = false;
        hashMap.put(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER, element);
        if (element.getTagName().equals("altGlyph")) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER, new SVGAltGlyphHandler(bridgeContext, element));
        }
        if (textPath != null) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.TEXTPATH, textPath);
        }
        TextNode.Anchor anchor = TextUtilities.convertTextAnchor(element);
        hashMap.put(GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE, anchor);
        Float f = TextUtilities.convertFontSize(element);
        hashMap.put(TextAttribute.SIZE, f);
        Float f2 = TextUtilities.convertFontWeight(element);
        Value value = CSSUtilities.getComputedStyle(element, 27);
        String string2 = value.getCssText();
        hashMap.put(TextAttribute.WEIGHT, f2);
        String string3 = CSSUtilities.getComputedStyle(element, 25).getStringValue();
        hashMap.put(TextAttribute.POSTURE, TextUtilities.convertFontStyle(element));
        String string4 = CSSUtilities.getComputedStyle(element, 24).getStringValue();
        hashMap.put(TextAttribute.WIDTH, TextUtilities.convertFontStretch(element));
        Value value2 = CSSUtilities.getComputedStyle(element, 21);
        Vector<GVTFontFamily> vector = new Vector<GVTFontFamily>();
        int n = value2.getLength();
        int n2 = 0;
        while (n2 < n) {
            object2 = value2.item(n2);
            object = object2.getStringValue();
            GVTFontFamily gVTFontFamily = SVGFontUtilities.getFontFamily(element, bridgeContext, (String)object, string2, string3);
            vector.add(gVTFontFamily);
            ++n2;
        }
        hashMap.put(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES, vector);
        object2 = TextUtilities.convertBaselineShift(element);
        if (object2 != null) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT, object2);
        }
        if ((string = (value2 = CSSUtilities.getComputedStyle(element, 55)).getStringValue()).charAt(0) == 'n') {
            hashMap.put(TextAttribute.BIDI_EMBEDDING, ZERO);
        } else {
            value2 = CSSUtilities.getComputedStyle(element, 11);
            object = value2.getStringValue();
            block0 : switch (((String)object).charAt(0)) {
                case 'l': {
                    hashMap.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                    switch (string.charAt(0)) {
                        case 'b': {
                            hashMap.put(TextAttribute.BIDI_EMBEDDING, new Integer(-2));
                            break;
                        }
                        case 'e': {
                            hashMap.put(TextAttribute.BIDI_EMBEDDING, new Integer(2));
                        }
                    }
                    break;
                }
                case 'r': {
                    hashMap.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                    switch (string.charAt(0)) {
                        case 'b': {
                            hashMap.put(TextAttribute.BIDI_EMBEDDING, new Integer(-1));
                            break block0;
                        }
                        case 'e': {
                            hashMap.put(TextAttribute.BIDI_EMBEDDING, new Integer(1));
                        }
                    }
                }
            }
        }
        value2 = CSSUtilities.getComputedStyle(element, 58);
        string = value2.getStringValue();
        switch (string.charAt(0)) {
            case 'l': {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_LTR);
                break;
            }
            case 'r': {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_RTL);
                break;
            }
            case 't': {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB);
            }
        }
        value2 = CSSUtilities.getComputedStyle(element, 29);
        switch (value2.getPrimitiveType()) {
            case 21: {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_AUTO);
                break;
            }
            case 11: {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, new Float(value2.getFloatValue()));
                break;
            }
            case 12: {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, new Float((double)(value2.getFloatValue() * 180.0f) / Math.PI));
                break;
            }
            case 13: {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, new Float(value2.getFloatValue() * 9.0f / 5.0f));
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        object = TextUtilities.convertLetterSpacing(element);
        if (object != null) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING, object);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((object = TextUtilities.convertWordSpacing(element)) != null) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING, object);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((object = TextUtilities.convertKerning(element)) != null) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.KERNING, object);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((string = element.getAttributeNS(null, "textLength")).length() != 0) {
            float f3 = UnitProcessor.svgOtherLengthToUserSpace(string, "textLength", context);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH, new Float(f3));
            string = element.getAttributeNS(null, "lengthAdjust");
            if (string.length() < 10) {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING);
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
            } else {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL);
            }
        }
        return hashMap;
    }

    protected TextDecoration getTextDecoration(Element element, GraphicsNode graphicsNode, TextDecoration textDecoration, BridgeContext bridgeContext) {
        int n = 53;
        Value value = CSSUtilities.getComputedStyle(element, n);
        StyleMap styleMap = ((CSSStylableElement)element).getComputedStyleMap(null);
        if (styleMap.isNullCascaded(n)) {
            return textDecoration;
        }
        TextDecoration textDecoration2 = new TextDecoration(textDecoration);
        short s = value.getCssValueType();
        switch (value.getCssValueType()) {
            case 2: {
                ListValue listValue = (ListValue)value;
                Paint paint = PaintServer.convertFillPaint(element, graphicsNode, bridgeContext);
                Paint paint2 = PaintServer.convertStrokePaint(element, graphicsNode, bridgeContext);
                Stroke stroke = PaintServer.convertStroke(element);
                int n2 = listValue.getLength();
                int n3 = 0;
                while (n3 < n2) {
                    Value value2 = listValue.item(n3);
                    String string = value2.getStringValue();
                    switch (string.charAt(0)) {
                        case 'u': {
                            if (paint != null) {
                                textDecoration2.underlinePaint = paint;
                            }
                            if (paint2 != null) {
                                textDecoration2.underlineStrokePaint = paint2;
                            }
                            if (stroke == null) break;
                            textDecoration2.underlineStroke = stroke;
                            break;
                        }
                        case 'o': {
                            if (paint != null) {
                                textDecoration2.overlinePaint = paint;
                            }
                            if (paint2 != null) {
                                textDecoration2.overlineStrokePaint = paint2;
                            }
                            if (stroke == null) break;
                            textDecoration2.overlineStroke = stroke;
                            break;
                        }
                        case 'l': {
                            if (paint != null) {
                                textDecoration2.strikethroughPaint = paint;
                            }
                            if (paint2 != null) {
                                textDecoration2.strikethroughStrokePaint = paint2;
                            }
                            if (stroke == null) break;
                            textDecoration2.strikethroughStroke = stroke;
                        }
                    }
                    ++n3;
                }
                return textDecoration2;
            }
        }
        return TextDecoration.EMPTY_TEXT_DECORATION;
    }

    protected static class TextDecoration {
        static final TextDecoration EMPTY_TEXT_DECORATION = new TextDecoration();
        Paint underlinePaint;
        Paint underlineStrokePaint;
        Stroke underlineStroke;
        Paint overlinePaint;
        Paint overlineStrokePaint;
        Stroke overlineStroke;
        Paint strikethroughPaint;
        Paint strikethroughStrokePaint;
        Stroke strikethroughStroke;

        TextDecoration() {
            this.underlinePaint = null;
            this.underlineStrokePaint = null;
            this.underlineStroke = null;
            this.overlinePaint = null;
            this.overlineStrokePaint = null;
            this.overlineStroke = null;
            this.strikethroughPaint = null;
            this.strikethroughStrokePaint = null;
            this.strikethroughStroke = null;
        }

        TextDecoration(TextDecoration textDecoration) {
            this.underlinePaint = textDecoration.underlinePaint;
            this.underlineStrokePaint = textDecoration.underlineStrokePaint;
            this.underlineStroke = textDecoration.underlineStroke;
            this.overlinePaint = textDecoration.overlinePaint;
            this.overlineStrokePaint = textDecoration.overlineStrokePaint;
            this.overlineStroke = textDecoration.overlineStroke;
            this.strikethroughPaint = textDecoration.strikethroughPaint;
            this.strikethroughStrokePaint = textDecoration.strikethroughStrokePaint;
            this.strikethroughStroke = textDecoration.strikethroughStroke;
        }
    }

    protected static class AttributedStringBuffer {
        protected List strings = new ArrayList();
        protected List attributes = new ArrayList();
        protected int count = 0;
        protected int length = 0;

        public boolean isEmpty() {
            return this.count == 0;
        }

        public int length() {
            return this.length;
        }

        public void append(String string, Map map) {
            this.strings.add(string);
            this.attributes.add(map);
            ++this.count;
            this.length += string.length();
        }

        public int getLastChar() {
            if (this.count == 0) {
                return -1;
            }
            String string = (String)this.strings.get(this.count - 1);
            return string.charAt(string.length() - 1);
        }

        public void stripLast() {
            String string = (String)this.strings.remove(this.count - 1);
            if (string.charAt(string.length() - 1) == ' ') {
                if (string.length() == 1) {
                    this.attributes.remove(--this.count);
                    return;
                }
                this.strings.add(string.substring(0, string.length() - 1));
                --this.length;
            } else {
                this.strings.add(string);
            }
        }

        public AttributedString toAttributedString() {
            switch (this.count) {
                case 0: {
                    return new AttributedString(" ");
                }
                case 1: {
                    return new AttributedString((String)this.strings.get(0), (Map)this.attributes.get(0));
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.strings.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
            }
            AttributedString attributedString = new AttributedString(stringBuffer.toString());
            Iterator iterator2 = this.strings.iterator();
            Iterator iterator3 = this.attributes.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                int n2 = n + string.length();
                Map map = (Map)iterator3.next();
                Iterator iterator4 = map.keySet().iterator();
                Iterator iterator5 = map.values().iterator();
                while (iterator4.hasNext()) {
                    AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)iterator4.next();
                    Object v = iterator5.next();
                    attributedString.addAttribute(attribute, v, n, n2);
                }
                n = n2;
            }
            return attributedString;
        }

        public String toString() {
            switch (this.count) {
                case 0: {
                    return "";
                }
                case 1: {
                    return (String)this.strings.get(0);
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.strings.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
            }
            return stringBuffer.toString();
        }
    }

    protected class DOMSubtreeModifiedEventListener
    implements EventListener {
        protected DOMSubtreeModifiedEventListener() {
        }

        public void handleEvent(Event event) {
            SVGTextElementBridge.this.handleDOMSubtreeModifiedEvent((MutationEvent)event);
        }
    }

    protected class DOMChildNodeRemovedEventListener
    implements EventListener {
        protected DOMChildNodeRemovedEventListener() {
        }

        public void handleEvent(Event event) {
            SVGTextElementBridge.this.handleDOMChildNodeRemovedEvent((MutationEvent)event);
        }
    }
}

