/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.AbstractValueManager;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.Messages;
import org.apache.batik.css.engine.value.RectValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public abstract class RectManager
extends AbstractValueManager {
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 41: {
                if (!lexicalUnit.getFunctionName().equalsIgnoreCase("rect")) break;
            }
            case 38: {
                lexicalUnit = lexicalUnit.getParameters();
                Value value = this.createRectComponent(lexicalUnit);
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
                if (lexicalUnit == null || lexicalUnit.getLexicalUnitType() != 0) {
                    throw this.createMalformedRectDOMException();
                }
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
                Value value2 = this.createRectComponent(lexicalUnit);
                if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null || lexicalUnit.getLexicalUnitType() != 0) {
                    throw this.createMalformedRectDOMException();
                }
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
                Value value3 = this.createRectComponent(lexicalUnit);
                if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null || lexicalUnit.getLexicalUnitType() != 0) {
                    throw this.createMalformedRectDOMException();
                }
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
                Value value4 = this.createRectComponent(lexicalUnit);
                return new RectValue(value, value2, value3, value4);
            }
        }
        throw this.createMalformedRectDOMException();
    }

    private Value createRectComponent(LexicalUnit lexicalUnit) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 35: {
                if (!lexicalUnit.getStringValue().equalsIgnoreCase("auto")) break;
                return ValueConstants.AUTO_VALUE;
            }
            case 15: {
                return new FloatValue(3, lexicalUnit.getFloatValue());
            }
            case 16: {
                return new FloatValue(4, lexicalUnit.getFloatValue());
            }
            case 17: {
                return new FloatValue(5, lexicalUnit.getFloatValue());
            }
            case 19: {
                return new FloatValue(6, lexicalUnit.getFloatValue());
            }
            case 20: {
                return new FloatValue(7, lexicalUnit.getFloatValue());
            }
            case 18: {
                return new FloatValue(8, lexicalUnit.getFloatValue());
            }
            case 21: {
                return new FloatValue(9, lexicalUnit.getFloatValue());
            }
            case 22: {
                return new FloatValue(10, lexicalUnit.getFloatValue());
            }
            case 13: {
                return new FloatValue(1, lexicalUnit.getIntegerValue());
            }
            case 14: {
                return new FloatValue(1, lexicalUnit.getFloatValue());
            }
            case 23: {
                return new FloatValue(2, lexicalUnit.getFloatValue());
            }
        }
        throw this.createMalformedRectDOMException();
    }

    private DOMException createMalformedRectDOMException() {
        Object[] objectArray = new Object[]{this.getPropertyName()};
        String string = Messages.formatMessage("malformed.rect", objectArray);
        return new DOMException(12, string);
    }
}

