/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import org.w3c.dom.Element;

public class DocumentDescriptor {
    protected static final int INITIAL_CAPACITY = 101;
    protected Entry[] table = new Entry[101];
    protected int count;

    public int getNumberOfElements() {
        return this.count;
    }

    public int getLocationLine(Element element) {
        int n = element.hashCode() & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && entry.element.equals(element)) {
                return entry.locationLine;
            }
            entry = entry.next;
        }
        return 0;
    }

    public void setLocationLine(Element element, int n) {
        Entry entry;
        int n2 = element.hashCode() & Integer.MAX_VALUE;
        int n3 = n2 % this.table.length;
        Entry entry2 = this.table[n3];
        while (entry2 != null) {
            if (entry2.hash == n2 && entry2.element.equals(element)) {
                entry2.locationLine = n;
            }
            entry2 = entry2.next;
        }
        int n4 = this.table.length;
        if (this.count++ >= n4 * 3 >>> 2) {
            this.rehash();
            n3 = n2 % this.table.length;
        }
        this.table[n3] = entry = new Entry(n2, element, n, this.table[n3]);
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2 + 1];
        int n = entryArray.length - 1;
        while (n >= 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n2 = entry2.hash % this.table.length;
                entry2.next = this.table[n2];
                this.table[n2] = entry2;
            }
            --n;
        }
    }

    protected static class Entry {
        public int hash;
        public Element element;
        public int locationLine;
        public Entry next;

        public Entry(int n, Element element, int n2, Entry entry) {
            this.hash = n;
            this.element = element;
            this.locationLine = n2;
            this.next = entry;
        }
    }
}

