/*
 * Decompiled with CFR 0.152.
 */
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class TextAnalyser {
    ExpressionTypeChooserToolBar expressionTypeChooserToolBar;

    public TextAnalyser(ExpressionTypeChooserToolBar expressionTypeChooserToolBar) {
        this.expressionTypeChooserToolBar = expressionTypeChooserToolBar;
    }

    public String analyse(String rawText) {
        if (this.expressionTypeChooserToolBar.getSelectedName().equals("joker")) {
            return this.jokerToRegexp(rawText);
        }
        if (this.expressionTypeChooserToolBar.getSelectedName().equals("regexp")) {
            return this.regexpToRegexp(rawText);
        }
        if (this.expressionTypeChooserToolBar.getSelectedName().equals("combo")) {
            return this.comboToRegexp(rawText);
        }
        return null;
    }

    String jokerToRegexp(String text) {
        int e;
        int v = 0;
        for (e = 0; e < text.length() && (text.charAt(e) == ' ' || text.charAt(e) == '+'); ++e) {
        }
        for (v = text.length() - 1; v >= 0 && (text.charAt(v) == ' ' || text.charAt(v) == '+'); --v) {
        }
        if (v - e < 0) {
            return null;
        }
        text = text.substring(e, v + 1);
        int n = 0;
        String generatedText = " -?\\(?";
        if (text.charAt(0) == '*') {
            RE regexp = null;
            try {
                regexp = new RE("[^\\*]+[\\*]+[^\\*]+");
            }
            catch (RESyntaxException rESyntaxException) {
                // empty catch block
            }
            if (!regexp.match(text)) {
                generatedText = "-?\\(?";
                while (n < text.length() && text.charAt(n) == '*') {
                    ++n;
                }
            }
        }
        while (n < text.length()) {
            char c = text.charAt(n);
            if (c != ' ' || n <= 0 || text.charAt(n - 1) != ' ') {
                switch (c) {
                    case '?': {
                        generatedText = String.valueOf(String.valueOf(generatedText)).concat("[:alpha:]");
                        break;
                    }
                    case '*': {
                        generatedText = String.valueOf(String.valueOf(generatedText)).concat("[^\\s]*");
                        break;
                    }
                    case '.': {
                        generatedText = String.valueOf(String.valueOf(generatedText)).concat("[\\.]");
                        break;
                    }
                    case '(': {
                        generatedText = String.valueOf(String.valueOf(generatedText)).concat("[\\(]");
                        break;
                    }
                    case ')': {
                        generatedText = String.valueOf(String.valueOf(generatedText)).concat("[\\)]");
                        break;
                    }
                    case '+': {
                        if (n == 0) break;
                        if (n > 0 && text.charAt(n - 1) == ' ') {
                            generatedText = generatedText.substring(0, generatedText.length() - 1);
                        }
                        generatedText = String.valueOf(String.valueOf(generatedText)).concat("([\\.\\?\\-,!])?(( )|( .* ))");
                        if (n >= text.length() - 2 || text.charAt(n + 1) != ' ') break;
                        ++n;
                        while (n < text.length() - 2 && text.charAt(n) == ' ') {
                            ++n;
                        }
                        --n;
                        break;
                    }
                    default: {
                        generatedText = String.valueOf(String.valueOf(generatedText)).concat(String.valueOf(String.valueOf(c)));
                    }
                }
            }
            ++n;
        }
        generatedText = String.valueOf(String.valueOf(generatedText)).concat("([\\.\\?\\-,!])?\\)? ");
        System.out.println("Text analyser: Generated regular expression:".concat(String.valueOf(String.valueOf(generatedText))));
        return this.regexpToRegexp(generatedText);
    }

    String regexpToRegexp(String text) {
        try {
            RE rE = new RE(text);
        }
        catch (RESyntaxException ex) {
            String string = null;
            return string;
        }
        return text;
    }

    String comboToRegexp(String text) {
        if (this.expressionTypeChooserToolBar.comboExpressionComboBox.getSelectedItem().equals(Resources.getString("Complete"))) {
            return this.jokerToRegexp(text);
        }
        if (this.expressionTypeChooserToolBar.comboExpressionComboBox.getSelectedItem().equals(Resources.getString("Front"))) {
            return this.jokerToRegexp(String.valueOf(String.valueOf(text)).concat("*"));
        }
        if (this.expressionTypeChooserToolBar.comboExpressionComboBox.getSelectedItem().equals(Resources.getString("End"))) {
            return this.jokerToRegexp("*".concat(String.valueOf(String.valueOf(text))));
        }
        if (this.expressionTypeChooserToolBar.comboExpressionComboBox.getSelectedItem().equals(Resources.getString("Middle"))) {
            return this.jokerToRegexp(String.valueOf(String.valueOf(new StringBuffer("*").append(text).append("*"))));
        }
        return null;
    }
}

