GRAP(1)                 FreeBSD General Commands Manual                GRAP(1)

NNAAMMEE
     ggrraapp - Kernighan and Bentley's language for typesetting graphs

SSYYNNOOPPSSIISS
     ggrraapp [--dd _d_e_f_i_n_e_s___f_i_l_e] [--DD] [--MM _i_n_c_l_u_d_e _p_a_t_h] [--vv] [--uu] [--CC] [--cc] [--hh]
          [_f_i_l_e_n_a_m_e _._._.]

DDEESSCCRRIIPPTTIIOONN
     ggrraapp is an implementation of Kernighan and Bentley's language for type-
     setting graphs, as described in ``Grap-A Language for Typesetting Graphs,
     Tutorial and User Manual,'' by Jon L. Bentley and Brian W.  Kernighan,
     revised May 1991, which is the primary source for information on how to
     use ggrraapp.  As of this writing, it is available electronically at
     http://www.kohala.com/start/troff/cstr114.ps

     This version is a black box implementation of ggrraapp, and some inconsisten-
     cies are to be expected.  The remainder of this manual page will briefly
     outline the ggrraapp language as implemented here.

     ggrraapp is a pic(1) pre-processor.  It takes commands embedded in a troff(1)
     source file which are surrounded by ..GG11 and ..GG22 macros, and rewrites them
     into pic commands to display the graph.  Other lines are copied.  Output
     is always to the standard output, which is usually redirected.  Input is
     from the given _f_i_l_e_n_a_m_es, which are read in order.  A _f_i_l_e_n_a_m_e of -- is
     the standard input.  If no _f_i_l_e_n_a_m_es are given, input is read from the
     standard input.

     Because ggrraapp is a pic preprocessor, and gnu pic will output TeX, it is
     possible to use ggrraapp with TeX.

     The --dd option specifies a file of macro definitions to be read at
     startup, and defaults to /usr/local/share/grap/grap.defines.  The --DD
     option inhibits the reading of any initial macros file.  The defines file
     can also be given using the GRAP_DEFINES environment variable. (See
     below).

     --vv prints the version information on the standard output and exits.
     ----vveerrssiioonn is a synonym for --vv.

     --uu makes labels unaligned by default.  This version of ggrraapp uses new fea-
     tures of GNU pic to align the left and right labels with the axes, that
     is that the left and right labels run at right angles to the text of the
     paper.  This may be useful in porting old ggrraapp programs.  --cc makes plot
     strings unclipped by default.  Some versions of ggrraapp allow users to place
     a string anywhere in the coordinate space, rather than only in the frame.
     By default this version of ggrraapp does not plot any string centered outside
     the frame.  --cc allows strings to be placed anywhere.  See also the
     cclliippppeedd and uunncclliippppeedd string modifiers described in the pplloott statement.

     --MM is followed by a colon-separated list of directories used to search
     for relative pathnames included via ccooppyy.  The path is also used to
     locate the defines file, so if the --dd changes the defines file name to a
     relative name, it will be searched for in the path given by --MM.  The
     search path always includes the current directory, and by default that
     directory is searched last.

     All ggrraapp commands are included between ..GG11 and ..GG22 macros, which are con-
     sumed by ggrraapp.  The output contains pic between ..PPSS and ..PPEE macros.  Any
     arguments to the ..GG11 macro in the input are arguments to the ..PPSS macro in
     the output, so graphs can be scaled just like pic diagrams.  If --CC is
     given, any macro beginning with .G1 or .G2 is treated as a .G1 or .G2
     macro, for compatibility with old versions of troff.  Using --CC also
     forces pure troff syntax on embedded font change commands when strings
     have the ssiizzee attribute, and all strings to be uunncclliippppeedd.

     The --hh flag prints a brief help message and exist.  ----hheellpp is a synonym
     for --hh.

     It is possible for someone to cause ggrraapp to fail by passing a bad format
     string and data to the sspprriinnttff command.  If ggrraapp is integrated as part of
     the printing system, this could conceivably provided a path to breaching
     security on the machine.  If you choose to use ggrraapp as part of a printing
     system run by the super-user, you should disable sspprriinnttff commands.  This
     can be done by calling ggrraapp with the --SS flag, setting the GRAP_SAFER
     environment variable, or compiling with the GRAP_SAFER preprocessor sym-
     bol defined.  (The GNU configure script included with ggrraapp will define
     that preprocessor symbol if the ----wwiitthh--ggrraapp--ssaaffee option is given.)

     The ggrraapp commands are sketched below.  Refer to Kernighan and Bentley's
     paper for the details.

     New versions of groff(1) will invoke ggrraapp if --GG is given.

   CCoommmmaannddss
     Commands are separated from one another by newlines or semicolons (;).

     ffrraammee [_l_i_n_e___d_e_s_c_r_i_p_t_i_o_n] [hhtt _h_e_i_g_h_t | wwiidd _w_i_d_t_h] [[(ttoopp|bboottttoomm|lleefftt|
     rriigghhtt) _l_i_n_e___d_e_s_c_r_i_p_t_i_o_n] ...]

     ffrraammee [hhtt _h_e_i_g_h_t | wwiidd _w_i_d_t_h] [_l_i_n_e___d_e_s_c_r_i_p_t_i_o_n] [[(ttoopp|bboottttoomm|lleefftt|
     rriigghhtt) _l_i_n_e___d_e_s_c_r_i_p_t_i_o_n] ...]

           This   describes   how   the  axes  for  the  graph  are  drawn.  A
           _l_i_n_e___d_e_s_c_r_i_p_t_i_o_n is a pic line description, e.g.,  dashed  0.5,  or
           the literal solid.  It may also include a ccoolloorr keyword followed by
           the color to draw the string in double quotes.   Any  color  under-
           stood by the underlying groff system can be used.  Color can nly be
           used under GNU pic, and is not available in compatibility mode.

           If the first _l_i_n_e___d_e_s_c_r_i_p_t_i_o_n is given, the  frame  is  drawn  with
           that  style.   The  default  is solid.  The height and width of the
           frame can also be specified in inches.  The default line style  can
           be  over-ridden  for  sides  of  the frame by specifying additional
           parameters to ffrraammee.

           If no plotting commands have been given before the ffrraammee command is
           issued,  the  frame  will  be  output at that point in the plotting
           stream relative to embedded troff or pic commands.   Otherwise  the
           frame  is  output  before  the first plotted object (even invisible
           ones).

     ccoooorrdd [_n_a_m_e] [xx _e_x_p_r, _e_x_p_r] [yy _e_x_p_r, _e_x_p_r] [lloogg xx | lloogg yy | lloogg lloogg]

           The ccoooorrdd command specifies a new coordinate system or sets  limits
           on  the default system.  It defines the largest and smallest values
           that can be plotted, and therefore the scale of  the  data  in  the
           frame.   The limits for the x and y coordinate systems can be given
           separately.  If a _n_a_m_e is given, that coordinate system is defined,
           if not the default system is modified.

           A coordinate system created by one ccoooorrdd command may be modified by
           subsequent ccoooorrdd commands.  A ggrraapp program may declare a coordinate
           space  using  ccoooorrdd, ccooppyy a file of data through a macro that plots
           the data and finds its maxima and minima, and then define the  size
           of the coordinate system with a second ccoooorrdd statement.

           This command also determines if a scale is plotted logarithmically.
           lloogg lloogg means the same thing as lloogg xx lloogg yy.

     ddrraaww [_l_i_n_e___n_a_m_e] [_l_i_n_e___d_e_s_c_r_i_p_t_i_o_n] [_p_l_o_t___s_t_r_i_n_g]

           The ddrraaww command defines the style with which a given line will  be
           plotted.   If _l_i_n_e___n_a_m_e is given, the style is associated with that
           name, otherwise the default style is set.   _l_i_n_e___d_e_s_c_r_i_p_t_i_o_n  is  a
           pic  line  description, and the optional _p_l_o_t___s_t_r_i_n_g is a string to
           be centered at each point.  The default line description is  invis,
           and the default plotting string is a centered bullet, so by default
           each point is a filled circle, and they are unconnected.  If points
           are  being  connected,  each ddrraaww command ends any current line and
           begins a new one.

           When defining a line style, that is the first ddrraaww  command  for  a
           given  line name, specifying no plot string means that there are to
           be no plot strings.  Omitting the plot string  on  subsequent  ddrraaww
           commands  addressing  the  same  named line means not to change the
           plot string.  If a line has been defined with a  plot  string,  and
           the  format  is  changed  by  a subsequent ddrraaww statement, the plot
           string can be removed by specifying "" in the ddrraaww statement.

           The plot  string  can  have  its  format  changed  through  several
           string_modifiers.   String_modifiers  are described in the descrip-
           tion of the pplloott command.

           nneeww is a synonym for ddrraaww.

     nneexxtt [_l_i_n_e___n_a_m_e] aatt [_c_o_o_r_d_i_n_a_t_e_s___n_a_m_e] _e_x_p_r, _e_x_p_r [_l_i_n_e___d_e_s_c_r_i_p_t_i_o_n]

           The nneexxtt command plots the given point using the line  style  given
           by  _l_i_n_e___n_a_m_e,  or  the  default if none is given.  If _l_i_n_e___n_a_m_e is
           given, it should have been defined by an earlier ddrraaww  command,  if
           not  a  new  line  style with that name is created, initialized the
           same way as the  default  style.   The  two  expressions  give  the
           point's x and y values, relative to the optional coordinate system.
           That system should have been defined by an earlier  ccoooorrdd  command,
           if not, grap will exit.  If the optional _l_i_n_e___d_e_s_c_r_i_p_t_i_o_n is given,
           it overrides the style's  default  line  description.   You  cannot
           over-ride  the plotting string.  To use a different plotting string
           use the pplloott command.

           The coordinates may optionally be enclosed in  parentheses:  (_e_x_p_r,
           _e_x_p_r)

     _q_u_o_t_e_d___s_t_r_i_n_g [_s_t_r_i_n_g___m_o_d_i_f_i_e_r_s] [, _q_u_o_t_e_d___s_t_r_i_n_g [_s_t_r_i_n_g___m_o_d_i_f_i_e_r_s]] ...
     aatt [_c_o_o_r_d_i_n_a_t_e_s___n_a_m_e] _e_x_p_r, _e_x_p_r

     pplloott _e_x_p_r [_f_o_r_m_a_t___s_t_r_i_n_g] aatt [_c_o_o_r_d_i_n_a_t_e_s___n_a_m_e] _e_x_p_r, _e_x_p_r

           These commands both plot a string at the given point.  In the first
           case  the  literal  strings  are  stacked  above  each  other.  The
           string_modifiers include the pic  justification  modifiers  (lljjuusstt,
           rrjjuusstt, aabboovvee, and bbeellooww), and absolute and relative size modifiers.
           See the pic documentation for the description of the  justification
           modifiers.   ggrraapp also supports the aalliiggnneedd and uunnaalliiggnneedd modifiers
           which are briefly noted in the description of the llaabbeell command.

           Strings placed by either format of the pplloott command are  restricted
           to  being  within  the  frame.   This can be overriden by using the
           uunncclliippppeedd attribute, which allows a string to be plotted in or  out
           of  the  frame.   The --cc and --CC flags set uunncclliippppeedd on all strings,
           and to prevent a string from being plotted outside the  frame  when
           those flags are active, the cclliippppeedd attribute can be used to retore
           clipping behavior.  Though cclliippppeedd or uunncclliippppeedd can be  applied  to
           any string, it only has meaning for pplloott statements.

           size _e_x_p_r sets the string size to _e_x_p_r points.  If _e_x_p_r is preceded
           by a + or -, the size  is  increased  or  decreased  by  that  many
           points.

           If ccoolloorr and a color name in double quotes appears, the string will
           be rendered in that color under a version of GNU  troff  that  sup-
           ports color.  Color is not available in compatibility mode.

           In the second version, the _e_x_p_r is converted to a string and placed
           on the graph.  _f_o_r_m_a_t___s_t_r_i_n_g is a printf(3)  format  string.   Only
           formatting  escapes for printing floating point numbers make sense.
           The format string is only respected if the sspprriinnttff command is  also
           active.   See  the  description  of sspprriinnttff for the various ways to
           disable it.  PPlloott and sspprriinnttff respond differently when ggrraapp is run-
           ning  safely.   SSpprriinnttff  ignores  any arguments, passing the format
           string through  without  substitution.   pplloott  ignores  the  format
           string completely, plotting _e_x_p_r using the "%g" format.

           Points  are  specified  the same way as for nneexxtt commands, with the
           same consequences for undefined coordinate systems.

           The second form of this command is because the first  form  can  be
           used with a ggrraapp sspprriinnttff expression (See _E_x_p_r_e_s_s_i_o_n_s).

     ttiicckkss (lleefftt|rriigghhtt|ttoopp|bboottttoomm)[ (iinn|oouutt) [_e_x_p_r]] [oonn||aauuttoo _c_o_o_r_d___n_a_m_e]

     ttiicckkss (lleefftt|rriigghhtt|ttoopp|bboottttoomm) (iinn|oouutt) [_e_x_p_r] [uupp _e_x_p_r | ddoowwnn _e_x_p_r | lleefftt
     _e_x_p_r | rriigghhtt _e_x_p_r] aatt [_c_o_o_r_d___n_a_m_e] _e_x_p_r [_f_o_r_m_a_t___s_t_r_i_n_g] [[, _e_x_p_r
     [_f_o_r_m_a_t___s_t_r_i_n_g]] ...]

     ttiicckkss (lleefftt|rriigghhtt|ttoopp|bboottttoomm) (iinn|oouutt) [_e_x_p_r] [uupp _e_x_p_r | ddoowwnn _e_x_p_r | lleefftt
     _e_x_p_r | rriigghhtt _e_x_p_r] ffrroomm [coord_name] _s_t_a_r_t___e_x_p_r ttoo _e_n_d___e_x_p_r [bbyy [+|-|*|/]
     _b_y___e_x_p_r] [format_string]

     ttiicckkss [lleefftt|rriigghhtt|ttoopp|bboottttoomm] ooffff

           This  command  controls  the  placement  of ticks on the frame.  By
           default, ticks are automatically generated on the left  and  bottom
           sides of the frame.

           The  first version of this command turns on the automatic tick gen-
           eration for a given side.  The iinn or  oouutt  parameter  controls  the
           direction  and  length of the ticks.  If a _c_o_o_r_d___n_a_m_e is specified,
           the ticks are automatically generated using that coordinate system.
           If  no  system is specified, the default coordinate system is used.
           As with nneexxtt and pplloott,  the  coordinate  system  must  be  declared
           before  the  ttiicckkss  statement  that references it.  This syntax for
           requesting automatically generated ticks is an extension, and  will
           not port to older ggrraapp implementations.

           The  second  version  of  the ttiicckkss command overrides the automatic
           placement of the ticks by specifying a list of coordinates at which
           to  place  the ticks.  If the ticks are not defined with respect to
           the default coordinate system, the  _c_o_o_r_d___n_a_m_e  parameter  must  be
           given.  For each tick a printf(3) style format string can be given.
           The _f_o_r_m_a_t___s_t_r_i_n_g defaults to "%g".  The  format  string  can  also
           take  string  modifiers as described in the pplloott command.  To place
           ticks with no labels, specify _f_o_r_m_a_t___s_t_r_i_n_g as "".

           If sspprriinnttff is disabled, ttiicckkss behaves as pplloott with respect  to  the
           format string.

           The  labels  on  the ticks may be shifted by specifying a direction
           and the distance in inches  to  offset  the  label.   That  is  the
           optional direction and expression immediately preceding the aatt.

           The  third  format of the ttiicckkss command over-rides the default tick
           generation with a set of ticks ar regular intervals.  The syntax is
           reminiscent  of  programming  language for loops.  Ticks are placed
           starting at _s_t_a_r_t___e_x_p_r ending at _e_n_d___e_x_p_r one unit apart.   If  the
           bbyy clause is specified, ticks are _b_y___e_x_p_r units apart.  If an oper-
           ator appears before _b_y___e_x_p_r each tick is operated on by that opera-
           tor instead of +.  For example

                       ticks left out from 2 to 32 by *2

           will  put ticks at 2, 4, 8, 16, and 32.  If _f_o_r_m_a_t___s_t_r_i_n_g is speci-
           fied, all ticks are formatted using it.

           The parameters preceding the ffrroomm act as described above.

           The aatt and ffoorr forms of tick command may both be issued on the same
           side of a frame.  For example:

                       ticks left out from 2 to 32 by *2
                       ticks left in 3, 5, 7

           will  put ticks on the left side of the frame pointing out at 2, 4,
           8, 16, and 32 and in at 3, 5, and 7.

           The final form of ttiicckkss turns off ticks on a  given  side.   If  no
           side is given the ticks for all sides are cancelled.

           ttiicckk is a synonym for ttiicckkss.

     ggrriidd (lleefftt|rriigghhtt|ttoopp|bboottttoomm) [ticks off] [_l_i_n_e___d_e_s_c_r_i_p_t_i_o_n] [uupp _e_x_p_r |
     ddoowwnn _e_x_p_r | lleefftt _e_x_p_r | rriigghhtt _e_x_p_r] [oonn||aauuttoo [_c_o_o_r_d___n_a_m_e]]

     ggrriidd (lleefftt|rriigghhtt|ttoopp|bboottttoomm) [ticks off] [_l_i_n_e___d_e_s_c_r_i_p_t_i_o_n] [uupp _e_x_p_r |
     ddoowwnn _e_x_p_r | lleefftt _e_x_p_r | rriigghhtt _e_x_p_r] aatt [_c_o_o_r_d___n_a_m_e] _e_x_p_r [_f_o_r_m_a_t___s_t_r_i_n_g]
     [[, _e_x_p_r [_f_o_r_m_a_t___s_t_r_i_n_g]] ...]

     ggrriidd (lleefftt|rriigghhtt|ttoopp|bboottttoomm) [ticks off] [_l_i_n_e___d_e_s_c_r_i_p_t_i_o_n] [uupp _e_x_p_r |
     ddoowwnn _e_x_p_r | lleefftt _e_x_p_r | rriigghhtt _e_x_p_r] ffrroomm [coord_name] _s_t_a_r_t___e_x_p_r ttoo
     _e_n_d___e_x_p_r [bbyy [+|-|*|/] _b_y___e_x_p_r] [format_string]

           The ggrriidd command is similar to the ttiicckkss command except  that  ggrriidd
           specifies the placement of lines in the frame.  The syntax is simi-
           lar to ttiicckkss as well.

           By specifying ticks off in the command, no ticks are drawn on  that
           side  of  the frame.  If ticks appear on a side by default, or have
           been declared by an earlier ttiicckkss command,  ggrriidd  does  not  cancel
           them unless ticks off is specified.

           Instead  of  a  direction for ticks, ggrriidd allows the user to pick a
           line description for the grid lines.  The usual pic  line  descrip-
           tions are allowed.

           Grids  are labelled by default.  To omit labels, specify the format
           string as "".

           If sspprriinnttff is disabled, ggrriidd behaves as pplloott with  respect  to  the
           format string.

     llaabbeell (lleefftt|rriigghhtt|ttoopp|bboottttoomm) _q_u_o_t_e_d___s_t_r_i_n_g [_s_t_r_i_n_g___m_o_d_i_f_i_e_r_s] [,
     _q_u_o_t_e_d___s_t_r_i_n_g [_s_t_r_i_n_g___m_o_d_i_f_i_e_r_s]] ...  [uupp _e_x_p_r | ddoowwnn _e_x_p_r | lleefftt _e_x_p_r |
     rriigghhtt _e_x_p_r]

           The llaabbeell command places a label on the given axis.  It is possible
           to specify several labels, which will be stacked over each other as
           in  pic.  The final argument, if present, specifies how many inches
           the label is shifted from the axis.

           By default the labels on the left and right labels run parallel  to
           the  frame.   You  can  cancel  this  by  specifying unaligned as a
           _s_t_r_i_n_g___m_o_d_i_f_i_e_r.

     cciirrccllee aatt [_c_o_o_r_d_i_n_a_t_e___n_a_m_e] _e_x_p_r, _e_x_p_r [rraaddiiuuss _e_x_p_r] [_l_i_n_e_d_e_s_c]

           This draws an circle at the point indicated.  By default, the  cir-
           cle  is small, 0.025 inches.  This can be over-ridden by specifying
           a radius.  The coordinates of the point are relative to  the  named
           coordinate system, or the default system if none is specified.

           This  command  has  been extended to take a line description, e.g.,
           dotted.  It also accepts the filling extensions described below  in
           the  bbaarr  command.   It will also accept a ccoolloorr keyword that gives
           the color of the outline of the  circle  in  double  quotes  and  a
           ffiillllccoolloorr command that sets the color to fill the circle with simi-
           larly.  Colors are only available when compatibility mode  is  off,
           and using a version of GNU pic that supports color.

     lliinnee [_l_i_n_e___d_e_s_c_r_i_p_t_i_o_n] ffrroomm [_c_o_o_r_d_i_n_a_t_e___n_a_m_e] _e_x_p_r, _e_x_p_r ttoo
     [_c_o_o_r_d_i_n_a_t_e___n_a_m_e] _e_x_p_r, _e_x_p_r [_l_i_n_e___d_e_s_c_r_i_p_t_i_o_n]

     aarrrrooww [_l_i_n_e___d_e_s_c_r_i_p_t_i_o_n] ffrroomm [_c_o_o_r_d_i_n_a_t_e___n_a_m_e] _e_x_p_r, _e_x_p_r ttoo
     [_c_o_o_r_d_i_n_a_t_e___n_a_m_e] _e_x_p_r, _e_x_p_r [_l_i_n_e___d_e_s_c_r_i_p_t_i_o_n]

           This draws a line or arrow from the first point to the second using
           the  given  style.   The  default  line  style   is   solid.    The
           _l_i_n_e___d_e_s_c_r_i_p_t_i_o_n  can  be given either before the ffrroomm or after the
           ttoo clause.  If both are given the second is used.  It  is  possible
           to  specify  one point in one coordinate system and one in another,
           note that if both points are in a named coordinate system (even  if
           they  are  in  the  same named coordinate system), both points must
           have _c_o_o_r_d_i_n_a_t_e___n_a_m_e given.

     ccooppyy ["_f_i_l_e_n_a_m_e"] [uunnttiill "_s_t_r_i_n_g"] [tthhrruu _m_a_c_r_o]

           The ccooppyy command imports data from another file  into  the  current
           graph.  The form with only a filename given is a simple file inclu-
           sion; the included file is simply read into the  input  stream  and
           can  contain arbitrary ggrraapp commands.  The more common case is that
           it is a number list; see _N_u_m_b_e_r _L_i_s_t_s below.

           The second form takes lines from the file, splits them  into  words
           delimited  by  one  or  more spaces, and calls the given macro with
           those words as parameters.  The macro may either be  defined  here,
           or  be a macro defined earlier.  See _M_a_c_r_o_s for more information on
           macros.

           The _f_i_l_e_n_a_m_e may be omitted if the uunnttiill clause is present.  If  so
           the  current  file  is  treated  as  the input file until _s_t_r_i_n_g is
           encountered at the beginning of the line.

           ccooppyy is one of the workhorses of ggrraapp.  Check  out  the  paper  and
           _/_u_s_r_/_l_o_c_a_l_/_s_h_a_r_e_/_d_o_c_/_g_r_a_p_/_e_x_a_m_p_l_e_s for more details.
     pprriinntt (_e_x_p_r_|_s_t_r_i_n_g)

           Prints its argument to the standard error.

     sshh _b_l_o_c_k

           This  passes  _b_l_o_c_k to sh(1).  Unlike K&B ggrraapp no macro or variable
           expansion is done.  I believe that this is also true  for  gnu  pic
           version  1.10.   See the _M_a_c_r_o_s section for information on defining
           blocks.

     ppiicc _p_i_c___s_t_a_t_e_m_e_n_t

           This issues the given pic statements  in the enclosing ..PPSS and  ..PPEE
           at the point where the command is issued.

           Statements   that   begin  with  a  period  are  considered  to  be
           troff(statements) and are output in the enclosing ..PPSS  and  ..PPEE  at
           the point where the command appears.

           For  the  purposes  of relative placement of pic or troff commands,
           the frame is output immediately before the first plotted object, or
           the  ffrraammee  statement,  if any.  If the user specifies pic or troff
           commands and neither any plotable object nor a ffrraammee  command,  the
           commands will not be output.

     ggrraapphh _N_a_m_e _p_i_c___c_o_m_m_a_n_d_s

           This command is used to position graphs with respect to each other.
           The current graph is given the pic name _N_a_m_e ( pic names begin with
           capital letters).  Any pic commands following the graph are used to
           position the next graph.  The frame of the graph is  available  for
           use  with pic name Frame. The following places a second graph below
           the first:

                       graph Linear
                       [ graph description ]
                       graph Exponential with .Frame.n at \
                               Linear.Frame.s - (0, .05)
                       [ graph description ]

     _n_a_m_e _= _e_x_p_r

           This assigns _e_x_p_r to the variable  _n_a_m_e.   ggrraapp  has  only  numeric
           (double) variables.

           Assignment creates a variable if it does not exist.  Variables per-
           sist across graphs.  Assignments can cascade; a = b = 35 assigns 35
           to a and b.

     bbaarr (uupp|rriigghhtt) [_c_o_o_r_d_i_n_a_t_e_s___n_a_m_e] _o_f_f_s_e_t hhtt _h_e_i_g_h_t [wwiidd _w_i_d_t_h] [bbaassee
     _b_a_s_e___o_f_f_s_e_t] [_l_i_n_e___d_e_s_c_r_i_p_t_i_o_n]

     bbaarr [_c_o_o_r_d_i_n_a_t_e_s___n_a_m_e] _e_x_p_r, _e_x_p_r, [_c_o_o_r_d_i_n_a_t_e_s___n_a_m_e] _e_x_p_r, _e_x_p_r,
     [_l_i_n_e___d_e_s_c_r_i_p_t_i_o_n]

           The  bbaarr command facilitates drawing bar graphs.  The first form of
           the command describes the bar somewhat generally and has ggrraapp place
           it.   The  bar may extend up or to the right, is centered on _o_f_f_s_e_t
           and extends up or right _h_e_i_g_h_t units (in the given coordinate  sys-
           tem).  For example

                       bar up 3 ht 2

           draws a 2 unit high bar sitting on the x axis, centered on x=3.  By
           default bars are 1 unit wide, but this can be changed with the  wwiidd
           keyword.  By default bars sit on the base axis, i.e., bars directed
           up will extend from y=0.  That may be overridden by the  bbaassee  key-
           word.  (The bar described above has corners (2.5, 0) and (3.5, 2).)

           The line description has been extended to include a ffiillll _e_x_p_r  key-
           word  that specifies the shading inside the bar.  Bars may be drawn
           in any line style.  They support the ccoolloorr and  ffiillllccoolloorr  keywords
           described under cciirrccllee.

           The  second  form of the command draws a box with the two points as
           corners.  This can be used to draw boxes highlighting certain  data
           as well as bar graphs.  Note that filled bars will cover data drawn
           under them.

   CCoonnttrrooll FFllooww
     iiff _e_x_p_r tthheenn _b_l_o_c_k [eellssee _b_l_o_c_k]

           The iiff statement provides simple conditional execution.  If _e_x_p_r is
           non-zero,  the  _b_l_o_c_k after the tthheenn statement is executed.  If not
           the _b_l_o_c_k after the eellssee is executed, if present.  See  _M_a_c_r_o_s  for
           the definition of blocks.  Early versions of this implementation of
           ggrraapp treated the blocks as macros that were defined and expanded in
           place.   This led to unnecessary confusion because explicit separa-
           tors were sometimes called for.  Now, ggrraapp inserts a separator  (;)
           after the last character in _b_l_o_c_k, so constructs like

           if (x == 3) { y = y + 1 }
           x = x + 1

           behave  as  expected.  A separator is also appended to the end of a
           ffoorr block.

     ffoorr _n_a_m_e ffrroomm _f_r_o_m___e_x_p_r ttoo _t_o___e_x_p_r [bbyy [+|-|*|/] _b_y___e_x_p_r] ddoo _b_l_o_c_k

           This command executes _b_l_o_c_k iteratively.  The variable _n_a_m_e is  set
           to  _f_r_o_m___e_x_p_r  and incremented by _b_y___e_x_p_r until it exceeds _t_o___e_x_p_r.
           The iteration has the semantics defined in the ttiicckkss command.   The
           definition  of  _b_l_o_c_k  is  discussed  in _M_a_r_c_o_s.  See also the note
           about implicit separators in the description of the iiff command.

           An == can be used in place of ffrroomm.

   EExxpprreessssiioonnss
     ggrraapp supports a most standard arithmetic operators: + - / * ^.  The carat
     (^) is exponentiation.  In an iiff statement ggrraapp also supports the C logi-
     cal operators ==, !=, &&, || and unary !.  Also in an iiff, == and != are
     overloaded for the comparison of quoted strings.  Parentheses are used
     for grouping.

     Assignment is not allowed in an expression in any context, except for
     simple cascading of assignments.  a = b = 35 works as expected; a = 3.5 *
     (b = 10) does not execute.

     ggrraapp supports the following functions that take one argument: lloogg, eexxpp,
     iinntt, ssiinn, ccooss, ssqqrrtt, rraanndd.  The logarithms are base 10 and the trigono-
     metric functions are in radians.  eeeexxpp returns Euler's number to the
     given power and llnn returns the natural logarithm.  The natural log and
     exponentiation functions are extensions and are probably not available in
     other ggrraapp implementations.

     rraanndd returns a random number uniformly distributed on [0,1).  The follow-
     ing two argument functions are supported: aattaann22, mmiinn, mmaaxx.  aattaann22 works
     just like atan2(3).  The random number generator can be seeded by calling
     ssrraanndd with a single parameter (converted internally to an integer).
     Because its return value is of no use, you must use ssrraanndd as a separate
     statement, it is not part of a valid expression.  ssrraanndd is not portable.

     The ggeettppiidd function takes no arguments and returns the process id.  This
     may be used to seed the random number generator, but do not expect cryp-
     tographically random values to result.

     Other than string comparison, no expressions can use strings.  One string
     valued function exists: sspprriinnttff (_f_o_r_m_a_t, [_e_x_p_r [_, _e_x_p_r]] ).  It operates
     like sprintf(3), except returning the value.  It can be used anywhere a
     quoted string is used.  If ggrraapp is run with --SS, the environment variable
     GRAP_SAFER is defined, or ggrraapp has been compiled for safer operation, the
     sspprriinnttff command will return the format string.  This mode of operation is
     only intended to be used only if ggrraapp is being used as part of a super-
     user enabled print system.

   MMaaccrrooss
     ggrraapp has a simple but powerful macro facility.  Macros are defined using
     the ddeeffiinnee command :

     ddeeffiinnee _n_a_m_e _b_l_o_c_k
     uunnddeeffiinnee _n_a_m_e

           Every  occurrence  of  _n_a_m_e  in the program text is replaced by the
           contents of _b_l_o_c_k.  _b_l_o_c_k is defined by a series of  statements  in
           nested { }'s, or a series of statements surrounded by the same let-
           ter.  An example of the latter is

                       define foo  X coord x 1,3 X
           Each time foo appears in the text, it will be replaced by  coord  x
           1,3.   Macros  are  literal,  and can contain newlines.  If a macro
           does not span multiple lines, it should end in a semicolon to avoid
           parsing errors.

           Macros  can take parameters, too.  If a macro call is followed by a
           parenthesized, comma-separated list the  values  starting  with  $1
           will  be  replaced in the macro with the elements of the list.  A $
           not followed by a digit is left unchanged.  This  parsing  is  very
           rudimentary,  no  nesting  or  parentheses or escaping of commas is
           allowed.  Also, there is no way to say argument  1  followed  by  a
           digit (${1}0 in sh(1)).

           The following will draw a line with slope 1.

                       define foo { next at $1, $2 }
                       for i from 1 to 5 { foo(i,i) }
           Macros       persist       across       graphs.       The      file
           _/_u_s_r_/_l_o_c_a_l_/_s_h_a_r_e_/_g_r_a_p_/_g_r_a_p_._d_e_f_i_n_e_s contains simple macros for plot-
           ting common characters.  The uunnddeeffiinnee command deletes a macro.

           See  the  file _/_u_s_r_/_l_o_c_a_l_/_s_h_a_r_e_/_d_o_c_/_g_r_a_p_/_e_x_a_m_p_l_e_s for more examples
           of macros.

   NNuummbbeerr LLiissttss
     A whitespace-separated list of numbers is treated specially.  The list is
     taken to be points to be plotted using the default line style on the
     default coordinate system.  If more than two numbers are given, the extra
     numbers are taken to be additional y values to plot at the first x value.
     Number lists in DWB ggrraapp can be comma-separated, and this ggrraapp supports
     that as well.  More precisely, numbers in number lists can be separated
     by either whitespace, commas, or both.

           1 2 3
           4 5 6

     Will plot points using the default line style at (1,2), (1,3),(4,5) and
     (4,6).  A simple way to plot a set of numbers in a file named _._/_d_a_t_a is:

           .G1
           copy "./data"
           .G2

   PPiicc MMaaccrrooss
     ggrraapp defines pic macros that can be used in embedded pic code to place
     elements in the graph.  The macros are xx__gggg, yy__gggg, and xxyy__gggg.  These
     macros define pic distances that correspond to the given argument.  They
     can be used to size boxes or to plot pic constructs on the graph.  To
     place a given construct on the graph, you should add Frame.Origin to it.
     Other coordinate spaces can be used by replacing gggg with the name of the
     coordinate space.  A coordinate space named gggg cannot be reliably
     accessed by these macros.

     The macros are emitted immediately before the frame is drawn.

     DWB ggrraapp may use these as part of its implementation.  This ggrraapp provides
     them only for compatibility.  Note that these are very simple macros, and
     may not do what you expect under complex conditions.

EENNVVIIRROONNMMEENNTT VVAARRIIAABBLLEESS
     If the environment variable GRAP_DEFINES is defined, ggrraapp will look for
     its defines file there.  If that value is a relative path name the path
     specified in the --MM option will be searched for it.  GRAP_DEFINES over-
     rides the compiled in location of the defines file, but may be overridden
     by the --dd or --DD flags.

     If GRAP_SAFER is set, sspprriinnttff is disabled to prevent forcing ggrraapp to core
     dump or smash the stack.

FFIILLEESS
     _/_u_s_r_/_l_o_c_a_l_/_s_h_a_r_e_/_g_r_a_p_/_g_r_a_p_._d_e_f_i_n_e_s

SSEEEE AALLSSOO
     atan2(3), groff(1), pic(1), printf(3), sh(1), sprintf(3), troff(1)

BBUUGGSS
     There are several small incompatibilities with K&R ggrraapp.  They include
     the sshh command not expanding variables and macros, and a more strict
     adherence to parameter order in the internal commands.

     Although much improved, the error reporting code can still be confused.
     Notably, an error in a macro is not detected until the macro is used, and
     it produces unusual output in the error message.

     Iterating many times over a macro with no newlines can run ggrraapp out of
     memory.

AAUUTTHHOORR
     This implementation was done by Ted Faber <faber@lunabase.org>.  Bruce
     Lilly <blilly@erols.com> contributed many bug fixes, including a consid-
     erable revamp of the error reporting code.  If you can actually find an
     error in your ggrraapp code, you can probably thank him.  ggrraapp was designed
     and specified by Brian Kernighan and Jon Bentley.

FreeBSD 4.7                     August 19, 1998                    FreeBSD 4.7
