# ascmac.perl, version 3.0 1999/9/15
#
# ascmac.perl by Kenshi Muto <kmuto@debian.org>

package main;

sub do_cmd_yen {
  local($_) = @_;
  "$_";
}
sub do_cmd_textasciitilde {
  local($_) = @_;
  "&#126;$_";
}
sub do_cmd_keytop {
  local($_) = @_;
  if ($HTML_VERSION < 4.0) {
    "<code>$_</code>";
  } else {
    "<SPAN STYLE=\"border-width: thin; border-style: solid\">$_</SPAN>";
  }
}
sub do_cmd_return {
  local($_) = @_;
  if ($HTML_VERSION < 4.0) {
    "[Enter]$_";
  } else {
    "<SPAN STYLE=\"border-width: thin; border-style: solid\">Enter</SPAN>$_";
  }
}

sub do_env_screen {
  if ($HTML_VERSION < 4.0) {
    join('',"<TABLE BORDER=\"1\"><TR><TD>","@_","</TD></TR></TABLE>");
  } else {
    join('',"<DIV STYLE=\"border: inset blue; background-color: white\">","@_","</DIV>");
  }
}

sub do_env_column {
  local($_) = @_;
  local($title) = '';
  $title = &missing_braces unless
    ((s/$next_pair_rx/$title=$2;''/e) ||
     (s/$next_pair_pr_rx/$title=$2;''/e));
  $_ = &translate_environments($_);
  if ($HTML_VERSION < 4.0) {
    join('',"<TABLE BORDER=\"1\"><TR><TD>:$title</TD></TR>","<TR><TD>$_\n</TD></TR></TABLE>\n");
  } else {
    join('',"<TABLE STYLE=\"border: sold; background-color: lime\"><TR><TH STYLE=\"background-color: green\">:$title</TH></TR>","<TR><TD>$_\n</TD></TR></TABLE>\n");
  }
}

sub do_cmd_theprogramno {
  join('', &do_cmd_arabic("${O}0${C}programno${O}0$C"), @_[0]) }

sub do_cmd_thecolumnno {
  join('', &do_cmd_arabic("${O}0${C}columnno${O}0$C"), @_[0]) }

1;
