/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary;

import info.jdictionary.JDictionary;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class FileDownloader {
    public boolean stop = false;

    public void terminate() {
        this.stop = true;
    }

    public byte[] download(URL url, JProgressBar progressBar, int fileSize) {
        DataInputStream din = null;
        int offset = 0;
        int length = 4096;
        int temp = 0;
        byte[] b = new byte[fileSize];
        try {
            din = new DataInputStream(url.openStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (!this.stop) {
            try {
                temp = din.read(b, offset, length);
            }
            catch (IOException e) {
                byte[] byArray = null;
                return byArray;
            }
            if (temp == -1) {
                return b;
            }
            if (fileSize - (offset += temp) < length) {
                length = fileSize - offset;
            }
            this.notifyProgressBar(progressBar, offset, fileSize);
        }
        return null;
    }

    void notifyProgressBar(final JProgressBar progressBar, final int currentState, final int topValue) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (progressBar != null) {
                    progressBar.setValue(currentState);
                    progressBar.setString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(currentState / 1024))).append(" ").append(JDictionary.getString("KB of")).append(" ").append(topValue / 1024).append(" ").append(JDictionary.getString("KB")))));
                    progressBar.validate();
                    progressBar.repaint();
                }
            }
        });
    }
}

