/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import info.jdictionary.IconBank;
import info.jdictionary.ImageBank;
import info.jdictionary.LatestVersionChecker;
import info.jdictionary.Plugin;
import info.jdictionary.Prefs;
import info.jdictionary.TreeGen;
import info.jdictionary.gui.AboutPanel;
import info.jdictionary.gui.AdvDefaultMutableTreeNode;
import info.jdictionary.gui.AllPluginsDeactivatedPanel;
import info.jdictionary.gui.InfoPanel;
import info.jdictionary.gui.JDictionaryTheme;
import info.jdictionary.gui.NamedTabbedPane;
import info.jdictionary.gui.NewVersionInfoPanel;
import info.jdictionary.gui.NoPluginsPanel;
import info.jdictionary.pluginstuff.PluginDownloader;
import info.jdictionary.pluginstuff.PluginManager;
import info.jdictionary.pluginstuff.PluginStatusChanger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JDictionary
extends JFrame {
    public static ResourceBundle JDictionaryResources;
    static Prefs prefs;
    TreeGen treeGen;
    PluginDownloader pluginDownloader;
    PluginStatusChanger pluginStatusChanger;
    NewVersionInfoPanel newVersionInfoPanel;
    JMenuBar jDictionaryMenuBar = new JMenuBar();
    DefaultMutableTreeNode pluginRootTreeNode = new DefaultMutableTreeNode(JDictionary.getString("Dictionaries"));
    JTree pluginTree = new JTree(this.pluginRootTreeNode);
    DefaultMutableTreeNode nodeRepresentedByOutputTabbedPane;
    JPanel outputPanel = new JPanel();
    JPanel statusPanel = new JPanel();
    JPanel jPanel1 = new JPanel();
    JPanel upperPanel = new JPanel();
    JPanel lowerPanel = new JPanel();
    JPanel pluginTreeViewPanel = new JPanel();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel rescanLabel = new JLabel(JDictionary.getString("Rescan"), IconBank.rescan, 0);
    JLabel downloadLabel = new JLabel(JDictionary.getString("Download&Install"), IconBank.FolderIn, 0);
    JLabel activateLabel = new JLabel(JDictionary.getString("ActivateDeactivate"), IconBank.plug, 0);
    JLabel newAvail;
    JScrollPane outputScrollPane = new JScrollPane();
    JScrollPane pluginTreeViewScrollPane = new JScrollPane();
    JSplitPane outputSplitPane = new JSplitPane();
    JSplitPane pluginSplitPane = new JSplitPane();
    JButton downloadSmallButton = new JButton();
    JButton activateSmallButton = new JButton();
    JButton rescanSmallButton = new JButton();
    JMenu JDictionaryMenu = new JMenu();
    JMenu PluginMenu = new JMenu();
    JMenuItem exitMenuItem = new JMenuItem();
    JMenuItem aboutMenuItem = new JMenuItem();
    JMenuItem downloadMenuItem = new JMenuItem();
    JMenuItem activateMenuItem = new JMenuItem();
    JMenuItem rescanMenuItem = new JMenuItem();
    JTabbedPane pluginHandlerTabbedPane;
    JToolBar pluginOptionsToolBar = new JToolBar();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    BoxLayout boxLayout1 = new BoxLayout(this.getContentPane(), 1);
    BoxLayout boxLayout2 = new BoxLayout(this.lowerPanel, 1);

    public JDictionary() {
        prefs = this.loadPrefs();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("JDictionaryName")))).append(" ").append(JDictionary.getString("JDictionaryVersion")))));
        ((Frame)this).setIconImage(IconBank.world.getImage());
        this.getContentPane().setLayout(this.boxLayout1);
        this.getContentPane().add((Component)this.jPanel1, null);
        this.getContentPane().add((Component)this.outputSplitPane, null);
        this.getContentPane().add((Component)this.statusPanel, null);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JDictionary.this.jDictionaryResized(e);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JDictionary.this.closeJDictionary();
            }
        });
        this.jPanel1.setBackground(Color.black);
        this.jPanel1.setAlignmentX(0.0f);
        this.jPanel1.setAlignmentY(0.0f);
        this.jPanel1.setMaximumSize(new Dimension(2048, 60));
        this.jPanel1.setLayout(this.borderLayout2);
        this.jLabel1.setIcon(ImageBank.MainHeaderLeftSide);
        this.jPanel1.add((Component)this.jLabel1, "West");
        this.jPanel1.add((Component)this.jLabel2, "East");
        this.jLabel2.setIcon(ImageBank.MainHeaderRightSide);
        this.jLabel3.setBackground(Color.black);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("JDictionaryName")))).append(" ").append(JDictionary.getString("JDictionaryVersion")).append(" ").append(JDictionary.getString("Year")).append(" ").append(JDictionary.getString("JDictionaryAuthor")).append("   "))));
        this.outputSplitPane.setMaximumSize(new Dimension(2048, 2048));
        this.outputSplitPane.setContinuousLayout(true);
        this.outputSplitPane.setDividerSize(2);
        this.outputSplitPane.setLastDividerLocation(195);
        this.outputSplitPane.setOneTouchExpandable(true);
        this.statusPanel.setAlignmentX(0.0f);
        this.statusPanel.setAlignmentY(0.0f);
        this.statusPanel.setMaximumSize(new Dimension(2048, 20));
        this.statusPanel.setLayout(this.borderLayout4);
        this.statusPanel.add((Component)this.jLabel3, "East");
        this.outputPanel.setAlignmentX(0.0f);
        this.outputPanel.setAlignmentY(0.0f);
        this.outputPanel.setLayout(this.borderLayout3);
        this.pluginSplitPane.setOrientation(0);
        this.pluginSplitPane.setContinuousLayout(true);
        this.pluginSplitPane.setDividerSize(2);
        this.pluginSplitPane.setOneTouchExpandable(true);
        this.pluginTreeViewPanel.setBackground(Color.white);
        this.pluginTreeViewPanel.add(this.pluginTree);
        this.outputSplitPane.setDividerLocation(195);
        this.outputSplitPane.add((Component)this.outputScrollPane, "right");
        this.outputSplitPane.add((Component)this.pluginSplitPane, "left");
        this.outputScrollPane.getViewport().add((Component)this.outputPanel, null);
        this.pluginSplitPane.add((Component)this.upperPanel, "top");
        this.pluginSplitPane.add((Component)this.lowerPanel, "bottom");
        this.pluginTreeViewScrollPane.getViewport().add((Component)this.pluginTreeViewPanel, null);
        this.setJMenuBar(this.jDictionaryMenuBar);
        this.upperPanel.setLayout(this.borderLayout1);
        this.upperPanel.add((Component)this.pluginTreeViewScrollPane, "Center");
        this.upperPanel.add((Component)this.pluginOptionsToolBar, "North");
        this.lowerPanel.setLayout(this.boxLayout2);
        this.lowerPanel.setBackground(Color.white);
        this.lowerPanel.add(this.rescanLabel);
        this.lowerPanel.add(this.downloadLabel);
        this.lowerPanel.add(this.activateLabel);
        this.pluginOptionsToolBar.setFloatable(false);
        this.pluginOptionsToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.pluginOptionsToolBar.add(this.rescanSmallButton);
        this.pluginOptionsToolBar.add(this.activateSmallButton);
        this.pluginOptionsToolBar.add(this.downloadSmallButton);
        this.jDictionaryMenuBar.add(this.JDictionaryMenu);
        this.jDictionaryMenuBar.add(this.PluginMenu);
        this.JDictionaryMenu.add(this.aboutMenuItem);
        this.JDictionaryMenu.addSeparator();
        this.JDictionaryMenu.add(this.exitMenuItem);
        this.PluginMenu.add(this.downloadMenuItem);
        this.PluginMenu.add(this.activateMenuItem);
        this.PluginMenu.add(this.rescanMenuItem);
        this.rescanLabel.setBorder(BorderFactory.createEmptyBorder(1, 3, 0, 0));
        this.rescanLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JDictionary.this.rescanLabel_mousePressed(e);
            }

            public void mouseEntered(MouseEvent e) {
                JDictionary.this.rescanLabel_mouseEntered(e);
            }

            public void mouseExited(MouseEvent e) {
                JDictionary.this.rescanLabel_mouseExited(e);
            }
        });
        this.downloadLabel.setBorder(BorderFactory.createEmptyBorder(1, 3, 0, 0));
        this.downloadLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JDictionary.this.downloadLabel_mousePressed(e);
            }

            public void mouseEntered(MouseEvent e) {
                JDictionary.this.downloadLabel_mouseEntered(e);
            }

            public void mouseExited(MouseEvent e) {
                JDictionary.this.downloadLabel_mouseExited(e);
            }
        });
        this.activateLabel.setBorder(BorderFactory.createEmptyBorder(1, 3, 0, 0));
        this.activateLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JDictionary.this.activateLabel_mousePressed(e);
            }

            public void mouseEntered(MouseEvent e) {
                JDictionary.this.activateLabel_mouseEntered(e);
            }

            public void mouseExited(MouseEvent e) {
                JDictionary.this.activateLabel_mouseExited(e);
            }
        });
        this.JDictionaryMenu.setText(JDictionary.getString("JDictionaryMenu"));
        this.PluginMenu.setText(JDictionary.getString("PluginsMenu"));
        this.exitMenuItem.setText(JDictionary.getString("ExitMenuItem"));
        this.exitMenuItem.setIcon(IconBank.exit);
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDictionary.this.exitMenuItem_actionPerformed(e);
            }
        });
        this.aboutMenuItem.setText(JDictionary.getString("AboutMenuItem"));
        this.aboutMenuItem.setIcon(IconBank.info);
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDictionary.this.aboutMenuItem_actionPerformed(e);
            }
        });
        this.downloadMenuItem.setText(JDictionary.getString("Download&Install"));
        this.downloadMenuItem.setIcon(IconBank.FolderIn);
        this.downloadMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDictionary.this.downloadMenuItem_actionPerformed(e);
            }
        });
        this.activateMenuItem.setText(JDictionary.getString("ActivateDeactivate"));
        this.activateMenuItem.setIcon(IconBank.plug);
        this.activateMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDictionary.this.activateMenuItem_actionPerformed(e);
            }
        });
        this.rescanMenuItem.setText(JDictionary.getString("Rescan"));
        this.rescanMenuItem.setIcon(IconBank.rescan);
        this.rescanMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDictionary.this.rescanMenuItem_actionPerformed(e);
            }
        });
        this.downloadSmallButton.setIcon(IconBank.FolderIn);
        this.downloadSmallButton.setToolTipText(JDictionary.getString("Download&Install"));
        this.downloadSmallButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDictionary.this.downloadButton_actionPerformed(e);
            }
        });
        this.activateSmallButton.setIcon(IconBank.plug);
        this.activateSmallButton.setToolTipText(JDictionary.getString("ActivateDeactivate"));
        this.activateSmallButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDictionary.this.activateButton_actionPerformed(e);
            }
        });
        this.rescanSmallButton.setIcon(IconBank.rescan);
        this.rescanSmallButton.setToolTipText(JDictionary.getString("Rescan"));
        this.rescanSmallButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDictionary.this.rescanButton_actionPerformed(e);
            }
        });
        this.pluginTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                JDictionary.this.pluginTree_valueChanged(e);
            }
        });
        KunststoffLookAndFeel kunststoffLF = new KunststoffLookAndFeel();
        MetalLookAndFeel.setCurrentTheme(new JDictionaryTheme());
        UIManager.setLookAndFeel(kunststoffLF);
        SwingUtilities.updateComponentTreeUI(this);
    }

    public static void main(String[] args) {
        JDictionary jDictionary = new JDictionary();
        jDictionary.pack();
        jDictionary.restoresavedScreenState();
        jDictionary.show();
        jDictionary.rescanPlugins(true);
        jDictionary.setPluginSplitPaneDivider();
        jDictionary.latestChecker();
    }

    void showSplashScreen() {
        InfoPanel p = PluginManager.getNumberOfLoadedPlugins() > 0 ? new AboutPanel() : (PluginManager.getNumberOfAvailablePlugins() > 0 ? new AllPluginsDeactivatedPanel() : new NoPluginsPanel());
        this.outputPanel.removeAll();
        this.outputPanel.add(p);
        this.outputPanel.validate();
    }

    void showPluginDownloader() {
        this.pluginTree.setSelectionPath(null);
        if (this.pluginDownloader == null || !this.pluginDownloader.isSuccess()) {
            this.pluginDownloader = new PluginDownloader(this);
            Thread pluginDownloaderThread = new Thread(this.pluginDownloader);
            pluginDownloaderThread.start();
        }
        this.outputPanel.removeAll();
        this.outputPanel.add(this.pluginDownloader);
        this.outputScrollPane.validate();
        this.outputScrollPane.repaint();
    }

    void showPluginStatusChanger() {
        this.pluginTree.setSelectionPath(null);
        if (this.pluginStatusChanger == null) {
            this.pluginStatusChanger = new PluginStatusChanger(this);
            Thread pluginStatusChangerThread = new Thread(this.pluginStatusChanger);
            pluginStatusChangerThread.start();
        }
        this.outputPanel.removeAll();
        this.outputPanel.add(this.pluginStatusChanger);
        this.outputScrollPane.validate();
        this.outputScrollPane.repaint();
    }

    public void rescanPlugins() {
        this.rescanPlugins(false);
    }

    public synchronized Thread rescanPlugins(final boolean autoSelection) {
        if (this.treeGen != null) {
            try {
                this.treeGen.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.treeGen = new TreeGen(prefs, this.pluginTree, autoSelection);
        this.treeGen.start();
        new Thread(){

            public void run() {
                try {
                    JDictionary.this.treeGen.join();
                    if (autoSelection && JDictionary.this.pluginTree.getSelectionCount() == 0) {
                        JDictionary.this.pluginTree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)((DefaultTreeModel)JDictionary.this.pluginTree.getModel()).getRoot()).getPath()));
                    } else if (JDictionary.this.outputPanel.getComponent(0) instanceof InfoPanel) {
                        JDictionary.this.showSplashScreen();
                    }
                    if (JDictionary.this.pluginDownloader != null) {
                        JDictionary.this.pluginDownloader.updateInfoPanelsState();
                    }
                    if (JDictionary.this.pluginStatusChanger != null) {
                        JDictionary.this.pluginStatusChanger.updatePluginStatusPanels();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
        return this.treeGen;
    }

    void closeJDictionary() {
        this.savePrefs();
        PluginManager.removeAllPlugins();
        System.exit(0);
    }

    public void startPlugin(NamedTabbedPane outputTabbedPane) {
        int selectedIndex = outputTabbedPane.getSelectedIndex();
        JPanel contentPane = (JPanel)outputTabbedPane.getComponentAt(selectedIndex);
        if (contentPane.getComponentCount() > 0) {
            return;
        }
        TreeNode node = this.nodeRepresentedByOutputTabbedPane.getChildAt(selectedIndex);
        Plugin plugin = (Plugin)((DefaultMutableTreeNode)node).getUserObject();
        plugin.construct(contentPane);
        plugin.start();
        this.outputScrollPane.validate();
    }

    public NamedTabbedPane buildOutputTabbedPane(DefaultMutableTreeNode node) {
        if (node.isLeaf() || node.isRoot()) {
            System.out.println("buildtabbedPane: Problem: the given node is a root node or a leaf");
        }
        NamedTabbedPane namedTabbedPane = new NamedTabbedPane(node.toString());
        DefaultMutableTreeNode nextLeaf = null;
        int count = node.getLeafCount();
        int n = 0;
        while (n < count) {
            nextLeaf = (DefaultMutableTreeNode)node.getChildAt(n++);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setName(nextLeaf.toString());
            namedTabbedPane.add(nextLeaf.toString(), jPanel);
        }
        namedTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JDictionary.this.outputTabbedPane_stateChanged(e);
            }
        });
        this.nodeRepresentedByOutputTabbedPane = node;
        this.startPlugin(namedTabbedPane);
        return namedTabbedPane;
    }

    void latestChecker() {
        new Thread(){

            public void run() {
                URL url = null;
                try {
                    url = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("JDictionaryServerURL")))).append("/").append(JDictionary.getString("LatestFile")))));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                LatestVersionChecker lvc = new LatestVersionChecker(url);
                if (lvc.whichIsTheLatest() > JDictionary.getJDictionaryVersion()) {
                    JDictionary.this.addNewReleaseAvailableLabel();
                }
            }
        }.start();
    }

    void addNewReleaseAvailableLabel() {
        this.newAvail = new JLabel(JDictionary.getString("NewJDictionaryAvailable"), IconBank.bulb, 0);
        this.newAvail.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JDictionary.this.newAvail_mousePressed(e);
            }

            public void mouseEntered(MouseEvent e) {
                JDictionary.this.newAvail_mouseEntered(e);
            }

            public void mouseExited(MouseEvent e) {
                JDictionary.this.newAvail_mouseExited(e);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JDictionary.this.lowerPanel.add(JDictionary.this.newAvail);
                JDictionary.this.setPluginSplitPaneDivider();
            }
        });
    }

    void savePrefs() {
        JDictionary.prefs.width = (int)this.getSize().getWidth();
        JDictionary.prefs.height = (int)this.getSize().getHeight();
        JDictionary.prefs.dividerLocation = this.outputSplitPane.getDividerLocation();
        Prefs.savePrefs(prefs, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getSavedDir()))).append(JDictionary.getFileSeparator()).append(JDictionary.getString("SavedPrefsFileName")))));
    }

    Prefs loadPrefs() {
        return Prefs.loadPrefs(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getSavedDir()))).append(JDictionary.getFileSeparator()).append(JDictionary.getString("SavedPrefsFileName")))));
    }

    public TreeGen getTreeGen() {
        return this.treeGen;
    }

    void restoresavedScreenState() {
        ((Component)this).setSize(new Dimension(JDictionary.prefs.width, JDictionary.prefs.height));
        this.outputSplitPane.setDividerLocation(JDictionary.prefs.dividerLocation);
    }

    void setPluginSplitPaneDivider() {
        this.pluginSplitPane.setDividerLocation(this.pluginSplitPane.getMaximumDividerLocation());
    }

    public static Prefs getPrefs() {
        return prefs;
    }

    public static String getString(String key) {
        if (JDictionaryResources == null) {
            JDictionaryResources = ResourceBundle.getBundle("info.jdictionary.resource.JDictionaryResources", new Locale("en", "en"));
        }
        return JDictionaryResources.getString(key);
    }

    public static String getGlobalPluginDirPath() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getBaseDir()))).append(JDictionary.getFileSeparator()).append(JDictionary.getString("PluginDirName"))));
    }

    public static float getJDictionaryVersion() {
        return Float.parseFloat(JDictionary.getString("JDictionaryVersion"));
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getBaseDir() {
        return System.getProperty("user.dir");
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getLanguage() {
        return System.getProperty("user.language");
    }

    public static String getSavedDir() {
        File dir = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getUserHome()))).append(JDictionary.getFileSeparator()).append(JDictionary.getString("SavedDirName")))));
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdir();
        }
        return dir.getAbsolutePath();
    }

    public static String getPluginDirPath() {
        File dir = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getSavedDir()))).append(JDictionary.getFileSeparator()).append(JDictionary.getString("PluginDirName")))));
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdir();
        }
        return dir.getAbsolutePath();
    }

    void pluginTree_valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode selectedNode;
        DefaultMutableTreeNode node = selectedNode = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
        if (selectedNode.isRoot()) {
            this.showSplashScreen();
            return;
        }
        NamedTabbedPane outputTabbedPane = null;
        while (node.isLeaf()) {
            node = (DefaultMutableTreeNode)node.getParent();
        }
        if (node instanceof AdvDefaultMutableTreeNode) {
            JDictionary.prefs.pluginInfoSheet = ((AdvDefaultMutableTreeNode)node).getInfoSheet();
            JDictionary.prefs.selectedNodeName = null;
        }
        if (node.getUserObject() instanceof NamedTabbedPane) {
            outputTabbedPane = (NamedTabbedPane)node.getUserObject();
            if (outputTabbedPane != this.outputPanel.getComponent(0)) {
                this.outputPanel.removeAll();
                this.outputPanel.add(outputTabbedPane);
                this.outputPanel.validate();
                this.outputPanel.repaint();
                this.nodeRepresentedByOutputTabbedPane = node;
            }
        } else {
            outputTabbedPane = this.buildOutputTabbedPane(node);
            this.outputPanel.removeAll();
            this.outputPanel.add(outputTabbedPane);
            this.outputPanel.validate();
            node.setUserObject(outputTabbedPane);
        }
        if (selectedNode.isLeaf()) {
            outputTabbedPane.setSelectedIndex(outputTabbedPane.indexOfTab(selectedNode.toString()));
            JDictionary.prefs.selectedNodeName = selectedNode.toString();
        }
    }

    void outputTabbedPane_stateChanged(ChangeEvent e) {
        NamedTabbedPane outputTabbedPane = (NamedTabbedPane)e.getSource();
        int selectedIndex = outputTabbedPane.getSelectedIndex();
        TreePath path = new TreePath(this.nodeRepresentedByOutputTabbedPane.getPath());
        this.pluginTree.expandPath(path);
        this.pluginTree.setSelectionRow(this.pluginTree.getRowForPath(path) + selectedIndex + 1);
        this.startPlugin(outputTabbedPane);
    }

    void jDictionaryResized(ComponentEvent e) {
        this.setPluginSplitPaneDivider();
        Dimension dim = this.getSize();
        if (dim.getWidth() < (double)620 || dim.getHeight() < (double)385) {
            if (dim.getWidth() < (double)620) {
                dim.width = 620;
            }
            if (dim.getHeight() < (double)385) {
                dim.height = 385;
            }
            ((Component)this).setSize(dim);
        }
    }

    void downloadButton_actionPerformed(ActionEvent e) {
        this.showPluginDownloader();
    }

    void activateButton_actionPerformed(ActionEvent e) {
        this.showPluginStatusChanger();
    }

    void rescanButton_actionPerformed(ActionEvent e) {
        this.rescanPlugins();
    }

    void rescanLabel_mousePressed(MouseEvent e) {
        this.rescanPlugins();
    }

    void rescanLabel_mouseEntered(MouseEvent e) {
        this.rescanLabel.setForeground(new Color(235, 161, 66));
    }

    void rescanLabel_mouseExited(MouseEvent e) {
        this.rescanLabel.setForeground(Color.black);
    }

    void downloadLabel_mousePressed(MouseEvent e) {
        this.showPluginDownloader();
    }

    void downloadLabel_mouseEntered(MouseEvent e) {
        this.downloadLabel.setForeground(new Color(235, 161, 66));
    }

    void downloadLabel_mouseExited(MouseEvent e) {
        this.downloadLabel.setForeground(Color.black);
    }

    void activateLabel_mousePressed(MouseEvent e) {
        this.showPluginStatusChanger();
    }

    void activateLabel_mouseEntered(MouseEvent e) {
        this.activateLabel.setForeground(new Color(235, 161, 66));
    }

    void activateLabel_mouseExited(MouseEvent e) {
        this.activateLabel.setForeground(Color.black);
    }

    void newAvail_mousePressed(MouseEvent e) {
        if (this.newVersionInfoPanel == null) {
            this.newVersionInfoPanel = new NewVersionInfoPanel();
        }
        this.pluginTree.setSelectionPath(null);
        this.outputPanel.removeAll();
        this.outputPanel.add(this.newVersionInfoPanel);
        this.outputPanel.validate();
        this.outputPanel.repaint();
    }

    void newAvail_mouseEntered(MouseEvent e) {
        this.newAvail.setForeground(new Color(235, 161, 66));
    }

    void newAvail_mouseExited(MouseEvent e) {
        this.newAvail.setForeground(Color.black);
    }

    void aboutMenuItem_actionPerformed(ActionEvent e) {
        this.pluginTree.setSelectionPath(null);
        this.showSplashScreen();
    }

    void exitMenuItem_actionPerformed(ActionEvent e) {
        this.closeJDictionary();
    }

    void downloadMenuItem_actionPerformed(ActionEvent e) {
        this.showPluginDownloader();
    }

    void activateMenuItem_actionPerformed(ActionEvent e) {
        this.showPluginStatusChanger();
    }

    void rescanMenuItem_actionPerformed(ActionEvent e) {
        this.rescanPlugins();
    }
}

