/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary;

import info.jdictionary.DirFilter;
import info.jdictionary.JDictionary;
import info.jdictionary.Plugin;
import info.jdictionary.Prefs;
import info.jdictionary.gui.AdvDefaultMutableTreeNode;
import info.jdictionary.pluginstuff.PluginInfoSheet;
import info.jdictionary.pluginstuff.PluginLoader;
import info.jdictionary.pluginstuff.PluginManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class TreeGen
extends Thread {
    final JTree tree;
    DefaultMutableTreeNode top;
    AdvDefaultMutableTreeNode pluginFolderTreeNode;
    File baseDir;
    Prefs prefs;
    boolean autoSelect;

    public TreeGen(Prefs prefs, JTree pluginTree, boolean autoSelect) {
        this.autoSelect = autoSelect;
        this.prefs = prefs;
        this.tree = pluginTree;
        this.top = (DefaultMutableTreeNode)((DefaultTreeModel)pluginTree.getModel()).getRoot();
        this.baseDir = new File(JDictionary.getPluginDirPath());
        if (this.autoSelect && prefs.pluginInfoSheet == null) {
            this.autoSelect = false;
        }
    }

    public void run() {
        PluginManager.syncPluginFiles();
        this.cleanupTree();
        String[] baseDirFiles = null;
        boolean loadLastUsed = true;
        int i = 0;
        if (this.baseDir.isDirectory()) {
            baseDirFiles = this.baseDir.list(new DirFilter(".jar"));
        }
        while (i < baseDirFiles.length) {
            String fileNameToLoad = baseDirFiles[i];
            try {
                File f;
                if (loadLastUsed) {
                    loadLastUsed = false;
                    if (this.prefs.pluginInfoSheet != null && PluginManager.isItAvailable(this.prefs.pluginInfoSheet.getFileName(), true) && PluginManager.isItActive(this.prefs.pluginInfoSheet.getFileName())) {
                        fileNameToLoad = this.prefs.pluginInfoSheet.getFileName();
                        i = -1;
                    }
                }
                if (PluginManager.isThereNewerPluginFileAvailable(fileNameToLoad)) {
                    f = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getPluginDirPath()))).append(JDictionary.getFileSeparator()).append(fileNameToLoad))));
                    f.delete();
                    ++i;
                    continue;
                }
                if (!PluginManager.isItActive(fileNameToLoad)) {
                    ++i;
                    continue;
                }
                if (PluginManager.isPluginFileLoaded(fileNameToLoad)) {
                    System.out.println(String.valueOf(String.valueOf(new StringBuffer("Plugin ").append(fileNameToLoad).append(" is already loaded"))));
                    this.checkExpand(this.getNodeForFileName(fileNameToLoad));
                    ++i;
                    continue;
                }
                this.pluginFolderTreeNode = null;
                f = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.baseDir))).append("/").append(fileNameToLoad))));
                ZipFile jarFile = new ZipFile(f);
                System.out.println("\nTreeGen: Processing file: ".concat(String.valueOf(String.valueOf(jarFile.getName()))));
                if (jarFile != null) {
                    System.out.println("Loading InfoSheet from file named: ".concat(String.valueOf(String.valueOf(jarFile.getName()))));
                    final PluginInfoSheet sheet = PluginInfoSheet.CreateInfoSheet(jarFile);
                    if (sheet == null) {
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Unable 0to load InfoSheet from file named: ").append(jarFile.getName()).append(" Skipping..."))));
                        ++i;
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                    if (Float.parseFloat(sheet.getMinJDictionaryVersion()) > JDictionary.getJDictionaryVersion()) {
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Unable to load plugin named ").append(sheet.getName()).append(" (JDictionary version ").append(sheet.getMinJDictionaryVersion()).append(" or higher needed) Skipping..."))));
                        ++i;
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                    sheet.setFileName(fileNameToLoad);
                    sheet.setSize(new Long(this.getSize(jarFile)).toString());
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            TreeGen.this.pluginFolderTreeNode = new AdvDefaultMutableTreeNode(sheet);
                            ((DefaultTreeModel)TreeGen.this.tree.getModel()).insertNodeInto(TreeGen.this.pluginFolderTreeNode, TreeGen.this.top, 0);
                            TreeGen.this.tree.validate();
                            TreeGen.this.tree.repaint();
                        }
                    });
                    PluginLoader pluginLoader = new PluginLoader(jarFile.getName());
                    Enumeration<? extends ZipEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        String entryName = entries.nextElement().getName();
                        if (!entryName.endsWith("Plugin.class")) continue;
                        System.out.println("TreeGen: I want the PluginLoader to load the class named: ".concat(String.valueOf(String.valueOf(entryName))));
                        Class<?> pluginClass = pluginLoader.loadClass(entryName);
                        final Object plugin = pluginClass.newInstance();
                        if (!(plugin instanceof Plugin)) continue;
                        PluginManager.pushPlugin(sheet, (Plugin)plugin);
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                ((DefaultTreeModel)TreeGen.this.tree.getModel()).insertNodeInto(new DefaultMutableTreeNode(plugin), TreeGen.this.pluginFolderTreeNode, 0);
                                TreeGen.this.tree.validate();
                                TreeGen.this.tree.repaint();
                            }
                        });
                    }
                    this.checkExpand(this.pluginFolderTreeNode);
                }
                ++i;
                try {
                    jarFile.close();
                }
                catch (IOException ex) {
                    System.out.println("Unable to close jarFile");
                }
            }
            catch (Exception e) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("TreeGen: An error occurred while loading plugin named: ").append(fileNameToLoad).append(" Skipping..."))));
                e.printStackTrace();
                ++i;
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            ((DefaultTreeModel)TreeGen.this.tree.getModel()).removeNodeFromParent(TreeGen.this.pluginFolderTreeNode);
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void cleanupTree() {
        Object[] sheets = PluginManager.getSheets();
        for (int n = 0; n < sheets.length; ++n) {
            AdvDefaultMutableTreeNode node;
            PluginInfoSheet sheet = (PluginInfoSheet)sheets[n];
            String name = sheet.getFileName();
            if (!PluginManager.isItAvailable(name, true)) {
                PluginManager.removePlugin(sheet);
                node = this.getNodeForFileName(name);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            ((DefaultTreeModel)TreeGen.this.tree.getModel()).removeNodeFromParent(node);
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (!PluginManager.isThereNewerPluginFileAvailable(name) && PluginManager.isItActive(name)) continue;
            PluginManager.removePlugin(sheet);
            node = this.getNodeForFileName(name);
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ((DefaultTreeModel)TreeGen.this.tree.getModel()).removeNodeFromParent(node);
                    }
                });
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void checkExpand(AdvDefaultMutableTreeNode node) {
        this.tree.expandPath(new TreePath(this.top.getPath()));
        if (!this.autoSelect) {
            return;
        }
        if (node.getInfoSheet().getFileName().equals(this.prefs.pluginInfoSheet.getFileName())) {
            TreePath path = new TreePath(node.getPath());
            this.tree.expandPath(path);
            for (int n = 0; n < node.getChildCount(); ++n) {
                if (this.prefs.selectedNodeName == null || !node.getChildAt(n).toString().equals(this.prefs.selectedNodeName)) continue;
                this.tree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)node.getChildAt(n)).getPath()));
                this.autoSelect = false;
                return;
            }
            this.tree.setSelectionPath(path);
            this.autoSelect = false;
        }
    }

    long getSize(ZipFile zipFile) {
        File f = new File(zipFile.getName());
        return f.length();
    }

    AdvDefaultMutableTreeNode getNodeForFileName(String fileName) {
        AdvDefaultMutableTreeNode tempNode = null;
        for (int n = 0; n < this.top.getChildCount(); ++n) {
            tempNode = (AdvDefaultMutableTreeNode)this.top.getChildAt(n);
            if (!tempNode.getInfoSheet().getFileName().equals(fileName)) continue;
            return tempNode;
        }
        return null;
    }
}

