/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary.pluginstuff;

import info.jdictionary.FileDownloader;
import info.jdictionary.IconBank;
import info.jdictionary.ImageBank;
import info.jdictionary.JDictionary;
import info.jdictionary.gui.PluginInfoSheetPanel;
import info.jdictionary.pluginstuff.PluginDeployer;
import info.jdictionary.pluginstuff.PluginInfoSheet;
import info.jdictionary.pluginstuff.PluginManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class PluginDownloader
extends JPanel
implements Runnable {
    JDictionary jDictionary;
    ArrayList pluginInfoPanels = new ArrayList();
    JPanel jPanel1 = new JPanel();
    JPanel pluginInfoOutputPanel = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel informationPanel = new JPanel();
    JLabel jLabel1 = new JLabel();
    JLabel messageLabel;
    ImageIcon spacerLine = ImageBank.Spacer;
    ImageIcon headerImage = ImageBank.DownloadHeader;
    JScrollPane jScrollPane1 = new JScrollPane();
    JScrollPane jScrollPane2 = new JScrollPane();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    BoxLayout boxLayout1 = new BoxLayout(this, 1);
    BoxLayout boxLayout2 = new BoxLayout(this.pluginInfoOutputPanel, 1);
    BoxLayout boxLayout3 = new BoxLayout(this.informationPanel, 1);
    boolean success;

    public PluginDownloader(JDictionary jDictionary) {
        this.jDictionary = jDictionary;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.boxLayout1);
        this.setBackground(Color.white);
        this.setAlignmentX(0.0f);
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(400, 300));
        this.jPanel1.setLayout(this.borderLayout1);
        this.jPanel1.setBackground(Color.white);
        this.jPanel1.setAlignmentX(0.0f);
        this.jPanel1.setMinimumSize(new Dimension(300, 100));
        this.jPanel1.setPreferredSize(new Dimension(1000, 1000));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(JDictionary.getString("AvailPlugins")));
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jPanel2.setBackground(Color.white);
        this.jPanel2.setAlignmentX(0.0f);
        this.jPanel2.setMinimumSize(new Dimension(0, 80));
        this.jPanel2.setPreferredSize(new Dimension(0, 160));
        this.jPanel2.setLayout(this.borderLayout3);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(JDictionary.getString("Tips")));
        this.jPanel2.add(this.jScrollPane2);
        this.jLabel1.setBackground(Color.white);
        this.jLabel1.setMinimumSize(new Dimension(300, 65));
        this.jLabel1.setPreferredSize(new Dimension(500, 65));
        this.jLabel1.setIcon(this.headerImage);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.getViewport().setBackground(Color.white);
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.getViewport().add((Component)this.informationPanel, null);
        this.jScrollPane1.getViewport().add((Component)this.pluginInfoOutputPanel, null);
        this.pluginInfoOutputPanel.setBackground(Color.white);
        this.pluginInfoOutputPanel.setLayout(this.borderLayout2);
        this.informationPanel.setLayout(this.boxLayout3);
        this.informationPanel.setBackground(Color.white);
        this.addToInformationPanel(new JLabel(JDictionary.getString("DownloadTip1"), IconBank.bulb, 0));
        this.addToInformationPanel(new JLabel(JDictionary.getString("DownloadTip2"), IconBank.bulb, 0));
        this.add(Box.createRigidArea(new Dimension(0, 3)));
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.jPanel1, null);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add((Component)this.jPanel2, null);
    }

    public void addToOutputPanel(String message, ImageIcon icon) {
        this.messageLabel = new JLabel(message, icon, 0);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PluginDownloader.this.pluginInfoOutputPanel.removeAll();
                PluginDownloader.this.pluginInfoOutputPanel.add(PluginDownloader.this.messageLabel);
                PluginDownloader.this.pluginInfoOutputPanel.validate();
            }
        });
    }

    public void run() {
        this.addToOutputPanel(JDictionary.getString("DownloadingInfos"), IconBank.hourGlass);
        Object[] sheets = this.downloadPluginInfoSheets();
        if (sheets != null) {
            this.showPluginInfos(sheets);
            this.addToInformationPanel(new JLabel(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("AvailPluginsPref")))).append(sheets.length).append(JDictionary.getString("AvailPluginsPostf")))), IconBank.info, 0));
            this.success = true;
        } else {
            this.addToOutputPanel(JDictionary.getString("NetError"), IconBank.caution);
            this.addToInformationPanel(new JLabel(JDictionary.getString("PossibleProblems"), IconBank.caution, 0));
            this.addToInformationPanel(new JLabel(JDictionary.getString("Problem1")));
            this.addToInformationPanel(new JLabel(JDictionary.getString("Problem2/1")));
            this.addToInformationPanel(new JLabel(JDictionary.getString("Problem2/2")));
            this.addToInformationPanel(new JLabel(JDictionary.getString("Problem3")));
            this.addToInformationPanel(new JLabel(JDictionary.getString("DownloadTip3"), IconBank.bulb, 0));
        }
    }

    Object[] downloadPluginInfoSheets() {
        URL url = null;
        Object[] sheets = null;
        try {
            url = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("PluginServerURL")))).append("/").append(JDictionary.getString("InfoSheetsFile")).append("_").append(JDictionary.getLanguage()))));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        sheets = PluginInfoSheet.CreateInfoSheets(url);
        if (sheets != null) {
            return sheets;
        }
        try {
            url = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("PluginServerURL")))).append("/").append(JDictionary.getString("InfoSheetsFile")))));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        sheets = PluginInfoSheet.CreateInfoSheets(url);
        return sheets;
    }

    void showPluginInfos(final Object[] sheets) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PluginDownloader.this.pluginInfoOutputPanel.removeAll();
                PluginDownloader.this.pluginInfoOutputPanel.setLayout(PluginDownloader.this.boxLayout2);
                for (int n = 0; n < sheets.length; ++n) {
                    PluginInfoAndDownloadPanel pluginInfoAndDownloadPanel = new PluginInfoAndDownloadPanel(PluginDownloader.this.jDictionary, (PluginInfoSheet)sheets[n]);
                    PluginDownloader.this.pluginInfoOutputPanel.add(pluginInfoAndDownloadPanel);
                    PluginDownloader.this.pluginInfoPanels.add(pluginInfoAndDownloadPanel);
                    if (n >= sheets.length - 1) continue;
                    JLabel spacer = new JLabel(PluginDownloader.this.spacerLine);
                    spacer.setPreferredSize(new Dimension(200, 1));
                    PluginDownloader.this.pluginInfoOutputPanel.add(spacer);
                }
                PluginDownloader.this.pluginInfoOutputPanel.validate();
                PluginDownloader.this.jScrollPane1.validate();
            }
        });
    }

    void addToInformationPanel(final JLabel label) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                label.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
                PluginDownloader.this.informationPanel.add(label);
                PluginDownloader.this.jScrollPane2.validate();
                PluginDownloader.this.jScrollPane2.getVerticalScrollBar().setValue(PluginDownloader.this.jScrollPane2.getVerticalScrollBar().getMaximum());
            }
        });
    }

    public void updateInfoPanelsState() {
        for (int n = 0; n < this.pluginInfoPanels.size(); ++n) {
            ((PluginInfoAndDownloadPanel)this.pluginInfoPanels.get(n)).updateState();
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    class PluginInfoAndDownloadPanel
    extends JPanel {
        JDictionary jDictionary;
        boolean downloading = false;
        boolean activated = true;
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        BoxLayout boxLayout1 = new BoxLayout(this, 0);
        BoxLayout boxLayout2 = new BoxLayout(this.jPanel1, 1);
        BoxLayout boxLayout3 = new BoxLayout(this.jPanel3, 1);
        JButton button = new JButton();
        PluginInfoSheet sheet;
        PluginInfoSheetPanel sheetPanel;
        Downloader downloader;
        JProgressBar progressBar;

        public PluginInfoAndDownloadPanel(JDictionary jDictionary, PluginInfoSheet sheet) {
            this.jDictionary = jDictionary;
            this.sheet = sheet;
            this.sheetPanel = new PluginInfoSheetPanel(sheet);
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateState();
        }

        private void jbInit() throws Exception {
            this.setBackground(new Color(255, 255, 255));
            this.setPreferredSize(new Dimension(370, 85));
            this.setMinimumSize(new Dimension(300, 85));
            this.setLayout(this.boxLayout1);
            this.setBorder(BorderFactory.createEmptyBorder(10, 3, 10, 3));
            this.setAlignmentX(0.0f);
            this.jPanel1.setBackground(new Color(255, 255, 255));
            this.jPanel1.setPreferredSize(new Dimension(160, 55));
            this.jPanel1.setLayout(this.boxLayout2);
            this.jPanel2.setBackground(new Color(255, 255, 255));
            this.jPanel3.setBackground(new Color(255, 255, 255));
            this.jPanel3.setAlignmentX(0.0f);
            this.jPanel3.setLayout(this.boxLayout3);
            this.jScrollPane1.setPreferredSize(new Dimension(300, 70));
            this.jScrollPane1.setMinimumSize(new Dimension(100, 70));
            this.button.setAlignmentX(0.0f);
            this.button.setMargin(new Insets(0, 3, 0, 3));
            this.button.addActionListener(new ActionListener(this){
                private final /* synthetic */ PluginInfoAndDownloadPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.button_actionPerformed(e);
                }
            });
            this.jPanel1.add(this.jPanel3);
            this.jPanel1.add(Box.createVerticalGlue());
            this.jPanel1.add(this.button);
            this.jPanel2.add(this.jPanel1);
            this.add(this.jScrollPane1);
            this.add(this.jPanel2);
            this.jScrollPane1.getViewport().add((Component)this.sheetPanel, 0);
        }

        void startDownload() {
            PluginDownloader.this.addToInformationPanel(new JLabel(String.valueOf(String.valueOf(JDictionary.getString("DownloadingFile"))).concat(String.valueOf(String.valueOf(this.sheet.getName()))), IconBank.FolderIn, 0));
            this.downloading = true;
            this.showProgressBar();
            this.downloader = new Downloader();
            this.downloader.start();
            this.updateState();
        }

        void showProgressBar() {
            this.jPanel3.removeAll();
            this.progressBar = new JProgressBar(0, new Integer(this.sheet.getSize()));
            this.progressBar.setPreferredSize(new Dimension(this.button.getWidth(), this.button.getHeight()));
            this.progressBar.setStringPainted(true);
            this.jPanel3.add(this.progressBar);
            this.jPanel1.validate();
            this.jPanel1.repaint();
        }

        synchronized void updateState() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ PluginInfoAndDownloadPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (this.this$1.downloading) {
                        this.this$1.button.setIcon(IconBank.stop);
                        this.this$1.button.setText(JDictionary.getString("StopDownloading"));
                        this.this$1.jPanel1.validate();
                        this.this$1.jPanel1.repaint();
                        return;
                    }
                    this.this$1.jPanel3.removeAll();
                    this.this$1.activated = true;
                    if (this.this$1.sheet.getMinJDictionaryVersion() != null && Float.parseFloat(this.this$1.sheet.getMinJDictionaryVersion()) > JDictionary.getJDictionaryVersion()) {
                        JLabel label = new JLabel(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("JDict")))).append(this.this$1.sheet.getMinJDictionaryVersion()).append(JDictionary.getString("Needed")))), IconBank.info, 0);
                        label.setToolTipText(String.valueOf(String.valueOf(JDictionary.getString("PleseUpgr"))).concat(String.valueOf(String.valueOf(this.this$1.sheet.getMinJDictionaryVersion()))));
                        this.this$1.jPanel3.add(label);
                        this.this$1.button.setToolTipText(String.valueOf(String.valueOf(JDictionary.getString("PleseUpgr"))).concat(String.valueOf(String.valueOf(this.this$1.sheet.getMinJDictionaryVersion()))));
                        this.this$1.button.setText(JDictionary.getString("DownInst"));
                        this.this$1.button.setIcon(IconBank.FolderIn);
                        this.this$1.button.setEnabled(false);
                    } else if (PluginManager.isPluginFileLoaded(this.this$1.sheet.getFileName())) {
                        JLabel label = new JLabel(JDictionary.getString("AlreadyInstalled"), IconBank.info, 0);
                        this.this$1.jPanel3.add(label);
                        this.this$1.button.setText(JDictionary.getString("DownInst"));
                        this.this$1.button.setIcon(IconBank.FolderIn);
                        this.this$1.button.setEnabled(false);
                    } else if (PluginManager.isItAvailable(this.this$1.sheet.getFileName(), true)) {
                        this.this$1.activated = false;
                        JLabel label = new JLabel(JDictionary.getString("InstalledButDeactivated"), IconBank.info, 0);
                        this.this$1.jPanel3.add(label);
                        this.this$1.button.setText(JDictionary.getString("Activate"));
                        this.this$1.button.setIcon(IconBank.FolderIn);
                        this.this$1.button.setEnabled(true);
                    } else if (PluginManager.isItAvailable(this.this$1.sheet.getFileName(), false) && PluginManager.isThereNewerPluginFileAvailable(this.this$1.sheet.getFileName())) {
                        JLabel label = new JLabel(JDictionary.getString("YouHaveNewerVersion"), IconBank.info, 0);
                        this.this$1.jPanel3.add(label);
                        this.this$1.button.setText(JDictionary.getString("DownInst"));
                        this.this$1.button.setIcon(IconBank.FolderIn);
                        this.this$1.button.setEnabled(false);
                    } else {
                        JLabel label = PluginManager.isItAvailable(this.this$1.sheet.getFileName(), false) && !PluginManager.isThereNewerPluginFileAvailable(this.this$1.sheet.getFileName()) ? new JLabel(JDictionary.getString("NewerAvailable"), IconBank.info, 0) : new JLabel(JDictionary.getString("NotInstalled"), IconBank.info, 0);
                        this.this$1.jPanel3.add(label);
                        this.this$1.button.setText(JDictionary.getString("DownInst"));
                        this.this$1.button.setIcon(IconBank.FolderIn);
                        this.this$1.button.setEnabled(true);
                    }
                    this.this$1.jPanel1.validate();
                    this.this$1.jPanel1.repaint();
                }
            });
        }

        void button_actionPerformed(ActionEvent e) {
            if (!this.activated) {
                PluginManager.setActive(this.sheet.getFileName());
                new Thread(this){
                    private final /* synthetic */ PluginInfoAndDownloadPanel this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        try {
                            this.this$1.jDictionary.rescanPlugins(false).join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }.start();
                return;
            }
            if (this.downloading) {
                this.downloading = false;
                this.downloader.terminate();
                return;
            }
            this.startDownload();
        }

        class Downloader
        extends Thread {
            FileDownloader fileDownloader = new FileDownloader();
            PluginDeployer deployer = new PluginDeployer();
            byte[] b;
            URL url = null;
            int length;

            Downloader() {
            }

            public void terminate() {
                this.fileDownloader.terminate();
            }

            public void run() {
                try {
                    this.url = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("PluginServerURL")))).append("/").append(PluginInfoAndDownloadPanel.this.sheet.getFileName()))));
                    this.length = this.url.openConnection().getContentLength();
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.b = this.fileDownloader.download(this.url, PluginInfoAndDownloadPanel.this.progressBar, this.length);
                if (this.b != null) {
                    PluginDownloader.this.addToInformationPanel(new JLabel(String.valueOf(String.valueOf(JDictionary.getString("Installing"))).concat(String.valueOf(String.valueOf(PluginInfoAndDownloadPanel.this.sheet.getName()))), IconBank.info, 0));
                    this.deployer.deploy(this.b, PluginInfoAndDownloadPanel.this.sheet.getFileName());
                    PluginManager.setActive(PluginInfoAndDownloadPanel.this.sheet.getFileName());
                    try {
                        PluginInfoAndDownloadPanel.this.jDictionary.rescanPlugins(false).join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (PluginManager.isItInstalled(PluginInfoAndDownloadPanel.this.sheet)) {
                        PluginDownloader.this.addToInformationPanel(new JLabel(String.valueOf(String.valueOf(PluginInfoAndDownloadPanel.this.sheet.getName())).concat(String.valueOf(String.valueOf(JDictionary.getString("ReadyToUse")))), IconBank.ThumbUp, 0));
                    } else {
                        PluginDownloader.this.addToInformationPanel(new JLabel(String.valueOf(String.valueOf(JDictionary.getString("ErrorAtInstall"))).concat(String.valueOf(String.valueOf(PluginInfoAndDownloadPanel.this.sheet.getName()))), IconBank.caution, 0));
                    }
                } else if (this.fileDownloader.stop) {
                    PluginDownloader.this.addToInformationPanel(new JLabel(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("DownStopPref")))).append(PluginInfoAndDownloadPanel.this.sheet.getName()).append(JDictionary.getString("DownStopPost")))), IconBank.stop, 0));
                } else {
                    PluginDownloader.this.addToInformationPanel(new JLabel(String.valueOf(String.valueOf(JDictionary.getString("ErrorAtDownload"))).concat(String.valueOf(String.valueOf(PluginInfoAndDownloadPanel.this.sheet.getName()))), IconBank.caution, 0));
                }
                PluginInfoAndDownloadPanel.this.downloading = false;
                PluginInfoAndDownloadPanel.this.updateState();
            }
        }
    }
}

