/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary.pluginstuff;

import info.jdictionary.JDictionary;
import info.jdictionary.Plugin;
import info.jdictionary.pluginstuff.DirFilter;
import info.jdictionary.pluginstuff.PluginInfoSheet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipFile;

public class PluginManager {
    static HashMap plugins = new HashMap();

    public static void pushPlugin(PluginInfoSheet infoSheet, Plugin plugin) {
        if (!plugins.containsKey(infoSheet)) {
            plugins.put(infoSheet, new ArrayList());
        }
        ((ArrayList)plugins.get(infoSheet)).add(plugin);
    }

    public static ArrayList getPlugin(PluginInfoSheet infoSheet) {
        if (plugins.containsKey(infoSheet)) {
            return (ArrayList)plugins.get(infoSheet);
        }
        return null;
    }

    public static void removePlugin(PluginInfoSheet infoSheet) {
        Iterator it = ((AbstractList)PluginManager.getPlugin(infoSheet)).iterator();
        while (it.hasNext()) {
            ((Plugin)it.next()).stop();
        }
        plugins.remove(infoSheet);
    }

    public static void removeAllPlugins() {
        Object[] sheets = PluginManager.getSheets();
        int n = 0;
        while (n < sheets.length) {
            PluginManager.removePlugin((PluginInfoSheet)sheets[n++]);
        }
    }

    public static Object[] getSheets() {
        return plugins.keySet().toArray();
    }

    public static int getNumberOfLoadedPlugins() {
        return plugins.size();
    }

    public static int getNumberOfAvailablePlugins() {
        return PluginManager.getAvailablePluginFileNames().length;
    }

    public static String[] getAvailablePluginFileNames() {
        File f = new File(JDictionary.getPluginDirPath());
        return f.list(new DirFilter(".jar"));
    }

    public static ZipFile[] getAvailablePluginFiles() {
        String[] fileNames = PluginManager.getAvailablePluginFileNames();
        ZipFile[] pluginFiles = new ZipFile[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            try {
                ZipFile z = new ZipFile(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getPluginDirPath()))).append(JDictionary.getFileSeparator()).append(fileNames[i]))));
                System.out.println(z.getName());
                pluginFiles[i] = z;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return pluginFiles;
    }

    public static boolean isItInstalled(PluginInfoSheet infoSheet) {
        Iterator sheetsIterator = plugins.keySet().iterator();
        while (sheetsIterator.hasNext()) {
            PluginInfoSheet tempSheet = (PluginInfoSheet)sheetsIterator.next();
            if (!infoSheet.getFileName().equals(tempSheet.getFileName()) || PluginManager.extractVersionNumberFromFileName(infoSheet.getFileName()) != PluginManager.extractVersionNumberFromFileName(tempSheet.getFileName())) continue;
            return true;
        }
        return false;
    }

    public static float getNewestVersion(PluginInfoSheet infoSheet) {
        Iterator sheetsIterator = plugins.keySet().iterator();
        float newestVersion = 0.0f;
        while (sheetsIterator.hasNext()) {
            PluginInfoSheet tempSheet = (PluginInfoSheet)sheetsIterator.next();
            if (!infoSheet.getFileName().equals(tempSheet.getFileName()) || !(Float.parseFloat(tempSheet.getVersion()) > newestVersion)) continue;
            newestVersion = Float.parseFloat(tempSheet.getVersion());
        }
        return newestVersion;
    }

    public static float extractVersionNumberFromFileName(String fileName) {
        int s = fileName.lastIndexOf("-");
        int e = fileName.lastIndexOf(".jar");
        if (s > -1 && s < e) {
            return Float.parseFloat(new String(fileName.substring(s + 1, e)).replace('_', '.'));
        }
        return 0.0f;
    }

    public static String getNameWithoutVersion(String fileName) {
        int s = fileName.lastIndexOf("-");
        if (s > -1) {
            return fileName.substring(0, s);
        }
        s = fileName.lastIndexOf(".jar");
        if (s > -1) {
            return fileName.substring(0, s);
        }
        return fileName;
    }

    public static boolean isPluginFileLoaded(String fileName) {
        Object[] sheets = PluginManager.getSheets();
        for (int n = 0; n < sheets.length; ++n) {
            String name = ((PluginInfoSheet)sheets[n]).getFileName();
            if (!name.equals(fileName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItActive(String fileName) {
        String name = PluginManager.getNameWithoutVersion(fileName);
        Iterator it = ((AbstractList)JDictionary.getPrefs().InActivePlugins).iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).equals(name)) continue;
            return false;
        }
        return true;
    }

    public static void setActive(String fileName) {
        String name = PluginManager.getNameWithoutVersion(fileName);
        ((AbstractCollection)JDictionary.getPrefs().InActivePlugins).remove(name);
    }

    public static void setInActive(String fileName) {
        String name = PluginManager.getNameWithoutVersion(fileName);
        JDictionary.getPrefs().InActivePlugins.add(name);
    }

    public static void cleanUpInactivePluginList() {
        Iterator inactivePlugins = ((AbstractList)JDictionary.getPrefs().InActivePlugins).iterator();
        while (inactivePlugins.hasNext()) {
            if (PluginManager.isItAvailable(inactivePlugins.next().toString(), false)) continue;
            inactivePlugins.remove();
        }
    }

    public static boolean isThereNewerPluginFileAvailable(String fileName) {
        String[] pluginDir = PluginManager.getAvailablePluginFileNames();
        float version = PluginManager.extractVersionNumberFromFileName(fileName);
        for (int i = 0; i < pluginDir.length; ++i) {
            float tempVersion;
            if (!PluginManager.getNameWithoutVersion(pluginDir[i]).equals(PluginManager.getNameWithoutVersion(fileName)) || !((tempVersion = PluginManager.extractVersionNumberFromFileName(pluginDir[i])) > version)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItAvailable(String fileName, boolean careWithVersion) {
        String[] fileNames = PluginManager.getAvailablePluginFileNames();
        for (int i = 0; i < fileNames.length; ++i) {
            if (!(careWithVersion ? fileNames[i].equals(fileName) : PluginManager.getNameWithoutVersion(fileNames[i]).equals(PluginManager.getNameWithoutVersion(fileName)))) continue;
            return true;
        }
        return false;
    }

    public static void syncPluginFiles() {
        File f = new File(JDictionary.getGlobalPluginDirPath());
        String[] globalPluginDirFiles = f.list();
        for (int i = 0; i < globalPluginDirFiles.length; ++i) {
            if (PluginManager.isItAvailable(globalPluginDirFiles[i], true) || PluginManager.isItAvailable(globalPluginDirFiles[i], false) && PluginManager.isThereNewerPluginFileAvailable(globalPluginDirFiles[i])) continue;
            File sourceFile = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getGlobalPluginDirPath()))).append(JDictionary.getFileSeparator()).append(globalPluginDirFiles[i]))));
            try {
                FileInputStream sourceStream = new FileInputStream(sourceFile);
                int offset = 0;
                int loadedBytesCount = 0;
                int fileLength = (int)sourceFile.length();
                byte[] b = new byte[fileLength];
                while (loadedBytesCount < fileLength) {
                    if ((loadedBytesCount = sourceStream.read(b, offset += loadedBytesCount, fileLength -= loadedBytesCount)) != -1) continue;
                    System.err.println("PluginLoader.syncPluginFiles(): Wrong thing happened when I attempted to copy the file named: ".concat(String.valueOf(String.valueOf(sourceFile.getName()))));
                }
                File destFile = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getPluginDirPath()))).append(JDictionary.getFileSeparator()).append(globalPluginDirFiles[i]))));
                FileOutputStream outStream = new FileOutputStream(destFile);
                System.out.println("PluginLoader.syncPluginFiles(): writing: ".concat(String.valueOf(String.valueOf(destFile.getName()))));
                outStream.write(b);
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        PluginManager.cleanUpInactivePluginList();
    }
}

