/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary;

import info.jdictionary.DefaultFrameAssembler;
import info.jdictionary.JDictionaryFrame;
import info.jdictionary.NewJDictionaryVersionChecker;
import info.jdictionary.Prefs;
import info.jdictionary.gui.AboutPanel;
import info.jdictionary.gui.AllPluginsDeactivatedPanel;
import info.jdictionary.gui.NoPluginsPanel;
import info.jdictionary.pluginstuff.PluginDownloader;
import info.jdictionary.pluginstuff.PluginManager;
import info.jdictionary.pluginstuff.PluginStatusChanger;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JDictionary
extends JFrame {
    public static ResourceBundle JDictionaryResources;
    private Prefs prefs;
    private PluginManager pluginManager;
    private PluginDownloader pluginDownloader;
    private PluginStatusChanger pluginStatusChanger;
    private JDictionaryFrame frame;
    private DefaultFrameAssembler assembler;
    private NewJDictionaryVersionChecker newJDictionaryVersionChecker = new NewJDictionaryVersionChecker();

    public JDictionary() {
        this.prefs = this.loadPrefs();
        this.frame = new JDictionaryFrame();
        this.pluginManager = new PluginManager(this);
        this.assembler = new DefaultFrameAssembler(this, this.frame);
        this.newJDictionaryVersionChecker.start();
        this.pluginManager.scanPlugins();
    }

    public JPanel getSplashScreen() {
        return new AboutPanel();
    }

    public JPanel getNoPluginInstalledScreen() {
        return new NoPluginsPanel();
    }

    public JPanel getAllPluginsDeactivatedScreen() {
        return new AllPluginsDeactivatedPanel();
    }

    public PluginStatusChanger getPluginStatusChanger() {
        if (this.pluginStatusChanger == null) {
            this.pluginStatusChanger = new PluginStatusChanger(this);
            Thread pluginStatusChangerThread = new Thread(this.pluginStatusChanger);
            pluginStatusChangerThread.start();
        }
        return this.pluginStatusChanger;
    }

    public PluginDownloader getPluginDownloader() {
        if (this.pluginDownloader == null || !this.pluginDownloader.isSuccess()) {
            this.pluginDownloader = new PluginDownloader(this);
            Thread pluginDownloaderThread = new Thread(this.pluginDownloader);
            pluginDownloaderThread.start();
        }
        return this.pluginDownloader;
    }

    public NewJDictionaryVersionChecker getNewJDictionaryVersionChecker() {
        return this.newJDictionaryVersionChecker;
    }

    public JDictionary getJDictionary() {
        return this;
    }

    public void closeJDictionary() {
        this.savePrefs();
        this.pluginManager.removeAllPlugins();
        System.exit(0);
    }

    public void savePrefs() {
        this.assembler.savePrefs();
        Prefs.savePrefs(this.prefs, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getSavedDir()))).append(JDictionary.getFileSeparator()).append(JDictionary.getString("SavedPrefsFileName")))));
    }

    public Prefs loadPrefs() {
        return Prefs.loadPrefs(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getSavedDir()))).append(JDictionary.getFileSeparator()).append(JDictionary.getString("SavedPrefsFileName")))));
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public static void main(String[] args) {
        JDictionary jDictionary = new JDictionary();
    }

    public static String getString(String key) {
        if (JDictionaryResources == null) {
            JDictionaryResources = ResourceBundle.getBundle("info.jdictionary.resource.JDictionaryResources", new Locale("en", "en"));
        }
        return JDictionaryResources.getString(key);
    }

    public static String getGlobalPluginDirPath() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getBaseDir()))).append(JDictionary.getFileSeparator()).append(JDictionary.getString("PluginDirName"))));
    }

    public static float getJDictionaryVersion() {
        return Float.parseFloat(JDictionary.getString("JDictionaryVersion"));
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getBaseDir() {
        return System.getProperty("user.dir");
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getLanguage() {
        return System.getProperty("user.language");
    }

    public static String getSavedDir() {
        File dir = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getUserHome()))).append(JDictionary.getFileSeparator()).append(JDictionary.getString("SavedDirName")))));
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdir();
        }
        return dir.getAbsolutePath();
    }

    public static String getPluginDirPath() {
        File dir = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getSavedDir()))).append(JDictionary.getFileSeparator()).append(JDictionary.getString("PluginDirName")))));
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdir();
        }
        return dir.getAbsolutePath();
    }
}

