/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng;

import com.thaiopensource.relaxng.AbstractSchema;
import com.thaiopensource.relaxng.IncorrectSchemaException;
import com.thaiopensource.relaxng.Schema;
import com.thaiopensource.relaxng.XMLReaderCreator;
import com.thaiopensource.relaxng.impl.CombineSchema;
import com.thaiopensource.relaxng.impl.IdTypeMap;
import com.thaiopensource.relaxng.impl.IdTypeMapBuilder;
import com.thaiopensource.relaxng.impl.IdTypeMapSchema;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternSchema;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.relaxng.parse.compact.CompactParseable;
import com.thaiopensource.relaxng.parse.sax.SAXParseable;
import java.io.IOException;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaFactory {
    private XMLReaderCreator xrc = null;
    private ErrorHandler eh = null;
    private DatatypeLibraryFactory dlf = null;
    private boolean checkIdIdref = false;
    private boolean compactSyntax = false;

    public Schema createSchema(InputSource inputSource) throws IOException, SAXException, IncorrectSchemaException {
        SchemaPatternBuilder schemaPatternBuilder = new SchemaPatternBuilder();
        Parseable parseable = this.compactSyntax ? new CompactParseable(inputSource, this.eh) : new SAXParseable(this.xrc, inputSource, this.eh);
        Pattern pattern = SchemaBuilderImpl.parse(parseable, this.eh, this.dlf, schemaPatternBuilder);
        AbstractSchema abstractSchema = new PatternSchema(schemaPatternBuilder, pattern);
        if (schemaPatternBuilder.hasIdTypes() && this.checkIdIdref) {
            IdTypeMap idTypeMap = new IdTypeMapBuilder(this.eh, pattern).getIdTypeMap();
            if (idTypeMap == null) {
                throw new IncorrectSchemaException();
            }
            abstractSchema = new CombineSchema(abstractSchema, new IdTypeMapSchema(idTypeMap));
        }
        return abstractSchema;
    }

    public void setXMLReaderCreator(XMLReaderCreator xMLReaderCreator) {
        this.xrc = xMLReaderCreator;
    }

    public XMLReaderCreator getXMLReaderCreator() {
        return this.xrc;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.eh = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.eh;
    }

    public void setDatatypeLibraryFactory(DatatypeLibraryFactory datatypeLibraryFactory) {
        this.dlf = datatypeLibraryFactory;
    }

    public DatatypeLibraryFactory getDatatypeLibraryFactory() {
        return this.dlf;
    }

    public void setCheckIdIdref(boolean bl) {
        this.checkIdIdref = bl;
    }

    public boolean getCheckIdIdref() {
        return this.checkIdIdref;
    }

    public void setCompactSyntax(boolean bl) {
        this.compactSyntax = bl;
    }

    public boolean getCompactSyntax() {
        return this.compactSyntax;
    }
}

