/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.Name;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NameClassVisitor;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.relaxng.datatype.Datatype;

public class PatternDumper {
    private boolean startTagOpen = false;
    private Vector tagStack = new Vector();
    private PrintWriter writer;
    private int level = 0;
    private boolean suppressIndent = false;
    private Vector patternList = new Vector();
    private Hashtable patternTable = new Hashtable();
    PatternVisitor patternVisitor = new DumpPatternVisitor();
    PatternVisitor groupPatternVisitor = new GroupDumpPatternVisitor();
    PatternVisitor choicePatternVisitor = new ChoiceDumpPatternVisitor();
    PatternVisitor interleavePatternVisitor = new InterleaveDumpPatternVisitor();
    NameClassVisitor nameClassVisitor = new DumpNameClassVisitor();
    NameClassVisitor choiceNameClassVisitor = new ChoiceDumpNameClassVisitor();
    NameClassVisitor differenceNameClassVisitor = new DifferenceDumpNameClassVisitor();
    private static final String relaxng10URI = "http://relaxng.org/ns/structure/1.0";

    public static void dump(PrintWriter printWriter, Pattern pattern) {
        new PatternDumper(printWriter).dump(pattern);
    }

    public static void dump(OutputStream outputStream, Pattern pattern) {
        new PatternDumper(new PrintWriter(outputStream)).dump(pattern);
    }

    PatternDumper(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    void dump(Pattern pattern) {
        this.write("<?xml version=\"1.0\"?>");
        this.startElement("grammar");
        this.attribute("xmlns", relaxng10URI);
        this.startElement("start");
        pattern.accept(this.groupPatternVisitor);
        this.endElement();
        int n = 0;
        while (n < this.patternList.size()) {
            this.startElement("define");
            Pattern pattern2 = (Pattern)this.patternList.elementAt(n);
            this.attribute("name", this.getName(pattern2));
            pattern2.accept(this.groupPatternVisitor);
            this.endElement();
            ++n;
        }
        this.endElement();
        this.writer.println();
        this.writer.flush();
    }

    String getName(Pattern pattern) {
        String string = (String)this.patternTable.get(pattern);
        if (string == null) {
            string = "p" + this.patternList.size();
            this.patternList.addElement(pattern);
            this.patternTable.put(pattern, string);
        }
        return string;
    }

    void startElement(String string) {
        this.closeStartTag();
        this.indent(this.level);
        this.write('<');
        this.write(string);
        this.push(string);
        this.startTagOpen = true;
        ++this.level;
    }

    void closeStartTag() {
        if (this.startTagOpen) {
            this.startTagOpen = false;
            this.write('>');
        }
    }

    void attribute(String string, String string2) {
        this.write(' ');
        this.write(string);
        this.write('=');
        this.write('\"');
        this.chars(string2, true);
        this.write('\"');
    }

    void data(String string) {
        if (string.length() > 0) {
            this.closeStartTag();
            this.chars(string, false);
            this.suppressIndent = true;
        }
    }

    void chars(String string, boolean bl) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '&': {
                    this.write("&amp;");
                    break;
                }
                case '<': {
                    this.write("&lt;");
                    break;
                }
                case '>': {
                    this.write("&gt;");
                    break;
                }
                case '\"': {
                    if (bl) {
                        this.write("&quot;");
                        break;
                    }
                }
                default: {
                    this.write(c);
                }
            }
            ++n2;
        }
    }

    void endElement() {
        --this.level;
        if (this.startTagOpen) {
            this.startTagOpen = false;
            this.write("/>");
            this.pop();
        } else {
            if (!this.suppressIndent) {
                this.indent(this.level);
            }
            this.write("</");
            this.write(this.pop());
            this.write(">");
        }
        this.suppressIndent = false;
    }

    void indent(int n) {
        this.writer.println();
        int n2 = 0;
        while (n2 < n) {
            this.write("  ");
            ++n2;
        }
    }

    void write(String string) {
        this.writer.print(string);
    }

    void write(char c) {
        this.writer.print(c);
    }

    void push(String string) {
        this.tagStack.addElement(string);
    }

    String pop() {
        String string = (String)this.tagStack.lastElement();
        this.tagStack.setSize(this.tagStack.size() - 1);
        return string;
    }

    class DifferenceDumpNameClassVisitor
    extends DumpNameClassVisitor {
        DifferenceDumpNameClassVisitor() {
        }

        public void visitDifference(NameClass nameClass, NameClass nameClass2) {
            nameClass.accept(this);
            nameClass2.accept(PatternDumper.this.nameClassVisitor);
        }
    }

    class ChoiceDumpNameClassVisitor
    extends DumpNameClassVisitor {
        ChoiceDumpNameClassVisitor() {
        }

        public void visitChoice(NameClass nameClass, NameClass nameClass2) {
            nameClass.accept(this);
            nameClass2.accept(this);
        }
    }

    class DumpNameClassVisitor
    implements NameClassVisitor {
        DumpNameClassVisitor() {
        }

        public void visitChoice(NameClass nameClass, NameClass nameClass2) {
            PatternDumper.this.startElement("choice");
            nameClass.accept(PatternDumper.this.choiceNameClassVisitor);
            nameClass2.accept(PatternDumper.this.choiceNameClassVisitor);
            PatternDumper.this.endElement();
        }

        public void visitNsName(String string) {
            PatternDumper.this.startElement("nsName");
            PatternDumper.this.attribute("ns", string);
            PatternDumper.this.endElement();
        }

        public void visitNsNameExcept(String string, NameClass nameClass) {
            PatternDumper.this.startElement("nsName");
            PatternDumper.this.startElement("except");
            nameClass.accept(PatternDumper.this.choiceNameClassVisitor);
            PatternDumper.this.endElement();
            PatternDumper.this.endElement();
        }

        public void visitAnyName() {
            PatternDumper.this.startElement("anyName");
            PatternDumper.this.endElement();
        }

        public void visitAnyNameExcept(NameClass nameClass) {
            PatternDumper.this.startElement("anyName");
            PatternDumper.this.startElement("except");
            nameClass.accept(PatternDumper.this.choiceNameClassVisitor);
            PatternDumper.this.endElement();
            PatternDumper.this.endElement();
        }

        public void visitName(Name name) {
            PatternDumper.this.startElement("name");
            PatternDumper.this.attribute("ns", name.getNamespaceUri());
            PatternDumper.this.data(name.getLocalName());
            PatternDumper.this.endElement();
        }

        public void visitError() {
            PatternDumper.this.startElement("error");
            PatternDumper.this.endElement();
        }

        public void visitNull() {
            this.visitAnyName();
        }
    }

    class InterleaveDumpPatternVisitor
    extends DumpPatternVisitor {
        InterleaveDumpPatternVisitor() {
        }

        public void visitInterleave(Pattern pattern, Pattern pattern2) {
            pattern.accept(this);
            pattern2.accept(this);
        }
    }

    class ChoiceDumpPatternVisitor
    extends DumpPatternVisitor {
        ChoiceDumpPatternVisitor() {
        }

        public void visitChoice(Pattern pattern, Pattern pattern2) {
            pattern.accept(this);
            pattern2.accept(this);
        }
    }

    class GroupDumpPatternVisitor
    extends DumpPatternVisitor {
        GroupDumpPatternVisitor() {
        }

        public void visitGroup(Pattern pattern, Pattern pattern2) {
            pattern.accept(this);
            pattern2.accept(this);
        }
    }

    class DumpPatternVisitor
    implements PatternVisitor {
        DumpPatternVisitor() {
        }

        public void visitEmpty() {
            PatternDumper.this.startElement("empty");
            PatternDumper.this.endElement();
        }

        public void visitNotAllowed() {
            PatternDumper.this.startElement("notAllowed");
            PatternDumper.this.endElement();
        }

        public void visitError() {
            PatternDumper.this.startElement("error");
            PatternDumper.this.endElement();
        }

        public void visitGroup(Pattern pattern, Pattern pattern2) {
            PatternDumper.this.startElement("group");
            pattern.accept(PatternDumper.this.groupPatternVisitor);
            pattern2.accept(PatternDumper.this.groupPatternVisitor);
            PatternDumper.this.endElement();
        }

        public void visitInterleave(Pattern pattern, Pattern pattern2) {
            PatternDumper.this.startElement("interleave");
            pattern.accept(PatternDumper.this.interleavePatternVisitor);
            pattern2.accept(PatternDumper.this.interleavePatternVisitor);
            PatternDumper.this.endElement();
        }

        public void visitChoice(Pattern pattern, Pattern pattern2) {
            PatternDumper.this.startElement("choice");
            pattern.accept(PatternDumper.this.choicePatternVisitor);
            pattern2.accept(PatternDumper.this.choicePatternVisitor);
            PatternDumper.this.endElement();
        }

        public void visitOneOrMore(Pattern pattern) {
            PatternDumper.this.startElement("oneOrMore");
            pattern.accept(PatternDumper.this.groupPatternVisitor);
            PatternDumper.this.endElement();
        }

        public void visitElement(NameClass nameClass, Pattern pattern) {
            PatternDumper.this.startElement("element");
            nameClass.accept(PatternDumper.this.nameClassVisitor);
            PatternDumper.this.startElement("ref");
            PatternDumper.this.attribute("name", PatternDumper.this.getName(pattern));
            PatternDumper.this.endElement();
            PatternDumper.this.endElement();
        }

        public void visitAttribute(NameClass nameClass, Pattern pattern) {
            PatternDumper.this.startElement("attribute");
            nameClass.accept(PatternDumper.this.nameClassVisitor);
            pattern.accept(PatternDumper.this.patternVisitor);
            PatternDumper.this.endElement();
        }

        public void visitData(Datatype datatype) {
            PatternDumper.this.startElement("text");
            PatternDumper.this.endElement();
        }

        public void visitDataExcept(Datatype datatype, Pattern pattern) {
            PatternDumper.this.startElement("text");
            PatternDumper.this.endElement();
        }

        public void visitValue(Datatype datatype, Object object) {
            PatternDumper.this.startElement("value");
            PatternDumper.this.data(object.toString());
            PatternDumper.this.endElement();
        }

        public void visitText() {
            PatternDumper.this.startElement("text");
            PatternDumper.this.endElement();
        }

        public void visitList(Pattern pattern) {
            PatternDumper.this.startElement("list");
            pattern.accept(PatternDumper.this.groupPatternVisitor);
            PatternDumper.this.endElement();
        }
    }
}

