/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.parse.compact;

import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.IncludedGrammar;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.relaxng.parse.ParsedPattern;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.relaxng.parse.Scope;
import com.thaiopensource.relaxng.parse.compact.CompactSyntax;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class CompactParseable
implements Parseable {
    private final InputSource in;
    private final ErrorHandler eh;
    private static final String UTF8 = CompactParseable.fixupEncodingName("UTF-8", "UTF8");
    private static final String UTF16 = CompactParseable.fixupEncodingName("UTF-16", "Unicode");

    public CompactParseable(InputSource inputSource, ErrorHandler errorHandler) {
        this.in = inputSource;
        this.eh = errorHandler;
    }

    public ParsedPattern parse(SchemaBuilder schemaBuilder) throws BuildException, IllegalSchemaException {
        return new CompactSyntax(this.makeReader(this.in), this.in.getSystemId(), schemaBuilder, this.eh).parse(null);
    }

    public ParsedPattern parseInclude(String string, SchemaBuilder schemaBuilder, IncludedGrammar includedGrammar) throws BuildException, IllegalSchemaException {
        InputSource inputSource = new InputSource(string);
        inputSource.setEncoding(this.in.getEncoding());
        return new CompactSyntax(this.makeReader(inputSource), string, schemaBuilder, this.eh).parseInclude(includedGrammar);
    }

    public ParsedPattern parseExternal(String string, SchemaBuilder schemaBuilder, Scope scope) throws BuildException, IllegalSchemaException {
        InputSource inputSource = new InputSource(string);
        inputSource.setEncoding(this.in.getEncoding());
        return new CompactSyntax(this.makeReader(inputSource), string, schemaBuilder, this.eh).parse(scope);
    }

    private Reader makeReader(InputSource inputSource) throws BuildException {
        try {
            Reader reader = inputSource.getCharacterStream();
            if (reader == null) {
                String string;
                InputStream inputStream = inputSource.getByteStream();
                if (inputStream == null) {
                    string = inputSource.getSystemId();
                    inputStream = new URL(string).openStream();
                }
                if ((string = inputSource.getEncoding()) == null) {
                    PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 2);
                    string = CompactParseable.detectEncoding(pushbackInputStream);
                    inputStream = pushbackInputStream;
                }
                reader = new InputStreamReader(inputStream, string);
            }
            return reader;
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    private static String detectEncoding(PushbackInputStream pushbackInputStream) throws IOException {
        String string = UTF8;
        int n = pushbackInputStream.read();
        if (n != -1) {
            int n2 = pushbackInputStream.read();
            if (n2 != -1) {
                pushbackInputStream.unread(n2);
                if (n == 255 && n2 == 254 || n == 254 && n2 == 255) {
                    string = UTF16;
                }
            }
            pushbackInputStream.unread(n);
        }
        return string;
    }

    private static String fixupEncodingName(String string, String string2) {
        try {
            "x".getBytes(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                "x".getBytes(string2);
                return string2;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                // empty catch block
            }
        }
        return string;
    }
}

