/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.parse.sax;

import com.thaiopensource.relaxng.parse.Annotations;
import com.thaiopensource.relaxng.parse.CommentList;
import com.thaiopensource.relaxng.parse.Context;
import com.thaiopensource.relaxng.parse.DataPatternBuilder;
import com.thaiopensource.relaxng.parse.Grammar;
import com.thaiopensource.relaxng.parse.GrammarSection;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.Include;
import com.thaiopensource.relaxng.parse.IncludedGrammar;
import com.thaiopensource.relaxng.parse.Location;
import com.thaiopensource.relaxng.parse.ParsedNameClass;
import com.thaiopensource.relaxng.parse.ParsedPattern;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.relaxng.parse.Scope;
import com.thaiopensource.relaxng.parse.sax.AbstractLexicalHandler;
import com.thaiopensource.relaxng.parse.sax.DtdContext;
import com.thaiopensource.relaxng.parse.sax.XmlBaseHandler;
import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.Uri;
import com.thaiopensource.xml.util.Naming;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class SchemaParser
extends DtdContext
implements Context {
    static final String relaxngURIPrefix = "http://relaxng.org/ns/structure/";
    static final String relaxng10URI = "http://relaxng.org/ns/structure/1.0";
    static final String xmlURI = "http://www.w3.org/XML/1998/namespace";
    static final String xsdURI = "http://www.w3.org/2001/XMLSchema-datatypes";
    static final Localizer localizer = new Localizer(class$com$thaiopensource$relaxng$parse$sax$SchemaParser == null ? (class$com$thaiopensource$relaxng$parse$sax$SchemaParser = SchemaParser.class$("com.thaiopensource.relaxng.parse.sax.SchemaParser")) : class$com$thaiopensource$relaxng$parse$sax$SchemaParser);
    String relaxngURI;
    XMLReader xr;
    ErrorHandler eh;
    SchemaBuilder schemaBuilder;
    ParsedPattern startPattern;
    Locator locator;
    PrefixMapping prefixMapping;
    XmlBaseHandler xmlBaseHandler = new XmlBaseHandler();
    private boolean inDtd = false;
    boolean hadError = false;
    Hashtable patternTable;
    Hashtable nameClassTable;
    private static final int INIT_CHILD_ALLOC = 5;
    private static final int PATTERN_CONTEXT = 0;
    private static final int ANY_NAME_CONTEXT = 1;
    private static final int NS_NAME_CONTEXT = 2;
    static /* synthetic */ Class class$com$thaiopensource$relaxng$parse$sax$SchemaParser;

    private void initPatternTable() {
        this.patternTable = new Hashtable();
        this.patternTable.put("zeroOrMore", new ZeroOrMoreState());
        this.patternTable.put("oneOrMore", new OneOrMoreState());
        this.patternTable.put("optional", new OptionalState());
        this.patternTable.put("list", new ListState());
        this.patternTable.put("choice", new ChoiceState());
        this.patternTable.put("interleave", new InterleaveState());
        this.patternTable.put("group", new GroupState());
        this.patternTable.put("mixed", new MixedState());
        this.patternTable.put("element", new ElementState());
        this.patternTable.put("attribute", new AttributeState());
        this.patternTable.put("empty", new EmptyState());
        this.patternTable.put("text", new TextState());
        this.patternTable.put("value", new ValueState());
        this.patternTable.put("data", new DataState());
        this.patternTable.put("notAllowed", new NotAllowedState());
        this.patternTable.put("grammar", new GrammarState());
        this.patternTable.put("ref", new RefState());
        this.patternTable.put("parentRef", new ParentRefState());
        this.patternTable.put("externalRef", new ExternalRefState());
    }

    private void initNameClassTable() {
        this.nameClassTable = new Hashtable();
        this.nameClassTable.put("name", new NameState());
        this.nameClassTable.put("anyName", new AnyNameState());
        this.nameClassTable.put("nsName", new NsNameState());
        this.nameClassTable.put("choice", new NameClassChoiceState());
    }

    ParsedPattern getStartPattern() throws IllegalSchemaException {
        if (this.hadError) {
            throw new IllegalSchemaException();
        }
        return this.startPattern;
    }

    void error(String string) throws SAXException {
        this.error(string, this.locator);
    }

    void error(String string, String string2) throws SAXException {
        this.error(string, string2, this.locator);
    }

    void error(String string, String string2, String string3) throws SAXException {
        this.error(string, string2, string3, this.locator);
    }

    void error(String string, Locator locator) throws SAXException {
        this.error(new SAXParseException(localizer.message(string), locator));
    }

    void error(String string, String string2, Locator locator) throws SAXException {
        this.error(new SAXParseException(localizer.message(string, string2), locator));
    }

    void error(String string, String string2, String string3, Locator locator) throws SAXException {
        this.error(new SAXParseException(localizer.message(string, string2, string3), locator));
    }

    void error(SAXParseException sAXParseException) throws SAXException {
        this.hadError = true;
        if (this.eh != null) {
            this.eh.error(sAXParseException);
        }
    }

    void warning(String string) throws SAXException {
        this.warning(string, this.locator);
    }

    void warning(String string, String string2) throws SAXException {
        this.warning(string, string2, this.locator);
    }

    void warning(String string, String string2, String string3) throws SAXException {
        this.warning(string, string2, string3, this.locator);
    }

    void warning(String string, Locator locator) throws SAXException {
        this.warning(new SAXParseException(localizer.message(string), locator));
    }

    void warning(String string, String string2, Locator locator) throws SAXException {
        this.warning(new SAXParseException(localizer.message(string, string2), locator));
    }

    void warning(String string, String string2, String string3, Locator locator) throws SAXException {
        this.warning(new SAXParseException(localizer.message(string, string2, string3), locator));
    }

    void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.eh != null) {
            this.eh.warning(sAXParseException);
        }
    }

    SchemaParser(XMLReader xMLReader, ErrorHandler errorHandler, SchemaBuilder schemaBuilder, IncludedGrammar includedGrammar, Scope scope) throws SAXException {
        this.xr = xMLReader;
        this.eh = errorHandler;
        this.schemaBuilder = schemaBuilder;
        if (errorHandler != null) {
            xMLReader.setErrorHandler(errorHandler);
        }
        xMLReader.setDTDHandler(this);
        if (schemaBuilder.usesComments()) {
            try {
                xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", new LexicalHandlerImpl());
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                this.warning("no_comment_support", xMLReader.getClass().getName());
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                this.warning("no_comment_support", xMLReader.getClass().getName());
            }
        }
        this.initPatternTable();
        this.initNameClassTable();
        this.prefixMapping = new PrefixMapping("xml", xmlURI, null);
        new RootState(includedGrammar, scope, SchemaBuilder.INHERIT_NS).set();
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.inDtd = true;
    }

    public void endDTD() throws SAXException {
        this.inDtd = false;
    }

    public String resolveNamespacePrefix(String string) {
        PrefixMapping prefixMapping = this.prefixMapping;
        while (prefixMapping != null) {
            if (prefixMapping.prefix.equals(string)) {
                return prefixMapping.uri;
            }
            prefixMapping = prefixMapping.next;
        }
        return null;
    }

    public Enumeration prefixes() {
        Vector<String> vector = new Vector<String>();
        PrefixMapping prefixMapping = this.prefixMapping;
        while (prefixMapping != null) {
            if (!vector.contains(prefixMapping.prefix)) {
                vector.addElement(prefixMapping.prefix);
            }
            prefixMapping = prefixMapping.next;
        }
        return vector.elements();
    }

    public String getBaseUri() {
        return this.xmlBaseHandler.getBaseUri();
    }

    ParsedNameClass expandName(String string, String string2) throws SAXException {
        int n = string.indexOf(58);
        if (n == -1) {
            return this.schemaBuilder.makeName(string2, this.checkNCName(string), null, null, null);
        }
        String string3 = this.checkNCName(string.substring(0, n));
        String string4 = this.checkNCName(string.substring(n + 1));
        PrefixMapping prefixMapping = this.prefixMapping;
        while (prefixMapping != null) {
            if (prefixMapping.prefix.equals(string3)) {
                return this.schemaBuilder.makeName(prefixMapping.uri, string4, string3, null, null);
            }
            prefixMapping = prefixMapping.next;
        }
        this.error("undefined_prefix", string3);
        return this.schemaBuilder.makeName("", string4, null, null, null);
    }

    String checkNCName(String string) throws SAXException {
        if (!Naming.isNcname(string)) {
            this.error("invalid_ncname", string);
        }
        return string;
    }

    String resolve(String string) throws SAXException {
        if (Uri.hasFragmentId(string)) {
            this.error("href_fragment_id");
        }
        string = Uri.escapeDisallowedChars(string);
        return Uri.resolve(this.xmlBaseHandler.getBaseUri(), string);
    }

    Location makeLocation() {
        if (this.locator == null) {
            return null;
        }
        return this.schemaBuilder.makeLocation(this.locator.getSystemId(), this.locator.getLineNumber(), this.locator.getColumnNumber());
    }

    void checkUri(String string) throws SAXException {
        if (!Uri.isValid(string)) {
            this.error("invalid_uri", string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class LexicalHandlerImpl
    extends AbstractLexicalHandler {
        LexicalHandlerImpl() {
        }

        public void comment(char[] cArray, int n, int n2) throws SAXException {
            if (!SchemaParser.this.inDtd) {
                if (n2 > 0 && (cArray[n] == ' ' || cArray[n] == '\n')) {
                    --n2;
                    ++n;
                }
                while (n2 > 0) {
                    char c = cArray[n + n2 - 1];
                    if (c != ' ' && c != '\n') break;
                    --n2;
                }
                ((CommentHandler)((Object)SchemaParser.this.xr.getContentHandler())).comment(new String(cArray, n, n2));
            }
        }
    }

    class NameClassChoiceState
    extends NameClassContainerState {
        private ParsedNameClass[] nameClasses;
        private int nNameClasses;
        private int context;

        NameClassChoiceState() {
            this.context = 0;
        }

        NameClassChoiceState(int n) {
            this.context = n;
        }

        void setParent(State state) {
            super.setParent(state);
            if (state instanceof NameClassChoiceState) {
                this.context = ((NameClassChoiceState)state).context;
            }
        }

        State create() {
            return new NameClassChoiceState();
        }

        State createChildState(String string) throws SAXException {
            if (string.equals("anyName")) {
                if (this.context >= 1) {
                    SchemaParser.this.error(this.context == 1 ? "any_name_except_contains_any_name" : "ns_name_except_contains_any_name");
                    return null;
                }
            } else if (string.equals("nsName") && this.context == 2) {
                SchemaParser.this.error("ns_name_except_contains_ns_name");
                return null;
            }
            return super.createChildState(string);
        }

        void endChild(ParsedNameClass parsedNameClass) {
            if (this.nameClasses == null) {
                this.nameClasses = new ParsedNameClass[5];
            } else if (this.nNameClasses >= this.nameClasses.length) {
                ParsedNameClass[] parsedNameClassArray = new ParsedNameClass[this.nameClasses.length * 2];
                System.arraycopy(this.nameClasses, 0, parsedNameClassArray, 0, this.nameClasses.length);
                this.nameClasses = parsedNameClassArray;
            }
            this.nameClasses[this.nNameClasses++] = parsedNameClass;
        }

        void end() throws SAXException {
            if (this.nNameClasses == 0) {
                SchemaParser.this.error("missing_name_class");
                this.parent.endChild(SchemaParser.this.schemaBuilder.makeErrorNameClass());
                return;
            }
            if (this.comments != null) {
                this.nameClasses[this.nNameClasses - 1] = SchemaParser.this.schemaBuilder.commentAfter(this.nameClasses[this.nNameClasses - 1], this.comments);
                this.comments = null;
            }
            this.parent.endChild(SchemaParser.this.schemaBuilder.makeChoice(this.nameClasses, this.nNameClasses, this.startLocation, this.annotations));
        }
    }

    class NsNameState
    extends AnyNameState {
        NsNameState() {
        }

        State create() {
            return new NsNameState();
        }

        ParsedNameClass makeNameClassNoExcept() {
            return SchemaParser.this.schemaBuilder.makeNsName(this.getNs(), null, null);
        }

        ParsedNameClass makeNameClassExcept(ParsedNameClass parsedNameClass) {
            return SchemaParser.this.schemaBuilder.makeNsName(this.getNs(), parsedNameClass, null, null);
        }

        int getContext() {
            return 2;
        }
    }

    class AnyNameState
    extends NameClassBaseState {
        ParsedNameClass except = null;

        AnyNameState() {
        }

        State create() {
            return new AnyNameState();
        }

        State createChildState(String string) throws SAXException {
            if (string.equals("except")) {
                if (this.except != null) {
                    SchemaParser.this.error("multiple_except");
                }
                return new NameClassChoiceState(this.getContext());
            }
            SchemaParser.this.error("expected_except", string);
            return null;
        }

        int getContext() {
            return 1;
        }

        ParsedNameClass makeNameClass() {
            if (this.except == null) {
                return this.makeNameClassNoExcept();
            }
            return this.makeNameClassExcept(this.except);
        }

        ParsedNameClass makeNameClassNoExcept() {
            return SchemaParser.this.schemaBuilder.makeAnyName(this.startLocation, this.annotations);
        }

        ParsedNameClass makeNameClassExcept(ParsedNameClass parsedNameClass) {
            return SchemaParser.this.schemaBuilder.makeAnyName(parsedNameClass, this.startLocation, this.annotations);
        }

        void endChild(ParsedNameClass parsedNameClass) {
            this.except = parsedNameClass;
        }
    }

    class NameState
    extends NameClassBaseState {
        StringBuffer buf = new StringBuffer();

        NameState() {
        }

        State createChildState(String string) throws SAXException {
            SchemaParser.this.error("expected_name", string);
            return null;
        }

        State create() {
            return new NameState();
        }

        public void characters(char[] cArray, int n, int n2) {
            this.buf.append(cArray, n, n2);
        }

        void checkForeignElement() throws SAXException {
            SchemaParser.this.error("name_contains_foreign_element");
        }

        ParsedNameClass makeNameClass() throws SAXException {
            return SchemaParser.this.expandName(this.buf.toString().trim(), this.getNs());
        }
    }

    abstract class NameClassBaseState
    extends State {
        NameClassBaseState() {
        }

        abstract ParsedNameClass makeNameClass() throws SAXException;

        void end() throws SAXException {
            this.parent.endChild(this.makeNameClass());
        }
    }

    class NameClassChildState
    extends NameClassContainerState {
        State prevState;
        NameClassRef nameClassRef;

        State create() {
            return null;
        }

        NameClassChildState(State state, NameClassRef nameClassRef) {
            this.prevState = state;
            this.nameClassRef = nameClassRef;
            this.setParent(state.parent);
            this.ns = state.ns;
        }

        void endChild(ParsedNameClass parsedNameClass) {
            this.nameClassRef.setNameClass(parsedNameClass);
            this.prevState.set();
        }

        void end() throws SAXException {
            this.nameClassRef.setNameClass(SchemaParser.this.schemaBuilder.makeErrorNameClass());
            SchemaParser.this.error("missing_name_class");
            this.prevState.set();
            this.prevState.end();
        }
    }

    abstract class NameClassContainerState
    extends State {
        NameClassContainerState() {
        }

        State createChildState(String string) throws SAXException {
            State state = (State)SchemaParser.this.nameClassTable.get(string);
            if (state == null) {
                SchemaParser.this.error("expected_name_class", string);
                return null;
            }
            return state.create();
        }
    }

    class StartState
    extends DefinitionState {
        StartState(GrammarSection grammarSection) {
            super(grammarSection);
        }

        State create() {
            return new StartState(null);
        }

        void sendPatternToParent(ParsedPattern parsedPattern) {
            this.section.define(GrammarSection.START, this.combine, parsedPattern, this.startLocation, this.annotations);
        }

        State createChildState(String string) throws SAXException {
            State state = super.createChildState(string);
            if (state != null && this.nChildPatterns != 0) {
                SchemaParser.this.error("start_multi_pattern");
            }
            return state;
        }
    }

    class DefineState
    extends DefinitionState {
        String name;

        DefineState(GrammarSection grammarSection) {
            super(grammarSection);
        }

        State create() {
            return new DefineState(null);
        }

        void setName(String string) throws SAXException {
            this.name = SchemaParser.this.checkNCName(string);
        }

        void endAttributes() throws SAXException {
            if (this.name == null) {
                SchemaParser.this.error("missing_name_attribute");
            }
        }

        void sendPatternToParent(ParsedPattern parsedPattern) {
            if (this.name != null) {
                this.section.define(this.name, this.combine, parsedPattern, this.startLocation, this.annotations);
            }
        }
    }

    abstract class DefinitionState
    extends PatternContainerState {
        GrammarSection.Combine combine = null;
        GrammarSection section;

        DefinitionState(GrammarSection grammarSection) {
            this.section = grammarSection;
        }

        void setOtherAttribute(String string, String string2) throws SAXException {
            if (string.equals("combine")) {
                if ((string2 = string2.trim()).equals("choice")) {
                    this.combine = GrammarSection.COMBINE_CHOICE;
                } else if (string2.equals("interleave")) {
                    this.combine = GrammarSection.COMBINE_INTERLEAVE;
                } else {
                    SchemaParser.this.error("combine_attribute_bad_value", string2);
                }
            } else {
                super.setOtherAttribute(string, string2);
            }
        }
    }

    class ExternalRefState
    extends EmptyContentState {
        String href;
        ParsedPattern includedPattern;

        ExternalRefState() {
        }

        State create() {
            return new ExternalRefState();
        }

        void setOtherAttribute(String string, String string2) throws SAXException {
            if (string.equals("href")) {
                this.href = string2;
                SchemaParser.this.checkUri(this.href);
            } else {
                super.setOtherAttribute(string, string2);
            }
        }

        void endAttributes() throws SAXException {
            if (this.href == null) {
                SchemaParser.this.error("missing_href_attribute");
            } else {
                this.href = SchemaParser.this.resolve(this.href);
            }
        }

        ParsedPattern makePattern() {
            if (this.href != null) {
                try {
                    return SchemaParser.this.schemaBuilder.makeExternalRef(this.href, this.getNs(), this.scope, this.startLocation, this.annotations);
                }
                catch (IllegalSchemaException illegalSchemaException) {
                    // empty catch block
                }
            }
            return SchemaParser.this.schemaBuilder.makeErrorPattern();
        }
    }

    class ParentRefState
    extends RefState {
        ParentRefState() {
        }

        State create() {
            return new ParentRefState();
        }

        void endAttributes() throws SAXException {
            super.endAttributes();
        }

        ParsedPattern makePattern() {
            return this.scope.makeParentRef(this.name, this.startLocation, this.annotations);
        }
    }

    class RefState
    extends EmptyContentState {
        String name;

        RefState() {
        }

        State create() {
            return new RefState();
        }

        void endAttributes() throws SAXException {
            if (this.name == null) {
                SchemaParser.this.error("missing_name_attribute");
            }
            if (this.scope == null) {
                SchemaParser.this.error("ref_outside_grammar");
            }
        }

        void setName(String string) throws SAXException {
            this.name = SchemaParser.this.checkNCName(string);
        }

        ParsedPattern makePattern() {
            return this.makePattern(this.scope);
        }

        ParsedPattern makePattern(Scope scope) {
            return scope.makeRef(this.name, this.startLocation, this.annotations);
        }
    }

    class GrammarState
    extends DivState {
        Grammar grammar;

        GrammarState() {
        }

        void setParent(State state) {
            super.setParent(state);
            this.grammar = SchemaParser.this.schemaBuilder.makeGrammar(this.scope);
            this.section = this.grammar;
            this.scope = this.grammar;
        }

        State create() {
            return new GrammarState();
        }

        void end() throws SAXException {
            super.end();
            this.parent.endChild(this.grammar.endGrammar(this.startLocation, this.annotations));
        }
    }

    class MergeGrammarState
    extends DivState {
        IncludedGrammar grammar;

        MergeGrammarState(IncludedGrammar includedGrammar) {
            super(includedGrammar);
            this.grammar = includedGrammar;
        }

        void end() throws SAXException {
            super.end();
            this.parent.endChild(this.grammar.endIncludedGrammar(this.startLocation, this.annotations));
        }
    }

    class IncludeState
    extends DivState {
        String href;
        Include include;

        IncludeState(Include include) {
            super(include);
            this.include = include;
        }

        void setOtherAttribute(String string, String string2) throws SAXException {
            if (string.equals("href")) {
                this.href = string2;
                SchemaParser.this.checkUri(this.href);
            } else {
                super.setOtherAttribute(string, string2);
            }
        }

        void endAttributes() throws SAXException {
            if (this.href == null) {
                SchemaParser.this.error("missing_href_attribute");
            } else {
                this.href = SchemaParser.this.resolve(this.href);
            }
        }

        void end() throws SAXException {
            super.end();
            if (this.href != null) {
                try {
                    this.include.endInclude(this.href, this.getNs(), this.startLocation, this.annotations);
                }
                catch (IllegalSchemaException illegalSchemaException) {
                    // empty catch block
                }
            }
        }
    }

    class DivState
    extends State {
        GrammarSection section;

        DivState() {
        }

        DivState(GrammarSection grammarSection) {
            this.section = grammarSection;
        }

        State create() {
            return new DivState(null);
        }

        State createChildState(String string) throws SAXException {
            Include include;
            if (string.equals("define")) {
                return new DefineState(this.section);
            }
            if (string.equals("start")) {
                return new StartState(this.section);
            }
            if (string.equals("include") && (include = this.section.makeInclude()) != null) {
                return new IncludeState(include);
            }
            if (string.equals("div")) {
                return new DivState(this.section.makeDiv());
            }
            SchemaParser.this.error("expected_define", string);
            return null;
        }

        void end() throws SAXException {
            if (this.comments != null) {
                this.section.topLevelComment(this.comments);
                this.comments = null;
            }
        }
    }

    abstract class SinglePatternContainerState
    extends PatternContainerState {
        SinglePatternContainerState() {
        }

        State createChildState(String string) throws SAXException {
            if (this.nChildPatterns == 0) {
                return super.createChildState(string);
            }
            SchemaParser.this.error("too_many_children");
            return null;
        }
    }

    class AttributeState
    extends PatternContainerState
    implements NameClassRef {
        ParsedNameClass nameClass;
        String name;

        AttributeState() {
        }

        State create() {
            return new AttributeState();
        }

        void setName(String string) {
            this.name = string;
        }

        public void setNameClass(ParsedNameClass parsedNameClass) {
            this.nameClass = parsedNameClass;
        }

        void endAttributes() throws SAXException {
            if (this.name != null) {
                String string = this.ns != null ? this.ns : "";
                this.nameClass = SchemaParser.this.expandName(this.name, string);
            } else {
                new NameClassChildState(this, this).set();
            }
        }

        void end() throws SAXException {
            if (this.nChildPatterns == 0) {
                this.endChild(SchemaParser.this.schemaBuilder.makeText(this.startLocation, null));
            }
            super.end();
        }

        ParsedPattern buildPattern(ParsedPattern[] parsedPatternArray, int n, Location location, Annotations annotations) throws SAXException {
            return SchemaParser.this.schemaBuilder.makeAttribute(this.nameClass, super.buildPattern(parsedPatternArray, n, location, null), location, annotations);
        }

        State createChildState(String string) throws SAXException {
            State state = super.createChildState(string);
            if (state != null && this.nChildPatterns != 0) {
                SchemaParser.this.error("attribute_multi_pattern");
            }
            return state;
        }
    }

    class ParamState
    extends State {
        private StringBuffer buf = new StringBuffer();
        private DataPatternBuilder dpb;
        private String name;

        ParamState(DataPatternBuilder dataPatternBuilder) {
            this.dpb = dataPatternBuilder;
        }

        State create() {
            return new ParamState(null);
        }

        void setName(String string) throws SAXException {
            this.name = SchemaParser.this.checkNCName(string);
        }

        void endAttributes() throws SAXException {
            if (this.name == null) {
                SchemaParser.this.error("missing_name_attribute");
            }
        }

        State createChildState(String string) throws SAXException {
            SchemaParser.this.error("expected_empty", string);
            return null;
        }

        public void characters(char[] cArray, int n, int n2) {
            this.buf.append(cArray, n, n2);
        }

        void checkForeignElement() throws SAXException {
            SchemaParser.this.error("param_contains_foreign_element");
        }

        void end() throws SAXException {
            if (this.name == null) {
                return;
            }
            if (this.dpb != null) {
                this.dpb.addParam(this.name, this.buf.toString(), SchemaParser.this, this.getNs(), this.startLocation, this.annotations);
            }
        }
    }

    class DataState
    extends State {
        String type;
        ParsedPattern except = null;
        DataPatternBuilder dpb = null;

        DataState() {
        }

        State create() {
            return new DataState();
        }

        State createChildState(String string) throws SAXException {
            if (string.equals("param")) {
                if (this.except != null) {
                    SchemaParser.this.error("param_after_except");
                }
                return new ParamState(this.dpb);
            }
            if (string.equals("except")) {
                if (this.except != null) {
                    SchemaParser.this.error("multiple_except");
                }
                return new ChoiceState();
            }
            SchemaParser.this.error("expected_param_except", string);
            return null;
        }

        void setOtherAttribute(String string, String string2) throws SAXException {
            if (string.equals("type")) {
                this.type = SchemaParser.this.checkNCName(string2.trim());
            } else {
                super.setOtherAttribute(string, string2);
            }
        }

        void endAttributes() throws SAXException {
            if (this.type == null) {
                SchemaParser.this.error("missing_type_attribute");
            } else {
                this.dpb = SchemaParser.this.schemaBuilder.makeDataPatternBuilder(this.datatypeLibrary, this.type, this.startLocation);
            }
        }

        void end() throws SAXException {
            ParsedPattern parsedPattern = this.dpb != null ? (this.except != null ? this.dpb.makePattern(this.except, this.startLocation, this.annotations) : this.dpb.makePattern(this.startLocation, this.annotations)) : SchemaParser.this.schemaBuilder.makeErrorPattern();
            this.parent.endChild(parsedPattern);
        }

        void endChild(ParsedPattern parsedPattern) {
            this.except = parsedPattern;
        }
    }

    class ValueState
    extends EmptyContentState {
        StringBuffer buf = new StringBuffer();
        String type;

        ValueState() {
        }

        State create() {
            return new ValueState();
        }

        void setOtherAttribute(String string, String string2) throws SAXException {
            if (string.equals("type")) {
                this.type = SchemaParser.this.checkNCName(string2.trim());
            } else {
                super.setOtherAttribute(string, string2);
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            this.buf.append(cArray, n, n2);
        }

        void checkForeignElement() throws SAXException {
            SchemaParser.this.error("value_contains_foreign_element");
        }

        ParsedPattern makePattern() throws SAXException {
            if (this.type == null) {
                return this.makePattern("", "token");
            }
            return this.makePattern(this.datatypeLibrary, this.type);
        }

        ParsedPattern makePattern(String string, String string2) {
            return SchemaParser.this.schemaBuilder.makeValue(string, string2, this.buf.toString(), SchemaParser.this, this.getNs(), this.startLocation, this.annotations);
        }
    }

    class TextState
    extends EmptyContentState {
        TextState() {
        }

        State create() {
            return new TextState();
        }

        ParsedPattern makePattern() {
            return SchemaParser.this.schemaBuilder.makeText(this.startLocation, this.annotations);
        }
    }

    class EmptyState
    extends EmptyContentState {
        EmptyState() {
        }

        State create() {
            return new EmptyState();
        }

        ParsedPattern makePattern() {
            return SchemaParser.this.schemaBuilder.makeEmpty(this.startLocation, this.annotations);
        }
    }

    class NotAllowedState
    extends EmptyContentState {
        NotAllowedState() {
        }

        State create() {
            return new NotAllowedState();
        }

        ParsedPattern makePattern() {
            return SchemaParser.this.schemaBuilder.makeNotAllowed(this.startLocation, this.annotations);
        }
    }

    class RootState
    extends PatternContainerState {
        IncludedGrammar grammar;

        RootState() {
        }

        RootState(IncludedGrammar includedGrammar, Scope scope, String string) {
            this.grammar = includedGrammar;
            this.scope = scope;
            this.nsInherit = string;
            this.datatypeLibrary = "";
        }

        State create() {
            return new RootState();
        }

        State createChildState(String string) throws SAXException {
            if (this.grammar == null) {
                return super.createChildState(string);
            }
            if (string.equals("grammar")) {
                return new MergeGrammarState(this.grammar);
            }
            SchemaParser.this.error("expected_grammar", string);
            return null;
        }

        void checkForeignElement() throws SAXException {
            SchemaParser.this.error("root_bad_namespace_uri", SchemaParser.relaxng10URI);
        }

        void endChild(ParsedPattern parsedPattern) {
            SchemaParser.this.startPattern = parsedPattern;
        }

        boolean isRelaxNGElement(String string) throws SAXException {
            if (!string.startsWith(SchemaParser.relaxngURIPrefix)) {
                return false;
            }
            if (!string.equals(SchemaParser.relaxng10URI)) {
                SchemaParser.this.warning("wrong_uri_version", SchemaParser.relaxng10URI.substring(SchemaParser.relaxngURIPrefix.length()), string.substring(SchemaParser.relaxngURIPrefix.length()));
            }
            SchemaParser.this.relaxngURI = string;
            return true;
        }
    }

    class ElementState
    extends PatternContainerState
    implements NameClassRef {
        ParsedNameClass nameClass;
        String name;

        ElementState() {
        }

        void setName(String string) {
            this.name = string;
        }

        public void setNameClass(ParsedNameClass parsedNameClass) {
            this.nameClass = parsedNameClass;
        }

        void endAttributes() throws SAXException {
            if (this.name != null) {
                this.nameClass = SchemaParser.this.expandName(this.name, this.getNs());
            } else {
                new NameClassChildState(this, this).set();
            }
        }

        State create() {
            return new ElementState();
        }

        ParsedPattern buildPattern(ParsedPattern[] parsedPatternArray, int n, Location location, Annotations annotations) throws SAXException {
            return SchemaParser.this.schemaBuilder.makeElement(this.nameClass, super.buildPattern(parsedPatternArray, n, location, null), location, annotations);
        }
    }

    static interface NameClassRef {
        public void setNameClass(ParsedNameClass var1);
    }

    class MixedState
    extends PatternContainerState {
        MixedState() {
        }

        State create() {
            return new MixedState();
        }

        ParsedPattern buildPattern(ParsedPattern[] parsedPatternArray, int n, Location location, Annotations annotations) throws SAXException {
            return SchemaParser.this.schemaBuilder.makeMixed(super.buildPattern(parsedPatternArray, n, location, null), location, annotations);
        }
    }

    class InterleaveState
    extends PatternContainerState {
        InterleaveState() {
        }

        State create() {
            return new InterleaveState();
        }

        ParsedPattern buildPattern(ParsedPattern[] parsedPatternArray, int n, Location location, Annotations annotations) {
            return SchemaParser.this.schemaBuilder.makeInterleave(parsedPatternArray, n, location, annotations);
        }
    }

    class ChoiceState
    extends PatternContainerState {
        ChoiceState() {
        }

        State create() {
            return new ChoiceState();
        }

        ParsedPattern buildPattern(ParsedPattern[] parsedPatternArray, int n, Location location, Annotations annotations) throws SAXException {
            return SchemaParser.this.schemaBuilder.makeChoice(parsedPatternArray, n, location, annotations);
        }
    }

    class ListState
    extends PatternContainerState {
        ListState() {
        }

        State create() {
            return new ListState();
        }

        ParsedPattern buildPattern(ParsedPattern[] parsedPatternArray, int n, Location location, Annotations annotations) throws SAXException {
            return SchemaParser.this.schemaBuilder.makeList(super.buildPattern(parsedPatternArray, n, location, null), location, annotations);
        }
    }

    class OptionalState
    extends PatternContainerState {
        OptionalState() {
        }

        State create() {
            return new OptionalState();
        }

        ParsedPattern buildPattern(ParsedPattern[] parsedPatternArray, int n, Location location, Annotations annotations) throws SAXException {
            return SchemaParser.this.schemaBuilder.makeOptional(super.buildPattern(parsedPatternArray, n, location, null), location, annotations);
        }
    }

    class OneOrMoreState
    extends PatternContainerState {
        OneOrMoreState() {
        }

        State create() {
            return new OneOrMoreState();
        }

        ParsedPattern buildPattern(ParsedPattern[] parsedPatternArray, int n, Location location, Annotations annotations) throws SAXException {
            return SchemaParser.this.schemaBuilder.makeOneOrMore(super.buildPattern(parsedPatternArray, n, location, null), location, annotations);
        }
    }

    class ZeroOrMoreState
    extends PatternContainerState {
        ZeroOrMoreState() {
        }

        State create() {
            return new ZeroOrMoreState();
        }

        ParsedPattern buildPattern(ParsedPattern[] parsedPatternArray, int n, Location location, Annotations annotations) throws SAXException {
            return SchemaParser.this.schemaBuilder.makeZeroOrMore(super.buildPattern(parsedPatternArray, n, location, null), location, annotations);
        }
    }

    class GroupState
    extends PatternContainerState {
        GroupState() {
        }

        State create() {
            return new GroupState();
        }
    }

    abstract class PatternContainerState
    extends State {
        ParsedPattern[] childPatterns;
        int nChildPatterns = 0;

        PatternContainerState() {
        }

        State createChildState(String string) throws SAXException {
            State state = (State)SchemaParser.this.patternTable.get(string);
            if (state == null) {
                SchemaParser.this.error("expected_pattern", string);
                return null;
            }
            return state.create();
        }

        ParsedPattern buildPattern(ParsedPattern[] parsedPatternArray, int n, Location location, Annotations annotations) throws SAXException {
            if (n == 1 && annotations == null) {
                return parsedPatternArray[0];
            }
            return SchemaParser.this.schemaBuilder.makeGroup(parsedPatternArray, n, location, annotations);
        }

        void endChild(ParsedPattern parsedPattern) {
            if (this.childPatterns == null) {
                this.childPatterns = new ParsedPattern[5];
            } else if (this.nChildPatterns >= this.childPatterns.length) {
                ParsedPattern[] parsedPatternArray = new ParsedPattern[this.childPatterns.length * 2];
                System.arraycopy(this.childPatterns, 0, parsedPatternArray, 0, this.childPatterns.length);
                this.childPatterns = parsedPatternArray;
            }
            this.childPatterns[this.nChildPatterns++] = parsedPattern;
        }

        void end() throws SAXException {
            if (this.nChildPatterns == 0) {
                SchemaParser.this.error("missing_children");
                this.endChild(SchemaParser.this.schemaBuilder.makeErrorPattern());
            }
            if (this.comments != null) {
                this.childPatterns[this.nChildPatterns - 1] = SchemaParser.this.schemaBuilder.commentAfter(this.childPatterns[this.nChildPatterns - 1], this.comments);
                this.comments = null;
            }
            this.sendPatternToParent(this.buildPattern(this.childPatterns, this.nChildPatterns, this.startLocation, this.annotations));
        }

        void sendPatternToParent(ParsedPattern parsedPattern) {
            this.parent.endChild(parsedPattern);
        }
    }

    abstract class EmptyContentState
    extends State {
        EmptyContentState() {
        }

        State createChildState(String string) throws SAXException {
            SchemaParser.this.error("expected_empty", string);
            return null;
        }

        abstract ParsedPattern makePattern() throws SAXException;

        void end() throws SAXException {
            if (this.comments != null) {
                if (this.annotations == null) {
                    this.annotations = SchemaParser.this.schemaBuilder.makeAnnotations(null, SchemaParser.this);
                }
                this.annotations.addComment(this.comments);
                this.comments = null;
            }
            this.parent.endChild(this.makePattern());
        }
    }

    class Skipper
    extends DefaultHandler
    implements CommentHandler {
        int level = 1;
        State nextState;

        Skipper(State state) {
            this.nextState = state;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ++this.level;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (--this.level == 0) {
                this.nextState.set();
            }
        }

        public void comment(String string) {
        }
    }

    abstract class State
    implements ContentHandler,
    CommentHandler {
        State parent;
        String nsInherit;
        String ns;
        String datatypeLibrary;
        Scope scope;
        Location startLocation;
        Annotations annotations;
        CommentList comments;

        State() {
        }

        void set() {
            SchemaParser.this.xr.setContentHandler(this);
        }

        abstract State create();

        abstract State createChildState(String var1) throws SAXException;

        public void setDocumentLocator(Locator locator) {
            SchemaParser.this.locator = locator;
            SchemaParser.this.xmlBaseHandler.setLocator(locator);
        }

        void setParent(State state) {
            this.parent = state;
            this.nsInherit = state.getNs();
            this.datatypeLibrary = state.datatypeLibrary;
            this.scope = state.scope;
            this.startLocation = SchemaParser.this.makeLocation();
            if (state.comments != null) {
                this.annotations = SchemaParser.this.schemaBuilder.makeAnnotations(state.comments, SchemaParser.this);
                state.comments = null;
            }
        }

        String getNs() {
            return this.ns == null ? this.nsInherit : this.ns;
        }

        boolean isRelaxNGElement(String string) throws SAXException {
            return string.equals(SchemaParser.this.relaxngURI);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            SchemaParser.this.xmlBaseHandler.startElement();
            if (this.isRelaxNGElement(string)) {
                State state = this.createChildState(string2);
                if (state == null) {
                    SchemaParser.this.xr.setContentHandler(new Skipper(this));
                    return;
                }
                state.setParent(this);
                state.set();
                state.attributes(attributes);
            } else {
                this.checkForeignElement();
                SchemaParser.this.xr.setContentHandler(new Skipper(this));
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            SchemaParser.this.xmlBaseHandler.endElement();
            this.parent.set();
            this.end();
        }

        void setName(String string) throws SAXException {
            SchemaParser.this.error("illegal_name_attribute");
        }

        void setOtherAttribute(String string, String string2) throws SAXException {
            SchemaParser.this.error("illegal_attribute_ignored", string);
        }

        void endAttributes() throws SAXException {
        }

        void checkForeignElement() throws SAXException {
        }

        void attributes(Attributes attributes) throws SAXException {
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string;
                String string2 = attributes.getURI(n2);
                if (string2.length() == 0) {
                    string = attributes.getLocalName(n2);
                    if (string.equals("name")) {
                        this.setName(attributes.getValue(n2).trim());
                    } else if (string.equals("ns")) {
                        this.ns = attributes.getValue(n2);
                    } else if (string.equals("datatypeLibrary")) {
                        this.datatypeLibrary = attributes.getValue(n2);
                        SchemaParser.this.checkUri(this.datatypeLibrary);
                        if (!this.datatypeLibrary.equals("") && !Uri.isAbsolute(this.datatypeLibrary)) {
                            SchemaParser.this.error("relative_datatype_library");
                        }
                        if (Uri.hasFragmentId(this.datatypeLibrary)) {
                            SchemaParser.this.error("fragment_identifier_datatype_library");
                        }
                        this.datatypeLibrary = Uri.escapeDisallowedChars(this.datatypeLibrary);
                    } else {
                        this.setOtherAttribute(string, attributes.getValue(n2));
                    }
                } else if (string2.equals(SchemaParser.this.relaxngURI)) {
                    SchemaParser.this.error("qualified_attribute", attributes.getLocalName(n2));
                } else if (string2.equals(SchemaParser.xmlURI) && attributes.getLocalName(n2).equals("base")) {
                    SchemaParser.this.xmlBaseHandler.xmlBaseAttribute(attributes.getValue(n2));
                } else {
                    if (this.annotations == null) {
                        this.annotations = SchemaParser.this.schemaBuilder.makeAnnotations(null, SchemaParser.this);
                    }
                    string = attributes.getQName(n2);
                    String string3 = null;
                    if (string.equals("")) {
                        PrefixMapping prefixMapping = SchemaParser.this.prefixMapping;
                        while (prefixMapping != null) {
                            if (prefixMapping.uri.equals(string2)) {
                                string3 = prefixMapping.prefix;
                                break;
                            }
                            prefixMapping = prefixMapping.next;
                        }
                    } else {
                        string3 = string.substring(0, string.indexOf(58));
                    }
                    this.annotations.addAttribute(string2, attributes.getLocalName(n2), string3, attributes.getValue(n2), this.startLocation);
                }
                ++n2;
            }
            this.endAttributes();
        }

        abstract void end() throws SAXException;

        void endChild(ParsedPattern parsedPattern) {
        }

        void endChild(ParsedNameClass parsedNameClass) {
        }

        public void startDocument() {
        }

        public void endDocument() {
            if (this.comments != null && SchemaParser.this.startPattern != null) {
                SchemaParser.this.startPattern = SchemaParser.this.schemaBuilder.commentAfter(SchemaParser.this.startPattern, this.comments);
                this.comments = null;
            }
        }

        public void processingInstruction(String string, String string2) {
        }

        public void skippedEntity(String string) {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }

        public void comment(String string) {
            if (this.comments == null) {
                this.comments = SchemaParser.this.schemaBuilder.makeCommentList();
            }
            this.comments.addComment(string, SchemaParser.this.makeLocation());
        }

        CommentList getComments() {
            CommentList commentList = this.comments;
            this.comments = null;
            return commentList;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            int n3 = 0;
            while (n3 < n2) {
                switch (cArray[n + n3]) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        SchemaParser.this.error("illegal_characters_ignored");
                    }
                }
                ++n3;
            }
        }

        public void startPrefixMapping(String string, String string2) {
            SchemaParser.this.prefixMapping = new PrefixMapping(string, string2, SchemaParser.this.prefixMapping);
        }

        public void endPrefixMapping(String string) {
            SchemaParser.this.prefixMapping = SchemaParser.this.prefixMapping.next;
        }

        boolean isPatternNamespaceURI(String string) {
            return string.equals(SchemaParser.this.relaxngURI);
        }
    }

    static interface CommentHandler {
        public void comment(String var1);
    }

    static class PrefixMapping {
        final String prefix;
        final String uri;
        final PrefixMapping next;

        PrefixMapping(String string, String string2, PrefixMapping prefixMapping) {
            this.prefix = string;
            this.uri = string2;
            this.next = prefixMapping;
        }
    }
}

