// -*- c++ -*-

// Copyright 1998 Zanshin Inc.                       <http://www.zanshin.com/>

// The contents of this file are subject to the Zanshin Public License Version
// 1.0 (the "License"); you may not use this file except in compliance with the
// License.  You should have received a copy of the License with Latte; see
// the file COPYING.  You may also obtain a copy of the License at
// <http://www.zanshin.com/ZPL.html>.
// 
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
// 
// The Original Code is Latte.
// 
// The Initial Developer of the Original Code is Zanshin, Inc.

#ifndef RESTORER_H
# define RESTORER_H

#include <latte-conf.h>

template <class T>
class Restorer {
 public:
  Restorer(T &t) : t(t), val(t) {}
  Restorer(T &t, const T &now, const T &later) : t(t), val(later) { t = now; }

  ~Restorer() { t = val; }

 private:
  T &t;
  T val;
};

#endif // RESTORER_H
