#ifndef _hsregexp_h
#define _hsregexp_h
/*
 * Definitions etc. for regexp(3) routines.
 *
 * Caveat:  this is V8 regexp(3) [actually, a reimplementation thereof],
 * not the System V one.
 */

#include "lt-defs.h"

#define NSUBEXP  10
typedef struct regexp {
	char8 *startp[NSUBEXP];
	char8 *endp[NSUBEXP];
	char8 regstart;		/* Internal use only. */
	char8 reganch;		/* Internal use only. */
	char8 *regmust;		/* Internal use only. */
	int regmlen;		/* Internal use only. */
	char8 program[1];	/* Unwarranted chumminess with compiler. */
} regexp;



#ifdef macintosh
#pragma export on
#endif

extern STD_API regexp * EXPRT hsregcomp (const char8 *exp);
extern STD_API int  EXPRT hsregexec (register const regexp *prog,
				     register const char8 *string);
extern STD_API boolean  EXPRT regsub (const regexp *prog,
				      const char8 *source,
				      char8 *dest);

#ifdef macintosh
#pragma export off
#endif

/* NSL error handling */
#define hsregerror(msg) LT_ERROR(LERGXP,"hsregexp failure: " msg "\n")

/* Rather too dangerous to leave defined */
#undef P

#endif /* _hsregexp_h */

