#ifndef _steve_comment_h

#include <stdlib.h>  /* needed for exit() */
#include "lt-defs.h"
#include "charset.h"
#include "stdio16.h"

#if 0
/* Now an attribute of Stdout */
extern STD_API CharacterEncoding ErrorMessageEncoding;
#endif

#define EC(call,suberr,myerr) if((call)==suberr) return myerr
#define ECNN(call) EC(call,NULL,NULL)
#define ECNF(call) EC(call,NULL,FALSE)
#define ECNE(call) EC(call,NULL,-1)
#define ECFN(call) EC(call,FALSE,NULL)
#define ECFF(call) EC(call,FALSE,FALSE)
#define ECFE(call) EC(call,FALSE,-1)
#define ECEN(call) EC(call,-1,NULL)
#define ECEF(call) EC(call,-1,FALSE)
#define ECEE(call) EC(call,-1,-1)


#ifdef DEBUG
#define COMMENT(x) \
{ \
Fprintf(Stderr, x); \
}

#define VCOMMENT(x) \
( \
Fprintf(Stderr, x) \
)

#else 
#define COMMENT(x) {;};
#define VCOMMENT(x) (1)
#endif /* DEBUG */

#ifdef DEBUG
#define COMMENT1(x,y) \
{ \
Fprintf(Stderr, (x),(y)); \
}
#define VCOMMENT1(x,y) \
( \
Fprintf(Stderr, (x),(y)) \
)

#else 
#define COMMENT1(x,y) {;};
#define VCOMMENT1(x,y) (1)
#endif /* DEBUG */

#define REPORT(x) \
{ \
Fprintf(Stderr, (x)); \
}

#define REPORT1(x,y) \
{ \
Fprintf(Stderr, (x),(y)); \
}

#ifdef DEBUG
/* # if DEBUG > 1 (Andrei's compiler doesnt like this) */
#define CCOMMENT(x) COMMENT(x)
#define CCOMMENT1(x,y) COMMENT1(x,y)
/* # else
  # define CCOMMENT(x) {;};
  # define CCOMMENT1(x,y) {;};
  # endif */
#else
#define CCOMMENT(x) {;};
#define CCOMMENT1(x,y) {;};
#endif /* DEBUG */

#include "lt-err.h"

#define LT_ERROR(n,x)\
{ \
Fprintf(Stderr, x); \
LTSTDError(n,1,__FILE__,__LINE__); \
}

#define LT_ERROR1(n,x,y) \
{ \
Fprintf(Stderr, (x),(y)); \
LTSTDError(n,1,__FILE__,__LINE__); \
}

#define LT_ERROR2(n,x,y,z) \
{ \
Fprintf(Stderr, (x),(y),(z)); \
LTSTDError(n,1,__FILE__,__LINE__); \
}

#define LT_ERROR3(n,x,y,z,w) \
{ \
Fprintf(Stderr, (x),(y),(z),(w)); \
LTSTDError(n,1,__FILE__,__LINE__); \
}

#define LT_ERROR4(n,x,y,z,w,v) \
{ \
Fprintf(Stderr, (x),(y),(z),(w),(v)); \
LTSTDError(n,1,__FILE__,__LINE__); \
}

#define WARN(n,x)\
{ \
Fprintf(Stderr, x); \
LTSTDError(n,0,__FILE__,__LINE__); \
}

#define WARN1(n,x,y) \
{ \
Fprintf(Stderr, (x),(y)); \
LTSTDError(n,0,__FILE__,__LINE__); \
}

#define WARN2(n,x,y,z) \
{ \
Fprintf(Stderr, (x),(y),(z)); \
LTSTDError(n,0,__FILE__,__LINE__); \
}

/* #include "lt-errmsg.h" ??? */

#define _steve_comment_h
#endif
