/* lt-defs.h	-- Henry Thompson
 *
 * $Header: /export/cvsserver/cvsroot/ltg/LTXML/include/lt-defs.h,v 1.23 2000/12/02 18:04:18 ht Exp $
 */

#ifndef _LT_DEFS_H
#define _LT_DEFS_H

#ifdef __BORLAND__
#define WIN32			/* Not tested on Borland */
#endif

#if defined(WIN32) && ! defined(__CYGWIN__)
#define off_t long
#define _OFF_T_DEFINED
#define caddr_t void*
#undef  HAVE_POPEN
#define FREE_VOID
#define STDC_HEADERS
#define HAVE_FILEUTIL_P
#define HAVE_FILEUTIL2_P
#define HAVE_FTRUNCATE_P
#define HAVE_SYSTEM_P 1
#define HAVE_SYS_ERRLIST_DECL 
#define sys_errlist _sys_errlist
#define HAVE_GETCWD
#define X_OK 01   /* for access() */
#define NO_MAPMEM 1
#include <stdio.h>
#include <stdlib.h>
#include <io.h>

#define SOCKETS_IMPLEMENTED

#define getcwd _getcwd
#else  

#ifdef macintosh

 /* we adopt the Solaris convention for return values from lseek and co */

 #define off_t long

 /* Define if you have the ANSI C header files.  */
 #define STDC_HEADERS 1
 #define HAVE_FILEUTIL_P 1
 #define HAVE_FILEUTIL2_P 1
 #define HAVE_SYSTEM_P 1
 #define HAVE_SYS_ERRLIST_DECL 1
 #define FREE_VOID 1
 #define HAVE_FTRUNCATE_P 1
 /* Define if you have the fdopen function.  */
 #define HAVE_FDOPEN 1

 /* Define if you have the fileno function.  */
 #define HAVE_FILENO 1

 /* Define if you have the ftruncate function.  */
 #define HAVE_FTRUNCATE 1

 /* Define if you have the getcwd function.  */
 #define HAVE_GETCWD 1

 #define HAVE_GETWD 1
  #ifdef HAVE_POPEN
  #undef HAVE_POPEN
  #endif
 #define HAVE_PUTW 1
 #define HAVE_STDLIB_H 1
 #define HAVE_UNISTD_H 1
 #define NO_MAPMEM 1
#else  
 /* neither mac nor WIN32 */
 #define SOCKETS_IMPLEMENTED
 #include <sys/types.h>
 #include "xmlconfig.h"
 #undef NO_MAPMEM
#endif /* macintosh */
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_STDARG_H
#include <stdarg.h>
#endif

 /* for DLL export under NT */
#define EXPRT
#define IMPRT
#define STD_API
#define WIN_IMP

#if defined(WIN32) && ! defined(__CYGWIN__)
 #ifdef __BORLAND__     
  #undef EXPRT
  #undef IMPRT
  #define EXPRT _export
  #define IMPRT _import
 #else
  #undef STD_API
  #ifdef _BUILD_STD
   #define STD_API __declspec(dllexport)
  #else
   #define STD_API __declspec(dllimport)
  #endif
  #undef WIN_IMP
  #define WIN_IMP __declspec(dllimport)
 #endif
#endif

/* Nothing works without this! */
#include "charset.h"

#ifndef _dmck_defined_Bool_
typedef enum  {False=0, True=1} Bool;  /*andrei wants this */
#define _dmck_defined_Bool_ 1
#endif

#ifndef HAVE_SYS_ERRLIST_DECL
extern char *sys_errlist[];
#endif

#ifndef HAVE_FILEUTIL_P
/* non-ANSI file utilities from stdio.h */
#include <stdio.h>
extern int      putw(int, FILE *);
extern FILE     *popen(const char *, const char *);
extern int      pclose(FILE *);
extern void perror(const char *);
#ifndef fileno
extern int      fileno(FILE *);
#endif
extern FILE     *fdopen(int, const char *);
#endif

#ifndef HAVE_FILEUTIL2_P
/* Another batch of non-ansi templates (needed on sunos) */
#include <stdio.h> /* Safe to include twice ? */
extern int fclose (FILE *);
extern int fflush (FILE *);
extern int fprintf (FILE *, const char *, ...); /* arghh */
extern int _flsbuf (unsigned int, FILE *);
extern int _filbuf (FILE *);
extern int fputs (const char *, FILE *);
extern int fseek (FILE *, long int, int);
extern int ungetc (int, FILE *);
extern __SIZE_TYPE__ fwrite (const void *, __SIZE_TYPE__ , __SIZE_TYPE__ , FILE *);
extern int putw(int w, FILE *stream);
#ifndef vfprintf
extern int vfprintf (FILE *, const char *, va_list);
#endif
#endif /* HAVE_FILEUTIL2_P */

#ifndef HAVE_SYSTEM_P
extern int system(const char *string);
#endif

#ifndef boolean
#define boolean int
#ifndef macintosh
#define TRUE 1
#define FALSE 0
#endif
#endif

#ifndef NULL
#define NULL 0
#endif

#ifndef HAVE_FTRUNCATE_P
extern int ftruncate(int, off_t);
#endif

#define WHITESPACE " \n\t"

#ifndef MAXFILENAMELEN
#define MAXFILENAMELEN 1000
#endif

#ifdef MAXPATHLEN
#define CWDBS MAXPATHLEN+1
#else
#define CWDBS 1025
#endif

#ifdef HAVE_UNISTD_H

 #define GETWD(buf) getcwd(buf,CWDBS)

#else

 #ifdef HAVE_GETCWD
 #define GETWD(buf) getcwd(buf,CWDBS)
 #else
 #ifdef HAVE_GETWD
 extern char *getwd(char*);
 #define GETWD(buf) getwd(buf)
 #endif
 #endif /* HAVE_GETCWD */
#endif /* HAVE_UNISTD_H */

#endif
