/* err.h	-- Henry S. Thompson
 * Error interface
 */

#ifndef _LTSTD_ERR_H
#define _LTSTD_ERR_H

#include "lt-defs.h"  /* for EXPRT declaration */

extern STD_API  EXPRT int  IMPRT LTSTD_errno,LTSTD_nerr,LTSTD_errthresh;
extern STD_API const char ** EXPRT IMPRT LTSTD_errlist;

extern STD_API void  EXPRT LTSTD_perror(const char* s);
#ifdef macintosh
#pragma export on
#endif
extern STD_API void EXPRT LTSTDError(int errn,int severity,const char *floc,int nloc);
extern STD_API void EXPRT LTSTD_set_error_handler(void (*error_handler)(int));
#ifdef macintosh
#pragma export off
#endif
const char * EXPRT strErr(void);

#include "lt-errmsg.h"

#define SHOULDNT_ERROR LESHOULDNT
#define SHOULDNT LTSTDError(SHOULDNT_ERROR,2,__FILE__,__LINE__)

#endif /* LTSTD_ERR_H */
