#ifndef _steve_memory_h

#include "lt-defs.h"

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#else
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#endif
#ifdef USE_BOEHM_GC
#include <gc.h>
#define malloc GC_malloc
#define realloc GC_realloc
#define free GC_free
#endif

#define tsalloc(TYPE, NUM) \
 (TYPE *)salloc(sizeof(TYPE)*(NUM))

#define tsrealloc(TYPE, PTR, NUM) \
 (TYPE *) srealloc((PTR), (sizeof(TYPE)*(NUM)))

#define tmalloc(TYPE, NUM) (TYPE *)malloc(sizeof(TYPE)*(NUM))
#define trealloc(TYPE, PTR, NUM) (TYPE *) realloc((PTR), (sizeof(TYPE)*(NUM)))

#ifdef macintosh
#pragma export on
#endif

extern STD_API void * EXPRT salloc(unsigned x);
extern STD_API void * EXPRT srealloc(void *ptr, unsigned x);
extern STD_API boolean EXPRT sfree(void *ptr);

#ifdef macintosh
#pragma export off
#endif

#define _steve_memory_h
#endif
