/* Self-contained relocatable hash table */
/* Maps keys, which are sequences of Char, to integers. Key length is
   specified in Chars. */

#ifndef _rsearch_h
#define _rsearch_h

#include "lt-defs.h"

#define CharSize (sizeof(Char))
#define RHVal int
#define ValSize (sizeof(RHVal))
#define CMask '\337'

typedef struct RHashTableHdr {
  int nel;     /* max number of elements, must be power of 2 */
  int mask;    /* nel - 1, for use as mask */
  int freekey; /* Char offset from start of table of 1st free Char for keys */
  int length; /* as allocated, including header, table, keys, in bytes */
} RHashTableHdr;

typedef struct RHTEntry {
  int keyptr; /* Chars from beginning of table */
  RHVal eval;
} RHTEntry;

#define EntrySize (sizeof(RHTEntry))

extern STD_API RHashTableHdr* EXPRT rcreate(int,int);  /* number_of_elements, space_for_keys */
extern STD_API RHTEntry* EXPRT rinsert(const Char*,int,RHashTableHdr*,RHVal); /* key, key_length,
							   table, value */
extern STD_API RHTEntry* EXPRT rsearch(const Char*,int,const RHashTableHdr*); /* key, key_length,
							   table */
#if 0

/* Remove case-insensitive versions because too hard for 16-bit chars */

extern STD_API RHTEntry* EXPRT rcinsert(const Char*,int,RHashTableHdr*,RHVal); /* key, key_length,
							   table, value */
extern STD_API RHTEntry* EXPRT rcsearch(const Char*,int,const RHashTableHdr*); /* key, key_length,
							   table */
#endif

extern STD_API boolean EXPRT rmaphash(boolean(*)(RHTEntry*,const Char*,
						 void*),
		 const RHashTableHdr*,void*); /* function, table, udata */

#endif /* !_rsearch_h */
