#ifndef _steve_safe_h

#include <stdio.h>
#include <stdarg.h>
 
#ifdef macintosh
#include <stdlib.h>
#include <stat.h>
#define caddr_t long
#endif
 /* old version 
#else
#include <varargs.h>
#include <sys/types.h>
#endif
*/

#include "lt-defs.h"  /* this is for EXPRT */
#include "stdio16.h"

/* these are all defined in lt-safe.c */
/*
#ifdef __cplusplus
extern STD_API int EXPRT s_open(const char *path, int flags, ...);
#else
#ifdef macintosh
extern STD_API int EXPRT s_open(const char *path, int flags, ...);
#else
extern STD_API int EXPRT s_open();
#endif
#endif
*/
extern STD_API int EXPRT s_open(const char *path, int flags, int mode );
extern STD_API int EXPRT file_len(int fd);
extern STD_API int EXPRT file_length(const FILE *fp);
extern STD_API off_t EXPRT slseek(int fd, off_t offset, int whence, const char *filename);
extern STD_API off_t EXPRT sftell(const FILE *f,const char *filename);
extern STD_API off_t EXPRT sfseek(FILE *f,off_t pos,const char *filename);
extern STD_API FILE * EXPRT sfopen(const char *name,const char *mode);
extern STD_API FILE * EXPRT stdsfopen(const char *filename,const char *mode);
extern STD_API FILE * EXPRT sfdopen(int fd, const char *mode);
extern STD_API int EXPRT sfclose(FILE *fp);
extern STD_API int EXPRT sfflush(FILE *fp);
extern STD_API int EXPRT stdfclose(FILE *fp);
extern STD_API int EXPRT sread(int fd, char *buf, int nbyte);
extern STD_API int EXPRT sputc(char c, FILE *stream);
#define sputchar(c) sputc(c,stdout)
extern STD_API int EXPRT sfputs(const char *s, FILE *stream);
extern STD_API int EXPRT sfwrite(const void* ptr, int size, int nitems, FILE* stream);
extern STD_API int EXPRT sputw(int w, FILE *stream);
extern STD_API int EXPRT sfprintf(FILE *stream,const char *fmt,...);
extern STD_API int EXPRT sFprintf(FILE16 *stream, const char *format, ...);
extern STD_API int sFflush(FILE16 *filep);
extern STD_API int EXPRT sPutc(Char c, FILE16 *stream);
extern STD_API int EXPRT sFputs(const Char *s, FILE16 *stream);


/* the rest are in map-safe.c */
#ifndef MAP_FAILED
#define MAP_FAILED ((caddr_t) -1)
#endif
extern STD_API void * EXPRT smmap(caddr_t addr, size_t len,
 	    int prot, int flags, int fd, off_t off, const char *filename);
extern STD_API void * EXPRT mmapfile(const char *filename, int *n);
extern STD_API boolean EXPRT smunmap(caddr_t addr,int len);

const char * EXPRT strErr(void);

#define _steve_safe_h
#endif

