/* nslerr.h	-- Henry S. Thompson
   Error numbers and messages for NSL library
 */

#ifndef _NSLERR_H
#define _NSLERR_H

/* error numbers (LENERR is defined in lt-errmsg.h) */

#define NSAPPL (1+LENERR) /* Application "shouldn't happen" error */
#define NEAPPL (2+LENERR) /* Application vanilla error */
#define NWAPPL (3+LENERR) /* Application warning */
#define NEATPR (8+LENERR)	/* lost parsing attribute string */
#define NEMKPR (11+LENERR)	/* lost parsing for markup */
#define NECMNM (14+LENERR)	/* Close != open */
#define NEMEM (17+LENERR)	/* Memory allocation failed */
#define NEQUER (22+LENERR)	/* ill-formed query */
#define NEIO   (24+LENERR)	/* trying to write to an input file */

#define NSNSL (4+LENERR)	/* NSL "shouldn't happen" error */

#define NEUNDEF (5+LENERR)	/* id Missing from ddb */
#define NWOFND (10+LENERR)	/* Missing doctype */
#define NEFRFI (16+LENERR)	/* freeing a freed ... */
#define NEUNSUP (15+LENERR)	/* not supported */

#define NEPARSE (26+LENERR)	/* Parser detected error */

#define NEOFFST (27+LENERR)	/* offset not available */
#define NEARGNL (28+LENERR)	/* NULL argument */
#define NECHAR (29+LENERR)	/* char/encoding pblm */
#define NWMLMIXUP (30+LENERR)	/* Reading XML w/ NSL doctype or vice versa */

#if 0

/* These are no longer used, but I'll leave them here for now in case
   we need to resurrect any of them - RMT */

#define NEATTP (6+LENERR)	/* bogus attribute type in ddb ??? */
#define NECLAR (7+LENERR)	/* bad encoded argument */
#define NEATTS (9+LENERR)	/* bogus attribute type string */

#define NEDTNA (12+LENERR)	/* definition tag not allowed */
#define NEDDPI (13+LENERR)	/* bogus ddb PI */
#define NEIFND (18+LENERR)	/* Missing doctype */
#define NEFSER (19+LENERR)	/* Missing sgmlfile arg */
#define NEMMAP (20+LENERR)	/* mmap operation error */
#define NETWDB (21+LENERR)	/* second ddb */
#define NEMREF (23+LENERR)	/* multiply defined reference (sgmllink) */
#define NEXMLB (25+LENERR)	/* XML version mismatch */

#endif

#undef NSLNERR
#define NSLNERR (30+LENERR)

#define ECBN(call) if((call)->type==NSL_bad) return NULL

#endif

