/* ML API Function templates for public use */

#ifndef _nslfunc_h
#define _nslfunc_h

#include "nsl-defs.h"

#ifdef macintosh
#pragma export on
#endif

extern XML_API void EXPRT NSLClose(void);
extern XML_API NSL_Data * EXPRT AddItemToEnd(NSL_Item *item, NSL_Item *titem);
extern XML_API NSL_Item * EXPRT AddPCdata(NSL_Item *uitem, NSL_Doctype doctype,
				  const Char *pcdata, const Char *path);
extern XML_API const Char * EXPRT AttributeName(NSL_AttributeSummary atsum);
extern XML_API boolean EXPRT AttrExists(const NSL_Doctype doctype, const Char *name,
		       int length, const NSL_ElementSummary elts);
extern XML_API const Char * EXPRT AttrUniqueName(NSL_Doctype doctype,
				  const Char *name, int length);
extern XML_API const Char * EXPRT AttrUniqueName8(NSL_Doctype doctype,
				  const char8 *name, int length);
extern XML_API NSL_Attr * EXPRT CopyAttr(const NSL_Attr *attr, const NSL_Item *item);
extern XML_API void EXPRT CopyBit(NSL_Bit *dest, const NSL_Bit *source);
extern XML_API NSL_Data * EXPRT CopyData(const NSL_Data *data,
			   const NSL_Item *item);
extern XML_API NSL_Item * EXPRT CopyItem(const NSL_Item *item);
extern XML_API int EXPRT CurrentBitOffset(NSL_File fp);
extern XML_API int EXPRT CurrentItemOffset(NSL_File fp);
extern XML_API NSL_Doctype EXPRT DoctypeFromDdb(const char8 *filename);
extern XML_API NSL_Doctype EXPRT DoctypeFromFile(NSL_File file);
extern XML_API NSL_AttributeSummary * EXPRT 
    ElementAttributes(const NSL_ElementSummary eltsum,
		      const NSL_Doctype doctype,
		      int *numAttr);
extern XML_API boolean EXPRT 
    ElementExists(const NSL_Doctype doctype, const Char *name, int length);
extern XML_API const Char * EXPRT ElementUniqueName(NSL_Doctype doctype,
					    const Char *name, int length);
extern XML_API const Char * EXPRT ElementUniqueName8(NSL_Doctype doctype,
					     const char *name, int length);
extern XML_API NSL_Attr * EXPRT FindAttr(const NSL_Attr *attr, const Char *name);
extern XML_API NSL_AttributeSummary EXPRT FindAttrSpec(const NSL_ElementSummary elts,
						       const NSL_Doctype doctype,
						const Char *attrname);
extern XML_API NSL_AttributeSummary EXPRT
    FindAttrSumAndName(NSL_Doctype doctype, NSL_ElementSummary *elt,
		       const Char *eltname, const Char **name, int len);
extern XML_API NSL_ElementSummary EXPRT
    FindElementAndName(NSL_Doctype doctype, const Char **name, int len);
extern XML_API NSL_ElementSummary EXPRT FindElementByName(const NSL_Doctype doctype,
						  const Char *elementname);
extern XML_API void EXPRT ForceNewline(NSL_File fp);
extern XML_API int EXPRT ForceOutput(NSL_File f);
extern XML_API boolean EXPRT FreeAttr(NSL_Attr *attr, const NSL_Item *item);
extern XML_API boolean EXPRT FreeBit(NSL_Bit *bit);
extern XML_API boolean EXPRT FreeData(NSL_Data *data, const NSL_Doctype doctype);
extern XML_API boolean EXPRT FreeDoctype(NSL_Doctype doctype);
extern XML_API boolean EXPRT FreeItem(NSL_Item *item);
extern XML_API boolean EXPRT FreeQuery(NSL_Query q);
extern XML_API const Char ** EXPRT GetAttrAllowedValues(NSL_AttributeSummary atsum,
					       int *numVals);
extern XML_API NSL_Attr_Dec_Value EXPRT
    GetAttrDeclaredValue(NSL_AttributeSummary atsum);
extern XML_API NSL_ADefType EXPRT GetAttrDefaultValueType(NSL_AttributeSummary atsum);
extern XML_API const Char * EXPRT GetAttrDefVal(NSL_AttributeSummary atsum);
extern XML_API const Char * EXPRT 
    GetAttrStringVal(const NSL_Item *item, const Char *name);
#define GetAttrVal(item,char) GetAttrStringVal(item,char)
extern XML_API const void * EXPRT GetAttrValue(const NSL_Attr *refvar);
extern XML_API const Char * EXPRT GetAttrSVal(const NSL_Item *item, const Char *name);
extern XML_API NSL_EntitySummary EXPRT GetEntity(const NSL_Doctype doctype,
					 const Char *entityName);
extern XML_API NSL_Entity_DataType EXPRT GetEntityDataType(NSL_EntitySummary entsum);
extern XML_API const Char * EXPRT GetEntityValue(NSL_EntitySummary entsum);
extern XML_API Char * EXPRT GetIdVal(const NSL_Item *item);
extern XML_API NSL_Bit * EXPRT GetNextBit(NSL_File sgmlfile);
extern XML_API NSL_Item * EXPRT GetNextItem(NSL_File sgmlfile);
extern XML_API NSL_Item * EXPRT GetNextQueryItem(NSL_File infile, NSL_Query q,
					 NSL_File ofile);
extern XML_API Char     * EXPRT GetPCDataBelow(NSL_Item *item);
extern XML_API NSL_Item * EXPRT InstallData(NSL_Item *item, NSL_Data *data);
extern XML_API NSL_Data * EXPRT InstallDataTail(NSL_Data *whereto, NSL_Data *newTail);
extern XML_API NSL_Item * EXPRT ItemParse(NSL_File sgmlfile, NSL_Item *item);
extern XML_API NSL_Data * EXPRT LinkItem(const NSL_Doctype doctype, NSL_Data *dptr, NSL_Item *item);
extern XML_API NSL_Data * EXPRT LinkText(const NSL_Doctype doctype, NSL_Data *dptr, const Char* cdata);
extern XML_API NSL_Data * EXPRT MoveDataTail(NSL_Data *whereTo,NSL_Data *whereFrom);
extern XML_API boolean EXPRT NSLInit(int);
extern XML_API NSL_Name_Behaviour EXPRT NSLInitNames(NSL_Name_Behaviour);
extern XML_API boolean EXPRT
    NewAttrVal(NSL_Item *item,const Char *aname,const Char *newval);
extern XML_API NSL_Data * EXPRT NewNullNSLData(const NSL_Doctype doctype);
extern XML_API NSL_Item * EXPRT NewNullNSLItem(const NSL_Doctype doctype,
				       const Char *name, int len);
extern XML_API NSL_Data * EXPRT NewTextNSLData(const NSL_Doctype doctype,
				       const Char *text, int len, boolean copy,
				       const NSL_Data *nextptr,boolean insert);
extern XML_API NSL_Item * EXPRT NewItemNSLData(const NSL_Doctype doctype,
				       const Char *name, int len,
				       const NSL_Data *nextptr,boolean insert);
extern XML_API NSL_Data * EXPRT
    NextDFSNoChildren(const NSL_Data *dptr, boolean noText);
extern XML_API NSL_Item * EXPRT ObtainItem(const NSL_Data *data,
				   const Char *itemname, size_t len);
extern XML_API NSL_Item * EXPRT ParentItem(const NSL_Item *item);
extern XML_API boolean EXPRT ParseInit(void);
extern XML_API NSL_Query EXPRT ParseQuery(NSL_Doctype doctype, const Char *qu);
extern XML_API NSL_Query EXPRT ParseQueryR(NSL_Doctype doctype, const Char *qu);
extern XML_API NSL_Query EXPRT ParseQuery8(NSL_Doctype doctype, const char8 *qu);
extern XML_API NSL_Query EXPRT ParseQueryR8(NSL_Doctype doctype, const char8 *qu);
extern XML_API const Char * EXPRT
    ParseRCData(const NSL_Doctype doctype, const Char *rcdata,
		const Char *(*expandSData) (const NSL_Doctype, const Char *));
extern XML_API int EXPRT PrintBit(NSL_File fp, const NSL_Bit *bit);
extern XML_API int EXPRT PrintStartTag(NSL_File fp, const Char *label);
extern XML_API int EXPRT PrintEndTag(NSL_File fp, const Char *label);
extern XML_API int EXPRT PrintItemStartTag(NSL_File fp,const NSL_Item *item);
extern XML_API int EXPRT PrintItem(NSL_File f, const NSL_Item *item);
extern XML_API int EXPRT PrintText(NSL_File fp, const Char *text);
extern XML_API int EXPRT PrintTextLiteral(NSL_File f, const Char *text);
extern XML_API int EXPRT 
    PutAttrVal(NSL_Item *item,const Char *aname,const Char *newval);
extern XML_API int EXPRT ResetSource(NSL_File sf);
extern XML_API boolean EXPRT
    RetrieveQueryData(NSL_Item *uitem, NSL_Query query,
		      const NSL_Data **fromRet, boolean noText);
extern XML_API NSL_Item * EXPRT RetrieveQueryItem(NSL_Item *uitem, NSL_Query query,
					  const NSL_Item *from);
extern XML_API boolean EXPRT SetAttrValue(NSL_Attr *refvar, const Char *valin);
extern XML_API NSL_File EXPRT OpenURL(const char8 *url, NSL_Doctype dtype,
				   NSL_FType type, CharacterEncoding encoding,
				      const char8 *base);
extern XML_API NSL_File EXPRT OpenStream(FILE *fp, NSL_Doctype dtype,
				    NSL_FType type, CharacterEncoding encoding,
					 const char8 *name);
extern XML_API NSL_File EXPRT OpenString(Char *text,
				 NSL_Doctype dtype, NSL_FType type);
extern XML_API const char8 * EXPRT GetFileURL(NSL_File file);
extern XML_API void EXPRT SetFileURL(NSL_File file, const char8 *url);
extern XML_API NSL_Item * EXPRT GetItemFromString(const Char *text,
					  NSL_Doctype dtype);
extern XML_API NSL_File EXPRT SFFopen(FILE *fp, NSL_Doctype dtype,
			      NSL_FType type, const char8 *fname);
extern XML_API boolean EXPRT SFFreopen(NSL_File file, FILE *filep);
extern XML_API int EXPRT SFclose(NSL_File f);
extern XML_API NSL_File EXPRT SFopen(const char8 *fname, NSL_Doctype dtype,
			     NSL_FType type);
extern XML_API int EXPRT SFrelease(NSL_File sf, boolean releaseDoctype);
extern XML_API int EXPRT SFseek(NSL_File sf, size_t pos);
extern XML_API size_t EXPRT SFtell(NSL_File sf);
extern XML_API int EXPRT ReadProlog(NSL_File sf);
extern XML_API boolean EXPRT DocumentIsNSGML(NSL_Doctype dct);
extern XML_API NSL_Element_Content EXPRT ElementContent(NSL_Doctype doctype, 
						  NSL_ElementSummary eltsum, 
						  const Char **model);
extern XML_API NSL_Element_Content EXPRT ElementFullContent(
    NSL_Doctype doctype, 
    NSL_ElementSummary eltsum, 
    const Char **model,
    const struct content_particle **particle);
extern XML_API NSL_Common_Options * EXPRT NSLGetoptions(
    int *argcp, char **argv, 
    const char *opts, void (*usage)(int exitval));

/* ??? why did I spell this with a lower-case 'o'? - probably
   becuase of getopt. RMT */
#define NSLGetOptions NSLGetoptions

extern XML_API NSL_Doctype EXPRT LoadDoctype(const char8 *filename);

extern XML_API void EXPRT NSLSetErrorHandler(void (*error_handler)(int));

extern XML_API const char8 * EXPRT LookupPrefix(const NSL_Item *item, const Char *prefix);

/* User supplied function to define meaning of ? operator in queries */
/* Is EXPRT in the right place ? */

extern XML_API boolean (* EXPRT LTNSL_User_defined_comparison)(const Char* ival, 
						       const Char* qval);

#ifdef macintosh
#pragma export off
#endif

#endif
