/* Structure of .ddb files to store DTD information for parsing */

#ifndef _ht_ddb_h

#include <time.h>         /* for time_t */

/* Note that structures below are directly in file, usually followed by
   unstructured data described in comments at end of the structure itself */

#if CHAR_SIZE == 8
#define CookieVal (0x04021e36)
                   /* "^d^b" plus some random bits
		      Incremented 28/3/96 following incompatible change
		      to file format (addition of anameTable) */
                   /*  Incremented 10/10/96 following merger with
		      modified version for DDB which contains
		      allowedValuesPtr in attribute summaries */
#else
#define CookieVal (0x04021f36)
		   /* Different 3rd byte for DDBs containing 16-bit Chars */
#endif

typedef struct DDBHeader {
  unsigned int cookie; /* will be set to CookieVal */
  time_t timestamp;
  long int ddblength; /* Length of memory mapped DDB file */
  int sourceFileNameOffset; /* in bytes from beginning of file */
  int dtdFileNameOffset;   /* ditto or 0 if no dtd file as such */
  int anameTableOffset;   /* in bytes from beginning of file or zero if none */
  int elementTableOffset;  /* in bytes from beginning of file */
  int entityTableOffset;   /*          ditto or zero if none    */
  /* 0 terminated Char string which is the name of the DOCTYPE */
  /* 0 terminated char string which is the source file name */
  /* maybe 0 terminated char string which is the dtd file name */
  /* maybe some padding to get to word boundary */
  /* aname table: an RHashTable */
  /* element table:  an RHashTable plus ElementSummaries */
  /* optional entity table: an RHashTable plus EntitySummaries*/
} DDBHeader;

#define HdrSize (sizeof(DDBHeader))

/* NB must match ContentType in Richard's parser */
typedef enum { dc_mixed, dc_any, dc_cdata,
		 dc_rcdata, dc_empty, dc_element } ctVals;

typedef struct NSL_ElementSummary_I {
  int numAttr;			/* If < 0, indicates (-index)-1 attrs,
				   indeterminate number more offboard
				   chained from indexth entry in
				   doctype->offAttrsBase */
  char contentType; /* cast from ElementDefinition::DeclaredContent,
		       with modelGroup split into mixed and element[sc. only]
		       per nature of actual model group:
		       recapitulated as dcVals above */
  char omitStart;   /* NB re-used in Richard's parser XXX */
  char omitEnd;
  /* other flags? */
  /* array of AttributeSummaries */
  /* default strings for ASs */
} NSL_ElementSummary_I;

#define EltSize (sizeof(NSL_ElementSummary_I))

/* Values of AttributeSummary.declaredValue */

typedef enum{ NSL_Attr_cdata, NSL_Attr_name, NSL_Attr_number, 
	      NSL_Attr_nmtoken, NSL_Attr_nutoken, NSL_Attr_entity, 
	      NSL_Attr_idref, NSL_Attr_names, NSL_Attr_numbers,
	      NSL_Attr_nmtokens, NSL_Attr_nutokens, NSL_Attr_entities, 
	      NSL_Attr_idrefs, NSL_Attr_id, NSL_Attr_notation,
	      NSL_Attr_nameTokenGroup } NSL_Attr_Declared_Value;

/* NB this must match AttributeDefinition in Richard's parser */
typedef struct AttributeSummary {
  int namePtr;   /* Char offset from beginning of atsum */
  int defaultPtr; /* Char offset from beginning of atsum */
  int allowedValuesPtr;   /* Char offset from beginning of atsum */
                          /* Only non-zero for attributes nametokengroup
			     or notation */
  unsigned short int numAV;	/* Number of allowedValues */
  char declaredValue;  /* cast from AttributeDefinitionDesc:DeclaredValue */
  char defaultValueType;  /* cast from
			     AttributeDefinitionDesc:DefaultValueType */
} AttributeSummary;  

#define AttrSize (sizeof(AttributeSummary))

typedef enum {ent_internal, ent_system, ent_public, ent_resolved} DefnType;

typedef struct EntitySummary {
  char declType;  /* cast from Entity::DeclType */
  char dataType;  /* cast from Entity::DataType */
  char defType; /* cast from DefType */
  /* XXX Oh dear, the string won't be 16-bit aligned.  Pad it, but
     only for 16-bit system to maintain DDB file compatibility. */
#if CHAR_SIZE == 16
  char pad;
#endif
  /* 0 terminated definition string: actual contents or filename */
} EntitySummary;

#define EntSize (sizeof(EntitySummary))

#define _ht_ddb_h

#endif /* _ht_ddb_h */
