#ifndef _steve_umalloc_h
#define _steve_umalloc_h

#include "lt-memory.h"

typedef struct UStack {
    void **stack;
    void *itembase;
    int stacksize;
    int stackpointer;
    int itemsize;
    struct UStack *next;
    struct UStack *prev;
} UStack;

typedef struct Umalloc {
    int totalstacksize;
    int itemsize;
    int percentincrement;
    UStack *stack;
    const char* name;
} Umalloc;

extern STD_API Umalloc * EXPRT Uinit(int itemsize, int stacksize, int percent);
extern STD_API void EXPRT NameUmalloc( Umalloc *, const char *);
extern STD_API void * EXPRT Usalloc(Umalloc *umalloc);
extern STD_API int EXPRT Ufree(Umalloc *umalloc, void *ptr);
extern STD_API boolean EXPRT FreeUmalloc( Umalloc * );

#endif /* _steve_umalloc_h */


