#ifndef _QUERY_H
#define _QUERY_H

#include "hsregexp.h"

typedef enum {_qa_comp_error, _qa_comp_no_op, _qa_comp_equal,
	      _qa_comp_not_equal, _qa_comp_regexp, _qa_comp_not_regexp,
	      _qa_comp_less, _qa_comp_not_less, _qa_comp_greater,
	      _qa_comp_not_greater, _qa_comp_user_defined,
	      _qa_comp_not_user_defined } QAComparisontype;

typedef struct NSL_Q_Attr {
  /*  QAtype type; */
  QAComparisontype comparison;
  const Char *name;                      /* name of attribute */
  union {
    const Char *string;
    const regexp *regexp;
  } pattern;                         /* actual value */
  struct NSL_Q_Attr *next;          /* list link */
#if CHAR_SIZE == 16
  char8 *transbuf;
#endif
} NSL_Q_Attr;


typedef enum {_query_eof,_query_err,_query_win,_query_lose} Query_Result;

typedef enum {_qu_norm, _qu_star, _qu_any, _qu_anystar, _qu_data} Qtype;

typedef struct NSL_Query_I {
  int number;
  const Char *elname;
  NSL_ElementSummary elt;
  NSL_Q_Attr *alist;
  Qtype type;
  NSL_Name_Behaviour stringType;     /* If NSL_use_names then element and 
					attribute names are unique names. 
					If NSL_use_strings they are strings 
					and we use strcasecmp to compare */
  const struct NSL_Query_I *next;
  const struct NSL_Query_I *prev;
  const struct NSL_Query_I *alt;     /* An alternative element description */
} NSL_Query_I;

#endif
