#
# $Id: TreeBuilder.pm,v 1.2 2000/10/05 20:54:10 kmacleod Exp $
#

use strict;

package Class::Orchard::TreeBuilder;
use vars qw{ $AUTOLOAD $VERSION };

$VERSION = "0.03";

sub new {
    my $type = shift;

    return bless {Stack => []}, $type;
}

sub AUTOLOAD {
    my ($self, $node) = @_;

    return if $AUTOLOAD =~ /::DESTROY$/;

    $AUTOLOAD =~ s/.*:://;

    if ($AUTOLOAD =~ /^start_/) {
	if ($#{ $self->{Stack} } != -1) {
	    push @{ $self->{Stack}[-1]{Contents} }, $node;
	}
	push @{ $self->{Stack} }, $node;
    } elsif ($AUTOLOAD =~ /^end_/) {
	return pop @{ $self->{Stack} };
    } else {
	if ($#{ $self->{Stack} } == -1) {
	    die "Data event received before any start_* events.\n";
	}
	push @{ $self->{Stack}[-1]{Contents} }, $node;
    }
}

1;
