#!/usr/local/bin/ruby
# Tiny Tiny eRuby --- ERb
# 	Copyright (c) 1999-2000,2002 Masatoshi SEKI 
#       You can redistribute it and/or modify it under the same term as Ruby.

require 'erb/strio.rb'
require 'erb/compile'

class ERb
  Revision = '$Date: 2002/03/14 16:23:43 $'

  def self.version
    "erb.rb [1.4.1 #{ERb::Revision.split[1]}]"
  end

  def initialize(str, safe_level=nil, trim_mode=nil)
    compiler = ERbCompiler.new
    compiler.trim_mode = trim_mode
    compiler.put_cmd = 'print'
    @src = compiler.compile(str)
    @safe_level = safe_level
  end
  attr :src

  def run(b=TOPLEVEL_BINDING)
    if @safe_level
      print self.result(b)
    else
      eval(@src, b)
    end
  end

  def result(b=TOPLEVEL_BINDING)
    if @safe_level
      safesrc = "$SAFE = #{@safe_level}\n" + @src
      ERbStrIO.as_stdout { eval(safesrc, b) }
    else
      ERbStrIO.as_stdout { eval(@src, b) }
    end
  end
end

if __FILE__ == $0
  require 'erb/main'

  ERbModule.run(ERb)
end
