#!/usr/bin/env ruby

require "rss/parser"
require "rss/1.0"
require "rss/0.9"

channels = {}
verbose = false

def error(exception)
	mark = "=" * 20
	mark = "#{mark} error #{mark}"
	puts mark
	puts exception.class
	puts exception.message
	puts exception.backtrace
	puts mark
end

before_time = Time.now
ARGV.each do |fname|
	if fname == '-v'
		verbose = true
		next
	end
	rss = nil
	f = File.new(fname).read
	begin
		## do validate parse
		rss = RSS::Parser.parse(f)
	rescue RSS::InvalidRSSError
		error($!) if verbose
		## do non validate parse for invalid RSS 1.0
		rss = RSS::Parser.parse(f, false)
	rescue RSS::Error
		error($!) if verbose
	end
	if rss.nil?
		puts "#{fname} does not include RSS 1.0 or 0.9x/2.0"
	else
		begin
			rss.output_encoding = "euc-jp"
		rescue RSS::UnknownConvertMethod
			error($!) if verbose
		end
		rss.items.each do |item|
			unless channels.has_key?(rss.channel.title)
				channels[rss.channel.title] = []
			end
			channels[rss.channel.title] << item if item.description
		end
	end
end
processing_time = Time.now - before_time

channels.sort do |x, y|
	x[0] <=> y[0]
end[0..20].each do |title, items|
	puts "Channel : #{title}" unless items.empty?
	items.sort do |x, y|
		x.title <=> y.title
	end[0..10].each do |item|
		more = ''
		more << ' ...' if item.title.size > 51
		puts "  Item : #{item.title[0...50]}#{more}"
		more = ''
		more << ' ...' if item.description.size > 51
		puts "    Description : #{item.description[0...50]}#{more}"
	end
end

puts "Processing Time : #{processing_time}s"
