#!/usr/bin/env ruby

require "rss/parser"
require "rss/1.0"
require "rss/syndication"
require "rss/dublincore"

items = []
verbose = false

def error(exception)
	mark = "=" * 20
	mark = "#{mark} error #{mark}"
	puts mark
	puts exception.class
	puts exception.message
	puts exception.backtrace
	puts mark
end

before_time = Time.now
ARGV.each do |fname|
	if fname == '-v'
		verbose = true
		next
	end
	rss = nil
	f = File.new(fname).read
	begin
		## do validate parse
		rss = RSS::Parser.parse(f)
	rescue RSS::InvalidRSSError
		error($!) if verbose
		## do non validate parse for invalid RSS 1.0
		rss = RSS::Parser.parse(f, false)
	rescue RSS::Error
		error($!) if verbose
	end
	if rss.nil?
		puts "#{fname} does not include RSS 1.0"
	else
		begin
			rss.output_encoding = "euc-jp"
		rescue RSS::UnknownConvertMethod
			error($!) if verbose
		end
		rss.items.each do |item|
			items << [rss.channel, item] if item.dc_date
		end
	end
end
processing_time = Time.now - before_time

items.sort do |x, y|
	y[1].dc_date <=> x[1].dc_date
end[0..20].each do |channel, item|
	puts "#{item.dc_date.localtime.iso8601} : " <<
		"#{channel.title} : #{item.title}"
	puts " description : #{item.description[0..50]} ..." if item.description
end

puts "Processing Time : #{processing_time}s"
