=begin
= WebUnit::Param/...
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: params.rb,v 1.1.1.1 2002/03/29 15:13:22 yuichi Exp $
=end

module WebUnit

  class Param < HtmlElem

    attr_reader :name, :type, :relations
    attr_accessor :stat, :value

    def initialize( tag, ah )
      super
      @type = ah["type"] ? ah["type"] : 'text'
      @value = ah["value"]
      @relations = []
      @stat = ah.key?( 'checked' ) ? 'on' : 'off'
    end

    def update( p )
      @relations << p
    end

    def query_data
      value = @value ? CGI::escape( @value ) : ''
      @name ? ( CGI::escape( @name ) + '=' + value ) : nil
    end

  end

  class Input < Param

    def initialize( ah )
      super( 'input', ah )
    end

    def on
      @stat = 'on'
    end

    def off
      @stat = 'off'
    end

    def inspect
      a = super + "[stat:#{@stat}]"
    end

  end

  class InputRadio < Input

    def on
      @stat = 'on'
      @relations.each do |r|
        r.off
      end
    end

    def query_data
      value = @value ? CGI::escape( @value ) : ''
      @stat == 'on' ? CGI::escape( @name ) + '=' + value : nil
    end

    def value=( v )
      self.stat = self.value == v ? 'on' : 'off'
      @relations.each do |e|
        e.stat = e.value == v ? 'on' : 'off'
      end
    end

  end

  class InputCheckbox < Input

    def query_data
      value = @value ? CGI::escape( @value ) : 'on'
      @stat == 'on' ? @name + '=' + value : nil
    end

  end

  class InputSubmit < Input

    def query_data
      value = CGI::escape( @value ? @value : 'Submit Query' )
      @name ? @name + '=' + value : nil
    end

  end

  class InputImage < Input

    attr_writer :x, :y

    def query_data
      CGI::escape( @name ) + '.x=' + @x.to_s + '&' +
      CGI::escape( @name ) + '.y=' + @y.to_s
    end

  end

  class InputReset < Input

    def query_data
      nil
    end

  end

  class Select < Param

    attr_reader :options

    def initialize( ah )
      super( 'select', ah )
      @options = []
      @size = ah["size"]
      @type = 'select'
    end

    def add_option( option )
      @options.push( option )
    end

    def end_option
      if @size == nil && @options.reject { |o| o.stat == 'off' } == []
        @options[0].select
      end
    end

    def select( arr )
      @options.each do |o|
        o.deselect
      end
      arr.each do |e|
        @options[e].select if e.kind_of?( Integer )
        if e.kind_of?( String )
          @options.each do |o|
            o.select if o.value == e || o.data == e
          end
        end
      end
    end

    def query_data
      a = []
      @options.each do |o|
        a << o.query_data( @name )
      end
      s = a.compact.join('&')
      s == '' ? nil : s
    end

    def value
      arr = []
      @options.each do |o|
        arr << o.value if o.stat == 'on'
      end
      case arr.size
        when 0 then nil
        when 1 then arr[0]
        else arr
      end
    end

    def value= ( v )
      @options.each do |o|
        if o.value == v
          o.select
        else
          o.deselect
        end
      end
    end

  end

  class SelectOption < HtmlElem

    attr_reader :stat

    def initialize( ah )
      super( 'option', ah )
      @value = ah["value"]
      @stat = ah.key?( 'selected' ) ? 'on' : 'off'
      @type = 'option'
    end

    def value
      @value ? @value : @data
    end

    def select
      @stat = 'on'
    end

    def deselect
      @stat = 'off'
    end

    def query_data( name )
      @value = @data unless @value
      value = @value ? CGI::escape( @value ) : ''
      @stat == 'on' ? CGI::escape( name ) + '=' + value : nil
    end

  end

  class Textarea < Param

    def initialize( ah )
      super( 'textarea', ah )
      @type = 'textarea'
    end

    def value
      @value ? @value : @data
    end

  end

end
