=begin
= WebUnit::TestCase
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: testcase.rb,v 1.1.1.1 2002/03/29 15:13:21 yuichi Exp $
=end

require 'runit/testcase'

module WebUnit

  class TestCase < RUNIT::TestCase

    include WebUnit
    include Utils

    def initialize( method, name=self.type.name )
      super
      @urlbase = ENV['URLBASE'] ? ENV['URLBASE'] : 'http://localhost/'
      @urlbase = orthop_url( @urlbase )
      @urlbase << '/' unless @urlbase =~ %r!/$!
      $stderr.puts "URLBASE is #{@urlbase}" if $DEBUG
    end

    def setup
      $URLBASE = @urlbase
      Response::reset
      @cookies_kept = Cookies::instance.cookies
    end

    def teardown
      Response::reset
      Cookies::instance.cookies = @cookies_kept
    end

  end

end
